'------------------------------------------------------------------------------
'AVR-ATTV83.bas         Automatic Transistor Tester Version 8.1
'
'Historie:
'
'
'V8:   21.12.08
'      Erste erprobte Version nach prinzipiellem Test
'
'V8.1: 21.11.10
'      Variablen Test-Basisstrom bei bipolaren Transistoren eingefhrt,
'      weil Transistoren mit geringem Beta nicht eindeutig erkannt wurden.
'      BetaRange 0...4, entspricht RB = 330K ... 3K3.
'
'V8.2  15.12.10
'      Timer0 fr Abschalten benutzt,
'      weil die Programmzyklen jetzt sehr unterschiedlich lang sind
'
'V8.3  06.01.11
'      Fr Abschaltroutine alle Basiswiderstnde auf Null Volt.
'
'-------------------------------------------------------------------------------
'Hardware:     Stromlauf TransTester.dsn

'              LCD Display Batron BT22005V von Pollin:
'
'              20x2 LCD-Anzeige
'              LCD-Verbindungen:

'              LCD01 an Masse (VSS)
'              LCD02 an +5V   (VDD)
'              LCD03 an Poti  (VLC)
'              LCD04 an PD5   (RS)
'              LCD05 an Masse (RW)
'              LCD06 an PD4   (E)
'              LCD07 an Masse (VSS)
'              LCD08 an Masse (VSS)
'              LCD09 an Masse (VSS)
'              LCD10 an Masse (VSS)
'              LCD11 an PD0   (DB4)
'              LCD12 an PD1   (DB5)
'              LCD13 an PD2   (DB6)
'              LCD14 an PD3   (DB7)

'Der RW-Eingang der LCD-Anzeige wird fest auf Masse gelegt.
'
'------------------------------------------------------------------------------
'Portbelegung: PortB Basiswiderstnde:
'
'              PortB.0 = 10M, Output oder Input ohne Pullup
'              PortB.1 = 3M3, Output oder Input ohne Pullup
'              PortB.2 = 1M0, Output oder Input ohne Pullup
'              PortB.3 = 330K, Output oder Input ohne Pullup
'              PortB.4 = 100K, Output oder Input ohne Pullup
'              PortB.5 = 33K, Output oder Input ohne Pullup
'              PortB.6 = 10K, Output oder Input ohne Pullup
'              PortB.7 = 3K3, Output oder Input ohne Pullup
'
'              PortC Testpinsteuerung
'
'              PortC.0 = X0, Output
'              PortC.1 = X1, Output
'              PortC.2 = X2, Output
'              PortC.3 = X0 . 1K, Output
'              PortC.4 = X1 . 1K, Output
'              PortC.5 = X2 . 1K, Output
'              PortC.6 = nv
'              PortC.7 = nv
'
'              PortD LCD Display und Analogschalter:
'
'              PortD.0 = Db4, Output, doppelt genutzt als Taster Input
'              PortD.1 = Db5, Output
'              PortD.2 = Db6, Output
'              PortD.3 = Db7, Output
'              PortD.4 = E, Output
'              PortD.5 = RS, Output
'              PortD.6 = Analogschalter Adr A
'              PortD.7 = Analogschalter Adr B
'
'-------------------------------------------------------------------------------
'Funktionsbeschreibung:
'siehe Dokument TransistorTester.doc
'-------------------------------------------------------------------------------
'Compiliert mit Bascom 1.11.8.3, 8170 Bytes, 99%
'-------------------------------------------------------------------------------

$PROG &HFF , &H24 , &HD1 , &H00              'int Osz 8MHz, BODLEVEL 4.0V,BODEN enabled

$regfile = "m8def.dat"
$crystal = 8000000                           '8,00000 MHz interner Oszillator

$hwstack = 70                                'default use 32 for the hardware stack 60
$swstack = 40                                'default use 10 for the SW stack       30
$framesize = 90                              'default use 40 for the frame space

'------------------------------------------------------------------------------
'Variablen

Dim TypStr As String * 22                    'Bezeichnung Transistortyp
Dim PinStr(24) As String * 4                 '24 verschiedene Pin-Bezeichnungen
Dim Pause As Byte                            'Paus fr Debug-Mode
Dim X As Byte                                'Programmablauf Variable
Dim OldX As Byte                             'alter Zustand des Aktivitts Flag
Dim T As Byte                                'Testschritte
Dim P As Byte                                'Pinstring Pointer
Dim M As Word                                'Multiplikator, Basisvorwiderstand in KOhm
Dim Dar As Byte                              'Sonderfall Darlington Transistor
Dim FET As Byte                              'Sonderfall FET
Dim JFET As Byte                             'Sonderfall JFET
Dim UX As Word                               'Spannung an Pin (X0, X1 o. X2)
Dim UD As Word                               'Durchlassspannung bei Diode
Dim UTH As Word                              'Schwellenspannung bei FET
Dim URB As Word                              'Spannung am Basisvorwiderstand
Dim IB As Byte                               'Basisstrom
Dim URC As Word                              'Spannungsabfall am Kollektorwiderstand
Dim UXL As Long                              'Spannung fr Anzeige am LCD
Dim UCO1 As Long                             'JFET CutOff-Spannung bei Beschaltung 1
Dim UCO2 As Long                             'JFET CutOff-Spannung bei Beschaltung 2
Dim UXLStr As String * 5                     'Text von UXL
Dim UXLLStr As String * 1                    'Vorkommatext von UXL
Dim UXLRStr As String * 2                    'Nachkommatext von UXL
Dim URCM As Long                             'Collektorspannung*Multiplikator
Dim Beta As Long                             'Stromverstrkung bipolar Transistor
Dim SPUp As Byte                             'Single Pull Up Ergebnis
Dim Button As Byte                           'Tasten-Zustand
Dim AltDispl As Byte                         'alternative Anzeige
Dim OldButt As Byte                          'Tasten-Zustand vorher
Dim PwrDnCtr As Byte                         'Power Down Zhler
'Dim PwrDnCtr As Word                         'Power Down Zhler
Dim BetaRange As Byte                        'Beta Range Flag

'------------------------------------------------------------------------------

'Ausgabe-Ports

 DDRB = &B00000000                           'PortB alles Input bei Start
PORTB = &B00000000                           'Alle Inputs ohne Pullup

 DDRC = &B00000000                           'PortC alles Input bei Start
PORTC = &B00000000                           'Alle Inputs ohne Pullup

 DDRD = &B11111111                           'Alles Output, fr LCD und Decoder
PORTD = &B01000000                           'Decoder Adresse 01, Rest 0

'------------------------------------------------------------------------------

 Config Lcd = 20 * 2                         'LCD Konfiguration

 Config Lcdpin = Pin , Db4 = PortD.0 , Db5 = PortD.1 , Db6 = PortD.2 , Db7 = PortD.3 , E = PortD.4 , Rs = PortD.5

'------------------------------------------------------------------------------
 'On Timer0 IncrPwrDn                         'Interrupt-Routine fr Abschaltzhler
 'Config Timer0 = Timer , Prescale = 1024     'Takt=1000000/1024 --> 1,024ms
 'Timer0 = 12                                 'Interrupt alle 250ms

 On Timer1 IncrPwrDn                         'Interrupt-Routine fr Abschaltzhler
 Config Timer1 = Timer , Prescale = 1024     'Takt=1000000/1024 --> 1,024ms
 Timer1 = 63583                              'Interrupt alle 250ms

 'Enable Timer0
 Enable Timer1
 Enable Interrupts

 Config Adc = Single , Prescaler = Auto

'------------------------------------------------------------------------------

'Pin String Definitionen

  PinStr(1) = "CBE"
  PinStr(2) = "BCE"
  PinStr(3) = "CBE"
  PinStr(4) = "BCE"
  PinStr(5) = "CEB"
  PinStr(6) = "BEC"
  PinStr(7) = "CEB"
  PinStr(8) = "BEC"
  PinStr(9) = "ECB"
  PinStr(10) = "EBC"
  PinStr(11) = "ECB"
  PinStr(12) = "EBC"

  PinStr(13) = "DGS"
  PinStr(14) = "GDS"
  PinStr(15) = "DGS"
  PinStr(16) = "GDS"
  PinStr(17) = "DSG"
  PinStr(18) = "GSD"
  PinStr(19) = "DSG"
  PinStr(20) = "GSD"
  PinStr(21) = "SDG"
  PinStr(22) = "SGD"
  PinStr(23) = "SDG"
  PinStr(24) = "SGD"

'------------------------------------------------------------------------------

 Cls                                         'Display lschen
 Cursor Off                                  'LCD-Kursor ausschalten

 'Pause = 1                                   'Debug Pause einschalten

 LCD "     Automatic "                       'Logo Ausgabe
 Home Lower
 LCD "Transistor Test V8.3"

 Wait 1

 GoSub ReadButt                              'Abfrage der Taste

 IF Button = 0 Then                          'wenn Taste gedrckt
   CLS
   LCD "  Test-Mode aktiv!"                  'Test-Mode anzeigen
   Pause = 1                                 'Debug Pause einschalten
   GoSub Taste2                              'Warte bis Taste losgelassen
 End If

 Start ADC

 Main:

 'Locate 1 , 16
 'LCD PwrDnCtr ; "     "
 'LCD X

 GoSub ReadButt                              'Abfrage der Taste

 IF Button = 0 Then                          'wenn Taste gedrckt
   IF OldButt <> Button Then                 'vorher noch nicht
     AltDispl = Not AltDispl                 'Displayumschaltung
     PwrDnCtr = 0                            'Lsche Power Down
   Else                                      'vorher auch schon
     IF PwrDnCtr > 4 Then GoTo PwrDn         'Abschalten
   End If
 End If
 OldButt = Button                            'Speichere Taste

 IF Pause = 1 Then GoSub Taste1              'Bei Pause warten auf Taste

 Dar = 0                                     'Initialisierung
 FET = 0
 T = 0
 BetaRange = 0

 IF X = OldX Then                            'Typ/Pin Config unverndert
   'IF PwrDnCtr > 960 Then GoTo PwrDn         'Abschalten
   IF PwrDnCtr > 120 Then GoTo PwrDn         'Abschalten
 Else                                        'Aktiv-Flag gesetzt
   PwrDnCtr = 0                              'Lsche Power Down
 End If
 OldX = X                                    'merke aktuelle Typ/Pin Config

NxtBetaTest:

'Zuordnung der Testpins:  Pin Name   X2   X1    X0   Anordnung in dieser Weise
'Niederohmiger Anschluss: PortC      .2   .1    .0
'Anschluss ber RC = 1K:  PortC      .5   .4    .3
'Adresse fr RB Multiplexer:         10   01    00

'X0 ist Common (Emitter, Source)

'1. CBE NPN  CB---E                           X0=Emitter/Source, X1=Basis/Gate, X2=Kollektor/Drain
 X = 1                                       'Typ/Pin Config = 1
  DDRC = &B00110001                          'Outputs RC2, RC1 u. X0 aktivieren, Rest hochohmig
 PORTC = &B00100000                          'X2=Hi . RC2, X1=Lo . RC1, X0=Lo
 Gosub SetNPNIB0                             'Basisstrom abschalten
 Gosub Warte                                 'T1.1
 IF PinC.2 = 1 Then                          'Collektor Hi?
   PORTC = &B00110000                        'X2=Hi . RC2, X1=Hi . RC1, X0=Lo
   Gosub Warte                               'T1.2
   IF PinC.2 = 0 Then                        'Collektor Lo?
     Gosub MesseUX1                          'Basisspannung an X1 messen
     GoSub SetRBtoX1                         'Basiswiderstand an X1
     Gosub TestNPN                           'Test auf Darlington o. FET und RB=100K
     IF FET = 0 Then                         'Messe Beta
        DDRC = &B00100001                    'Output RC1 deaktivieren
       PORTC = &B00100000                    'bei NPN Pullup an RC1 abschalten
       Gosub Warte                           'T1.3a
       IF Dar = 1 Then GoTo Darl1            'Wenn Darlington, Collektor gefunden
       IF PinC.2 = 0 Then                    'Wenn X2 noch Lo, Collektor gefunden
       Darl1:
         GoSub SetIB0                        'Starte mit kleinstem Basisstrom
         Do                                  'wiederhole
           Gosub IncrIB                      'Basisspannung erhhen
           Gosub SetNPNIB                    'und Ports setzen
           Gosub Warte                       'T1.4...
           Gosub MesseUX2                    'Collektorspannung an X2 messen
         Loop Until UX < 613                 'bis Collektorspannung < 3V
         GoSub ComplURC                      'URC = 5V - UX
         Gosub MesseUX1                      'Basisspannung an X1 messen
         GoSub ComplURB                      'URB = 5V - UX
         GoTo CalcBeta                       'Gehe zur Beta-Berechnung
       End If
     Else                                    'Messe UTH
        DDRC = &B00011100                    'Outputs X2, RC1 u. RC0 aktivieren, von 12
       PORTC = &B00010100                    'X1=Hi . RC1, X0=Lo . RC0, X2=Hi
       Gosub Warte                           'T1.3b
       Gosub MesseUX0                        'Sourcespannung an X0 messen
       GoSub ComplUTH                        'Schwellenspannung UTH=5V-UX
       'UTH = UX                              'Schwellenspannung
       GoTo DisplFET                         'Gehe zur FET-Anzeige
     End If
   End If
 End If

'2. BCE NPN  BC---E                           X0=Emitter/Source, X1=Kollektor/Drain, X2=Basis/Gate

 GoSub NextTPC                               'Increment X, T=0
  DDRC = &B00110001                          'Outputs RC2, RC1 u. X0 aktivieren, wie 1.
 PORTC = &B00010000                          'X2=Lo . RC2, X1=Hi . RC1, X0=Lo
 Gosub SetNPNIB0                             'Basisstrom abschalten
 Gosub Warte                                 'T2.1
 IF PinC.1 = 1 Then                          'Collektor Hi?
   PORTC = &B00110000                        'X2=Hi . RC2, X1=Hi . RC1, X0=Lo, wie 1.
   Gosub Warte                               'T2.2
   IF PinC.1 = 0 Then                        'Collektor Lo?
     Gosub MesseUX2                          'Basisspannung an X2 messen
     GoSub SetRBtoX2                         'Basiswiderstand an X2
     Gosub TestNPN                           'Test auf Darlington o. FET und RB=100K
     IF FET = 0 Then                         'Messe Beta
        DDRC = &B00010001                    'Output RC2 deaktivieren
       PORTC = &B00010000                    'bei NPN Pullup an RC2 abschalten
       Gosub Warte                           'T2.3
       IF Dar = 1 Then GoTo Darl2            'Wenn Darlington, Collektor gefunden
       IF PinC.1 = 0 Then                    'Wenn X1 noch Lo, Collektor gefunden
       Darl2:
         GoSub SetIB0                        'Starte mit kleinstem Basisstrom
         Do
           Gosub IncrIB                      'Basisspannung erhhen
           Gosub SetNPNIB                    'und Ports setzen
           Gosub Warte                       'T2.4...
           Gosub MesseUX1                    'Collektorspannung an X1 messen
         Loop Until UX < 613                 'bis Collektorspannung < 3V
         GoSub ComplURC                      'URC = 5V - UX
         Gosub MesseUX2                      'Basisspannung an X1 messen
         GoSub ComplURB                      'URB = 5V - UX
         GoTo CalcBeta                       'Gehe zur Beta-Berechnung
       End If
     Else                                    'Messe UTH
        DDRC = &B00101010                    'Outputs RC2, X1 u. RC0 aktivieren
       PORTC = &B00100010                    'X2=Hi . RC2, X1=Hi, X0=Lo . RC0
       Gosub Warte                           'T2.3b
       Gosub MesseUX0                        'Sourcespannung an X0 messen
       GoSub ComplUTH                        'Schwellenspannung UTH=5V-UX
       'UTH = UX                              'Schwellenspannung
       GoTo DisplFET                         'Gehe zur FET-Anzeige
     End If
   End If
 End If

'3. CBE PNP  CB---E                          X0=Emitter/Source, X1=Basis/Gate, X2=Kollektor/Drain

 GoSub NextTPC                               'Increment X, T=0
  DDRC = &B00110001                          'Outputs RC2, RC1 u. X0 aktivieren, wie 1.
 PORTC = &B00010001                          'X2=Lo . RC2, X1=Hi . RC1, X0=Hi
 Gosub SetPNPIB0                             'Basisstrom abschalten
 Gosub Warte                                 'T3.1
 IF PinC.2 = 0 Then                          'Collektor Lo?
   PORTC = &B00000001                        'X2=Lo . RC2, X1=Lo . RC1, X0=Hi
   Gosub Warte                               'T3.2
   IF PinC.2 = 1 Then                        'Collektor Hi?
     Gosub MesseUX1                          'Basisspannung an X1 messen
     GoSub SetRBtoX1                         'Basiswiderstand an X1
     Gosub TestPNP                           'Test auf Darlington o. FET und RB=100K
     IF FET = 0 Then                         'Messe Beta
        DDRC = &B00100001                    'Output RC1 deaktivieren
       Gosub Warte                           'T3.3
       IF Dar = 1 Then GoTo Darl3            'Wenn Darlington, Collektor gefunden
       IF PinC.2 = 1 Then                    'Wenn X2 noch Hi, Collektor gefunden
       Darl3:
         GoSub SetIB0                        'Starte mit kleinstem Basisstrom
         Do
           Gosub IncrIB                      'Basisspannung erhhen
           Gosub SetPNPIB                    'und Ports setzen
           Gosub Warte                       'T3.4...
           Gosub MesseUX2                    'Collektorspannung an X2 messen
         Loop Until UX > 410                 'bis Collektorspannung > 2V
         URC = UX                            'Bei PNP: URC = UX
         Gosub MesseUX1                      'Basisspannung an X1 messen
         URB = UX                            'Bei PNP: Keine Schwellenspannung abziehen
         GoTo CalcBeta                       'Gehe zur Beta-Berechnung
       End If
     Else                                    'Messe UTH
        DDRC = &B00011100                    'Outputs X2, RC1 u. RC0 aktivieren
       PORTC = &B00001000                    'X2=Lo, X1=Lo . RC1, X0=H . RC0
       Gosub Warte                           'T3.3b
       Gosub MesseUX0                        'Sourcespannung an X0 messen
       'GoSub ComplUTH                        'Schwellenspannung UTH=5V-UX
       UTH = UX                              'Schwellenspannung
       GoTo DisplFET                         'Gehe zur FET-Anzeige
     End If
   End If
 End If

'4. BCE PNP  BC---E                           X0=Emitter/Source, X1=Kollektor/Drain, X2=Basis/Gate

 GoSub NextTPC                               'Increment X, T=0
  DDRC = &B00110001                          'Outputs RC2, RC1 u. X0 aktivieren, wie 1.
 PORTC = &B00100001                          'X2=Hi . RC2, X1=Lo . RC1, X0=Hi
 Gosub SetPNPIB0                             'Basisstrom abschalten
 Gosub Warte                                 'T4.1
 IF PinC.1 = 0 Then                          'Collektor Lo?
   PORTC = &B00000001                        'X2=Lo . RC2, X1=Lo . RC1, X0=Hi, wie 3.
   Gosub Warte                               'T4.2
   IF PinC.1 = 1 Then                        'Collektor Hi?
     Gosub MesseUX2                          'Basisspannung an X2 messen
     GoSub SetRBtoX2                         'Basiswiderstand an X2
     Gosub TestPNP                           'Test auf Darlington o. FET und RB=100K
     IF FET = 0 Then                         'Messe Beta
        DDRC = &B00010001                    'Output RC2 deaktivieren
       Gosub Warte                           'T4.3
       IF Dar = 1 Then GoTo Darl4            'Wenn Darlington, Collektor gefunden
       IF PinC.1 = 1 Then                    'Wenn X1 noch Hi, Collektor gefunden
       Darl4:
         GoSub SetIB0                        'Starte mit kleinstem Basisstrom
         Do
           Gosub IncrIB                      'Basisspannung erhhen
           Gosub SetPNPIB                    'und Ports setzen
           Gosub Warte                       'T4.4...
           Gosub MesseUX1                    'Collektorspannung an X2 messen
         Loop Until UX > 410                 'bis Collektorspannung > 2V
         URC = UX                            'Bei PNP: URC = UX
         Gosub MesseUX2                      'Basisspannung an X2 messen
         URB = UX                            'Bei PNP: Keine Schwellenspannung abziehen
         GoTo CalcBeta                       'Gehe zur Beta-Berechnung
       End If
     Else                                    'Messe UTH
        DDRC = &B00101010                    'Outputs RC2, X1 u. RC0 aktivieren
       PORTC = &B00001000                    'X2=Lo . RC2, X1=Lo, X0=Hi . RC0
       Gosub Warte                           'T4.3b
       Gosub MesseUX0                        'Sourcespannung an X0 messen
       'GoSub ComplUTH                        'Schwellenspannung UTH=5V-UX
       UTH = UX                              'Schwellenspannung
       GoTo DisplFET                         'Gehe zur FET-Anzeige
     End If
   End If
 End If

'X1 ist Common (Emitter, Source)

'5. CEB NPN  C-B-E-                           X1=Emitter/Source, X0=Basis/Gate, X2=Kollektor/Drain

 GoSub NextTPC                               'Increment X, T=0
  DDRC = &B00101010                          'Outputs RC2, RC0 u. X1 aktivieren, Rest hochohmig
 PORTC = &B00100000                          'X2=Hi . RC2, X0=Lo . RC0, X1=Lo
 Gosub SetNPNIB0                             'Basisstrom abschalten
 Gosub Warte                                 'T5.1
 IF PinC.2 = 1 Then                          'Collektor Hi?
   PORTC = &B00101000                        'X2=Hi . RC2, X0=Hi . RC0, X1=Lo
   Gosub Warte                               'T5.1
   IF PinC.2 = 0 Then                        'Collektor Lo?
     Gosub MesseUX0                          'Basisspannung an X0 messen
     GoSub SetRBtoX0                         'Basiswiderstand an X0
     Gosub TestNPN                           'Test auf Darlington o. FET und RB=100K
     IF FET = 0 Then                         'Messe Beta
        DDRC = &B00100010                    'Output RC0 deaktivieren
       PORTC = &B00100000                    'bei NPN Pullup an RC0 abschalten
       Gosub Warte                           'T5.3
       IF Dar = 1 Then GoTo Darl5            'Wenn Darlington, Collektor gefunden
       IF PinC.2 = 0 Then                    'Wenn X2 noch Lo, Collektor gefunden
       Darl5:
         GoSub SetIB0                        'Starte mit kleinstem Basisstrom
         Do
           Gosub IncrIB                      'Basisspannung erhhen
           Gosub SetNPNIB                    'und Ports setzen
           Gosub Warte                       'T5.4...
           Gosub MesseUX2                    'Collektorspannung an X2 messen
         Loop Until UX < 613                 'bis Collektorspannung < 3V
         GoSub ComplURC                      'URC = 5V - UX
         Gosub MesseUX0                      'Basisspannung an X0 messen
         GoSub ComplURB                      'URB = 5V - UX
         GoTo CalcBeta                       'Gehe zur Beta-Berechnung
       End If
     Else                                    'Messe UTH
        DDRC = &B00011100                    'OutputsX2, RC1 u. RC0 aktivieren
       PORTC = &B00001100                    'X2=Hi, X1=Lo . RC1, X0=Hi . RC0
       Gosub Warte                           'T5.3b
       Gosub MesseUX1                        'Sourcespannung an X1 messen
       GoSub ComplUTH                        'Schwellenspannung UTH=5V-UX
       'UTH = UX                               'Schwellenspannung
       GoTo DisplFET                         'Gehe zur FET-Anzeige
     End If
   End If
 End If

'6. BEC NPN  B-C-E-                           X1=Emitter/Source, X0=Kollektor/Drain, X2=Basis/Gate

 GoSub NextTPC                               'Increment X, T=0
  DDRC = &B00101010                          'Outputs RC2, RC0 u. X1 aktivieren, wie 5.
 PORTC = &B00001000                          'X2=Lo . RC2, X0=Hi . RC0, X1=Lo
 Gosub SetNPNIB0                             'Basisstrom abschalten
 Gosub Warte                                 'T6.1
 IF PinC.0 = 1 Then                          'Collektor Hi?
   PORTC = &B00101000                        'X2=Hi . RC2, X0=Hi . RC0, X1=Lo, wie 5.
   Gosub Warte                               'T6.2
   IF PinC.0 = 0 Then                        'Collektor Lo?
     Gosub MesseUX2                          'Basisspannung an X2 messen
     GoSub SetRBtoX2                         'Basiswiderstand an X2
     Gosub TestNPN                           'Test auf Darlington o. FET und RB=100K
     IF FET = 0 Then                         'Messe Beta
        DDRC = &B00001010                    'Output RC2 deaktivieren
       PORTC = &B00001000                    'bei NPN Pullup an RC2 abschalten
       Gosub Warte                           'T6.3
       IF Dar = 1 Then GoTo Darl6            'Wenn Darlington, Collektor gefunden
       IF PinC.0 = 0 Then                    'Wenn X0 noch Lo, Collektor gefunden
       Darl6:
         GoSub SetIB0                        'Starte mit kleinstem Basisstrom
         Do
           Gosub IncrIB                      'Basisspannung erhhen
           Gosub SetNPNIB                    'und Ports setzen
           Gosub Warte                       'T6.4...
           Gosub MesseUX0                    'Collektorspannung an X0 messen
         Loop Until UX < 613                 'bis Collektorspannung < 3V
         GoSub ComplURC                      'URC = 5V - UX
         Gosub MesseUX2                      'Basisspannung an X1 messen
         GoSub ComplURB                      'URB = 5V - UX
         GoTo CalcBeta                       'Gehe zur Beta-Berechnung
       End If
     Else                                    'Messe UTH
        DDRC = &B00110001                    'Outputs RC2 u. RC1, X0 aktivieren
       PORTC = &B00100001                    'X2=Hi . RC2, X1=Lo . RC1, X0=Hi
       Gosub Warte                           'T6.3b
       Gosub MesseUX1                        'Sourcespannung an X1 messen
       GoSub ComplUTH                        'Schwellenspannung UTH=5V-UX
       'UTH = UX                              'Schwellenspannung
       GoTo DisplFET                         'Gehe zur FET-Anzeige
     End If
   End If
 End If

'7. CEB PNP  C-B-E-                           X1=Emitter/Source, X0=Basis/Gate, X2=Kollektor/Drain

 GoSub NextTPC                               'Increment X, T=0
  DDRC = &B00101010                          'Outputs RC2, RC0 u. X1 aktivieren, wie 5.
 PORTC = &B00001010                          'X2=Lo . RC2, X0=Hi . RC0, X1=Hi
 Gosub SetPNPIB0                             'Basisstrom abschalten
 Gosub Warte                                 'T7.1
 IF PinC.2 = 0 Then                          'Collektor Lo?
   PORTC = &B00000010                        'X2=Lo . RC2, X0=Lo . RC0, X1=Hi
   Gosub Warte                               'T7.2
   IF PinC.2 = 1 Then                        'Collektor Hi?
     Gosub MesseUX0                          'Basisspannung an X0 messen
     GoSub SetRBtoX0                         'Basiswiderstand an X0
     Gosub TestPNP                           'Test auf Darlington o. FET und RB=100K
     IF FET = 0 Then                         'Messe Beta
        DDRC = &B00100010                    'Output RC0 deaktivieren
       Gosub Warte                           'T7.3
       IF Dar = 1 Then GoTo Darl7            'Wenn Darlington, Collektor gefunden
       IF PinC.2 = 1 Then                    'Wenn X2 noch Hi, Collektor gefunden
       Darl7:
         GoSub SetIB0                        'Starte mit kleinstem Basisstrom
         Do
           Gosub IncrIB                      'Basisspannung erhhen
           Gosub SetPNPIB                    'und Ports setzen
           Gosub Warte                       'T7.4...
           Gosub MesseUX2                    'Collektorspannung an X2 messen
         Loop Until UX > 410                 'bis Collektorspannung > 2V
         URC = UX                            'Bei PNP: URC = UX
         Gosub MesseUX0                      'Basisspannung an X0 messen
         URB = UX                            'Bei PNP: Keine Schwellenspannung abziehen
         GoTo CalcBeta                       'Gehe zur Beta-Berechnung
       End If
     Else                                    'Messe UTH
        DDRC = &B00011100                    'Outputs X2, RC1 u. RC0 aktivieren
       PORTC = &B00010000                    'X2=Lo, X1=Hi . RC1, X0=Lo . RC0
       Gosub Warte                           'T7.3b
       Gosub MesseUX1                        'Sourcespannung an X1 messen
       'GoSub ComplUTH                        'Schwellenspannung UTH=5V-UX
       UTH = UX                              'Schwellenspannung
       GoTo DisplFET                         'Gehe zur FET-Anzeige
     End If
   End If
 End If

'8. BEC PNP  B-C-E-                           X1=Emitter/Source, X0=Kollektor/Drain, X2=Basis/Gate

 GoSub NextTPC                               'Increment X, T=0
  DDRC = &B00101010                          'Outputs RC2, RC0 u. X1 aktivieren, wie 5.
 PORTC = &B00100010                          'X2=Hi . RC2, X1=Hi, X0=Lo . RC0
 Gosub SetPNPIB0                             'Basisstrom abschalten
 Gosub Warte                                 'T8.1
 IF PinC.0 = 0 Then                          'Collektor Lo?
   PORTC = &B00000010                        'X2=Lo . RC2, X1=Hi, X0=Lo . RC0, wie 7.
   Gosub Warte                               'T8.2
   IF PinC.0 = 1 Then                        'Collektor Hi?
     Gosub MesseUX2                          'Basisspannung an X2 messen
     GoSub SetRBtoX2                         'Basiswiderstand an X2
     Gosub TestPNP                           'Test auf Darlington o. FET und RB=100K
     IF FET = 0 Then                         'Messe Beta
        DDRC = &B00001010                    'Output RC2 deaktivieren, wie 6.
       Gosub Warte                           'T8.3
       IF Dar = 1 Then GoTo Darl8            'Wenn Darlington, Collektor gefunden
       IF PinC.0 = 1 Then                    'Wenn X0 noch Hi, Collektor gefunden
       Darl8:
         GoSub SetIB0                        'Starte mit kleinstem Basisstrom
         Do
           Gosub IncrIB                      'Basisspannung erhhen
           Gosub SetPNPIB                    'und Ports setzen
           Gosub Warte                       'T8.4...
           Gosub MesseUX0                    'Collektorspannung an X0 messen
         Loop Until UX > 410                 'bis Collektorspannung > 2V
         URC = UX                            'Bei PNP: URC = UX
         Gosub MesseUX2                      'Basisspannung an X2 messen
         URB = UX                            'Bei PNP: Keine Schwellenspannung abziehen
         GoTo CalcBeta                       'Gehe zur Beta-Berechnung
       End If
     Else                                    'Messe UTH
        DDRC = &B00110001                    'Outputs RC2 u. RC1, X0 aktivieren
       PORTC = &B00010000                    'X2=Lo . RC2, X1=Hi . RC1, X0=Lo
       Gosub Warte                           'T8.3b
       Gosub MesseUX1                        'Sourcespannung an X1 messen
       'GoSub ComplUTH                        'Schwellenspannung UTH=5V-UX
       UTH = UX                              'Schwellenspannung
       GoTo DisplFET                         'Gehe zur FET-Anzeige
     End If
   End If
 End If

'X2 ist Common (Emitter, Source)

'9. ECB NPN  -CBE--                           X2=Emitter/Source, X0=Basis/Gate, X1=Kollektor/Drain

 GoSub NextTPC                               'Increment X, T=0
  DDRC = &B00011100                          'Outputs RC1, RC0 u. X2 aktivieren, Rest hochohmig
 PORTC = &B00010000                          'X1=Hi . RC1, X0=Lo . RC0, X2=Lo
 Gosub SetNPNIB0                             'Basisstrom abschalten
 Gosub Warte                                 'T9.1
 IF PinC.1 = 1 Then                          'Collektor Hi?
   PORTC = &B00011000                        'X1=Hi . RC1, X0=Hi . RC0, X2=Lo
   Gosub Warte                               'T9.2
   IF PinC.1 = 0 Then                        'Collektor Lo?
     Gosub MesseUX0                          'Basisspannung an X0 messen
     GoSub SetRBtoX0                         'Basiswiderstand an X0
     Gosub TestNPN                           'Test auf Darlington o. FET und RB=100K
     IF FET = 0 Then                         'Messe Beta
        DDRC = &B00010100                    'Output RC0 deaktivieren
       PORTC = &B00010000                    'bei NPN Pullup an RC0 abschalten
       Gosub Warte                           'T9.3
       IF Dar = 1 Then GoTo Darl9            'Wenn Darlington, Collektor gefunden
       IF PinC.1 = 0 Then                    'Wenn X1 noch Lo, Collektor gefunden
       Darl9:
         GoSub SetIB0                        'Starte mit kleinstem Basisstrom
         Do
           Gosub IncrIB                      'Basisspannung erhhen
           Gosub SetNPNIB                    'und Ports setzen
           Gosub Warte                       'T9.4...
           Gosub MesseUX1                    'Collektorspannung an X1 messen
         Loop Until UX < 613                 'bis Collektorspannung < 3V
         GoSub ComplURC                      'URC = 5V - UX
         Gosub MesseUX0                      'Basisspannung an X0 messen
         GoSub ComplURB                      'URB = 5V - UX
         GoTo CalcBeta                       'Gehe zur Beta-Berechnung
       End If
     Else                                    'Messe UTH
        DDRC = &B00101010                    'Outputs RC2, X1 u. RC0 aktivieren
       PORTC = &B00001010                    'X2=Lo . RC2, X1=Hi, X0=Hi . RC0
       Gosub Warte                           'T9.3b
       Gosub MesseUX2                        'Sourcespannung an X2 messen
       GoSub ComplUTH                        'Schwellenspannung UTH=5V-UX
       'UTH = UX                              'Schwellenspannung
       GoTo DisplFET                         'Gehe zur FET-Anzeige
     End If
   End If
 End If

'10. EBC NPN -BCE--                           X2=Emitter/Source, X1=Basis/Gate, X0=Kollektor/Drain

 GoSub NextTPC                               'Increment X, T=0
  DDRC = &B00011100                          'Outputs RC1, RC0 u. X2 aktivieren, wie 9.
 PORTC = &B00001000                          'X1=Lo . RC1, X0=Hi  RC0, X2=Lo
 Gosub SetNPNIB0                             'Basisstrom abschalten
 Gosub Warte                                 'T10.1
 IF PinC.0 = 1 Then                          'Collektor Hi?
   PORTC = &B00011000                        'X1=Hi . RC1, X0=Hi  RC0, X2=Lo, wie 9.
   Gosub Warte                               'T10.2
   IF PinC.0 = 0 Then                        'Collektor Lo?
     Gosub MesseUX1                          'Basisspannung an X1 messen
     GoSub SetRBtoX1                         'Basiswiderstand an X1
     Gosub TestNPN                           'Test auf Darlington o. FET und RB=100K
     IF FET = 0 Then                         'Messe Beta
        DDRC = &B00001100                    'Output RC1 deaktivieren
       PORTC = &B00001000                    'bei NPN Pullup an RC1 abschalten
       Gosub Warte                           'T10.3
       IF Dar = 1 Then GoTo Darl10           'Wenn Darlington, Collektor gefunden
       IF PinC.0 = 0 Then                    'Wenn X0 noch Lo, Collektor gefunden
       Darl10:
         GoSub SetIB0                        'Starte mit kleinstem Basisstrom
         Do
           Gosub IncrIB                      'Basisspannung erhhen
           Gosub SetNPNIB                    'und Ports setzen
           Gosub Warte                       'T10.4...
           Gosub MesseUX0                    'Collektorspannung an X0 messen
         Loop Until UX < 613                 'bis Collektorspannung < 3V
         GoSub ComplURC                      'URC = 5V - UX
         Gosub MesseUX1                      'Basisspannung an X1 messen
         GoSub ComplURB                      'URB = 5V - UX
         GoTo CalcBeta                       'Gehe zur Beta-Berechnung
       End If
     Else                                    'Messe UTH
        DDRC = &B00110001                    'Outputs RC2 u. RC1, X0 aktivieren
       PORTC = &B00010001                    'X2=Lo . RC2, X1=Hi . RC1, X0=Hi
       Gosub Warte                           'T10.3b
       Gosub MesseUX2                        'Sourcespannung an X2 messen
       GoSub ComplUTH                        'Schwellenspannung UTH=5V-UX
       'UTH = UX                              'Schwellenspannung
       GoTo DisplFET                         'Gehe zur FET-Anzeige
     End If
   End If
 End If

'11. ECB PNP -CBE--                           X2=Emitter/Source, X0=Basis/Gate, X1=Kollektor/Drain

 GoSub NextTPC                               'Increment X, T=0
  DDRC = &B00011100                          'Outputs RC1 u. RC0, X2 aktivieren, wie 9.
 PORTC = &B00001100                          'X1=Lo . RC1, X0=Hi . RC0, Hi an X2
 Gosub SetPNPIB0                             'Basisstrom abschalten
 Gosub Warte                                 'T11.1
 IF PinC.1 = 0 Then                          'Collektor Lo?
   PORTC = &B00000100                        'X1=Lo . RC1, X0=Lo . RC0, Hi an X2
   Gosub Warte                               'T11.2
   IF PinC.1 = 1 Then                        'Collektor Hi?
     Gosub MesseUX0                          'Basisspannung an X0 messen
     GoSub SetRBtoX0                         'Basiswiderstand an X0
     Gosub TestPNP                           'Test auf Darlington o. FET und RB=100K
     IF FET = 0 Then                         'Messe Beta
       PORTB = &B00000000                    'PWM an X0, wie 9.
        DDRC = &B00010100                    'Output RC0 deaktivieren, wie 9.
       Gosub Warte                           'T11.3
       IF Dar = 1 Then GoTo Darl11           'Wenn Darlington, Collektor gefunden
       IF PinC.1 = 1 Then                    'Wenn X1 noch Hi, Collektor gefunden
       Darl11:
         GoSub SetIB0                        'Starte mit kleinstem Basisstrom
         Do
           Gosub IncrIB                      'Basisspannung erhhen
           Gosub SetPNPIB                    'und Ports setzen
           Gosub Warte                       'T11.4...
           Gosub MesseUX1                    'Collektorspannung an X1 messen
         Loop Until UX > 410                 'bis Collektorspannung > 2V
         URC = UX                            'Bei PNP: URC = UX
         Gosub MesseUX0                      'Basisspannung an X0 messen
         URB = UX                            'Bei PNP: Keine Schwellenspannung abziehen
         GoTo CalcBeta                       'Gehe zur Beta-Berechnung
       End If
     Else                                    'Messe UTH
        DDRC = &B00101010                    'Outputs RC2, X1 u. RC0 aktivieren
       PORTC = &B00100000                    'X2=Hi . RC2, X1=Lo, X0=Lo . RC0
       Gosub Warte                           'T11.3b
       Gosub MesseUX2                        'Sourcespannung an X2 messen
       'GoSub ComplUTH                        'Schwellenspannung UTH=5V-UX
       UTH = UX                              'Schwellenspannung
       GoTo DisplFET                         'Gehe zur FET-Anzeige
     End If
   End If
 End If

'12. EBC PNP -BCE--                           X2=Emitter/Source, X1=Basis/Gate, X0=Kollektor/Drain

 GoSub NextTPC                               'Increment X, T=0
  DDRC = &B00011100                          'Outputs RC1 u. RC0, X2 aktivieren
 PORTC = &B00010100                          'X1=Hi . RC1, X0=Lo . RC0, X2=Hi
 Gosub SetPNPIB0                             'Basisstrom abschalten
 Gosub Warte                                 'T12.1
 IF PinC.0 = 0 Then                          'Collektor Lo?
   PORTC = &B00000100                        'X1=Lo . RC1, X0=Lo . RC0, X2=Hi, wie 11.
   Gosub Warte                               'T12.2
   IF PinC.0 = 1 Then                        'Collektor Hi?
     Gosub MesseUX1                          'Basisspannung an X1 messen
     GoSub SetRBtoX1                         'Basiswiderstand an X1
     Gosub TestPNP                           'Test auf Darlington o. FET und RB=100K
     IF FET = 0 Then                         'Messe Beta
       PORTB = &B00000001                    'PWM an X1, wie 10
        DDRC = &B00001100                    'Output RC1 deaktivieren, wie 10
       Gosub Warte                           'T12.3
       IF Dar = 1 Then GoTo Darl12           'Wenn Darlington, Collektor gefunden
       IF PinC.0 = 1 Then                    'Wenn X0 noch Hi, Collektor gefunden
       Darl12:
         GoSub SetIB0                        'Starte mit kleinstem Basisstrom
         Do
           Gosub IncrIB                      'Basisspannung erhhen
           Gosub SetPNPIB                    'und Ports setzen
           Gosub Warte                       'T12.4...
           Gosub MesseUX0                    'Collektorspannung an X0 messen
         Loop Until UX > 410                 'bis Collektorspannung > 2V
         URC = UX                            'Bei PNP: URC = UX
         Gosub MesseUX1                      'Basisspannung an X1 messen
         URB = UX                            'Bei PNP: Keine Schwellenspannung abziehen
         GoTo CalcBeta                       'Gehe zur Beta-Berechnung
       End If
     Else                                    'Messe UTH
        DDRC = &B00110001                    'Outputs RC2 u. RC1, X0 aktivieren
       PORTC = &B00100000                    'X2=Hi . RC2, X1=Lo . RC1, X0=Lo
       Gosub Warte                           'T12.3b
       Gosub MesseUX2                        'Sourcespannung an X2 messen
       'GoSub ComplUTH                        'Schwellenspannung UTH=5V-UX
       UTH = UX                              'Schwellenspannung
       GoTo DisplFET                         'Gehe zur FET-Anzeige
     End If
   End If
 End If

 IF BetaRange < 5 Then
   Incr BetaRange
   Goto NxtBetaTest
 End If

'JFET Test, suche nach sperrendem Gate

 JFET = 0                                    'Initialisierung der JFET Variablen
 IB = 64                                     'Sourcewiderstand = 10K

'13.            GXX                           X2=Gate

 GoSub NextTPC                               'Increment X, T=0
  DDRC = &B00000011                          'Outputs X0 u, X1 aktivieren, Rest hochohmig
 PORTC = &B00000000                          'X0=Lo, X1=Lo, Drain u. Source Lo
 GoSub SetRBtoX2                             'Gatewiderstand an X2
 GoSub SetNPNIB                              'Gate=Hi, X2 b. 100K an VDD
 Gosub Warte                                 'T13.1
 IF PinC.2 = 1 Then                          'Gate Hi = hochohmig, PCH JFET
   PORTC = &B00000011                        'X1=Hi, X0=Hi, Drain u. Source Hi
   GoSub SetPNPIB                            'Gate=Lo, X2 b. 100K an GND
   Gosub Warte                               'T14.2x
   IF PinC.2 = 1 Then                        'Negativ-Test NCH-FET, Gate niederohmig
     GoSub SetRBtoX0                         'RB als Sourcewiderstand an X0
     GoSub SetNPNIB                          'R-Source an VDD
      DDRC = &B00100010                      'Outputs X1, Drain u. RG2, Gate akt.
     PORTC = &B00100000                      'X1=Lo:Drain, RG2=Hi:Gate, GDS
     Gosub Warte                             'T13.2a
     GoSub MesseUX0                          'Messe Sourcespannung an X0
     GoSub ComplUCO1                         'entspricht GateCutOff Spannung

     GoSub SetRBtoX1                         'RB als Sourcewiderstand an X1
      DDRC = &B00100001                      'Outputs X0, Drain u. RG2, Gate akt.
     PORTC = &B00100000                      'X0=Lo:Drain, RG2=Hi:Gate, GSD
     Gosub Warte                             'T13.3a
     GoSub MesseUX1                          'Messe Sourcespannung an X1
     GoSub ComplUCO2                         'entspricht GateCutOff Spannung
     JFET.5 = 1
     GoTo JFETdspl                           'JFET Datenausgabe
   End If
 Else                                        'Gate Lo, Test auf NCH JFET
   PORTC = &B00000011                        'X0=Hi, X1=HI, Drain u. Source Hi
   GoSub SetPNPIB                            'R-Source an GND
   Gosub Warte                               'T13.2b
   IF PinC.2 = 0 Then                        'Gate Lo?, NCH JFET
     GoSub SetRBtoX0                         'RB als Sourcewiderstand an  X0
      DDRC = &B00100010                      'Outputs X1, Drain u. RG2, Gate akt.
     PORTC = &B00000010                      'X1=HI:Drain, RG2=Lo:Gate, GDS
     Gosub Warte                             'T13.3b
     GoSub MesseUX0                          'Messe Sourcespannung an X0
     UCO1 = UX                               'GateCutoff Spannung, X0=Source

     GoSub SetRBtoX1                         'RB als Sourcewiderstand an  X2
      DDRC = &B00100001                      'Outputs X0, Drain u. RG0, Gate akt.
     PORTC = &B00000001                      'X1=HI:Drain, RG2=Lo:Gate, GSD
     Gosub Warte                             'T13.4
     GoSub MesseUX1                          'Messe Sourcespannung an X1
     UCO2 = UX                               'GateCutoff Spannung, X1=Source
     JFET.2 = 1
     GoTo JFETdspl                           'JFET Datenausgabe
   End If
 End If


'14.            XXG                           X0=Gate

 GoSub NextTPC                               'Increment X, T=0
  DDRC = &B00000110                          'Outputs X1 u, X2 aktivieren, Rest hochohmig
 PORTC = &B00000000                          'X1=Lo, X2=Lo, Drain u. Source Lo
 GoSub SetRBtoX0                             'Gatewiderstand an X0
 GoSub SetNPNIB                              'Gate=Hi, X0 b. 100K an VDD
 Gosub Warte                                 'T14.1
 IF PinC.0 = 1 Then                          'Gate Hi?: Test auf PCH JFET
   PORTC = &B00000110                        'X1=Hi, X2=Hi, Drain u. Source Hi
   GoSub SetPNPIB                            'Gate=Lo, X0 b. 100K an GND
   Gosub Warte                               'T14.2x
   IF PinC.0 = 1 Then                        'Negativ-Test NCH-FET, Gate niederohmig
     GoSub SetRBtoX1                         'RB als Sourcewiderstand an X1
     GoSub SetNPNIB                          'R-Source an VDD
      DDRC = &B00001100                      'Outputs X2, Drain u. RG0, Gate akt.
     PORTC = &B00001000                      'X2=Lo:Drain, RG0=Hi:Gate
     Gosub Warte                             'T14.2a
     GoSub MesseUX1                          'Messe Sourcespannung an X1
     GoSub ComplUCO1                         'GateCutOff Spannung, X1=Source

     GoSub SetRBtoX2                         'RB als Sourcewiderstand an X2
      DDRC = &B00001010                      'Outputs X1, Drain u. RG0, Gate akt.
     PORTC = &B00001000                      'X1=Lo:Drain, RG0=Hi:Gate
     Gosub Warte                             'T14.3a
     GoSub MesseUX2                          'Messe Sourcespannung an X2
     GoSub ComplUCO2                         'GateCutOff Spannung, X2=Source
     JFET.3 = 1
    GoTo JFETdspl                            'JFET Datenausgabe
   End If
 Else
   PORTC = &B00000110                        'X1=Hi, X2=HI, Drain u. Source Hi
   GoSub SetPNPIB                            'R-Source an GND
   Gosub Warte                               'T14.2b
   IF PinC.0 = 0 Then                        'Gate Hochohmig, NCH JFET
     GoSub SetRBtoX1                         'RB als Sourcewiderstand an X1
      DDRC = &B00001100                      'Outputs X2, Drain u. RG0, Gate akt.
     PORTC = &B00000100                      'X2=HI:Drain, RG0=Lo:Gate
     Gosub Warte                             'T14.3b
     GoSub MesseUX1                          'Messe Sourcespannung an X1
     UCO1 = UX                               'GateCutoff Spannung, X1=Source

     GoSub SetRBtoX2                         'RB als Sourcewiderstand an X2
      DDRC = &B00001010                      'Outputs X1, Drain u. RG0, Gate akt.
     PORTC = &B00000010                      'X1=HI:Drain, RG0=Lo:Gate
     Gosub Warte                             'T14.4
     GoSub MesseUX2                          'Messe Sourcespannung an X2
     UCO2 = UX                               'GateCutoff Spannung, X2=Source
     JFET.0 = 1
     GoTo JFETdspl                           'JFET Datenausgabe
   End If
 End If

'15.            XGX                           X1=Gate

 GoSub NextTPC                               'Increment X, T=0
  DDRC = &B00000101                          'Outputs X0 u, X2 aktivieren, Rest hochohmig
 PORTC = &B00000000                          'X0=Lo, X2=Lo, Drain u. Source Lo
 GoSub SetRBtoX1                             'Gatewiderstand an X1
 GoSub SetNPNIB                              'Gate=Hi, X1 b. 100K an VDD
 Gosub Warte                                 'T15.1
 IF PinC.1 = 1 Then                          'Gate Hi?: Test auf PCH JFET
   PORTC = &B00000101                        'X0=Hi, X2=Hi, Drain u. Source Hi
   GoSub SetPNPIB                            'Gate=Lo, X1 b. 100K an GND
   Gosub Warte                               'T15.2x
   IF PinC.1 = 1 Then                        'Negativ-Test NCH-FET, Gate niederohmig
     GoSub SetRBtoX0                         'RB als Sourcewiderstand an X0
     GoSub SetNPNIB                          'R-Source an VDD
      DDRC = &B00010100                      'Outputs X2, Drain u. RG1, Gate akt.
     PORTC = &B00010000                      'X2=Lo:Drain, RG1=Hi:Gate
     Gosub Warte                             'T15.2a
     GoSub MesseUX0                          'Messe Sourcespannung an X0
     GoSub ComplUCO1                         'GateCutOff Spannung, X0=Source

     GoSub SetRBtoX2                         'RB als Sourcewiderstand an X2
      DDRC = &B00010001                      'Outputs X0, Drain u. RG1, Gate akt.
     PORTC = &B00010000                      'X0=Lo:Drain, RG1=Hi:Gate
     Gosub Warte                             'T15.3a
     GoSub MesseUX2                          'Messe Sourcespannung an X2
     GoSub ComplUCO2                         'GateCutOff Spannung, X2=Source
     JFET.4 = 1
     GoTo JFETdspl                           'JFET Datenausgabe
   End If
 Else                                        'Gate niederohmig: NCH JFET
   PORTC = &B00000101                        'X0=Hi, X2=HI, Drain u. Source Hi
   GoSub SetPNPIB                            'R-Source an GND
   Gosub Warte                               'T15.2b
   IF PinC.1 = 0 Then                        'Gate Hochohmig, NCH JFET
     GoSub SetRBtoX0                         'RB als Sourcewiderstand an X0
      DDRC = &B00010100                      'Outputs X2, Drain u. RG1, Gate akt.
     PORTC = &B00000100                      'X2=HI:Drain, RG1=Lo:Gate
     Gosub Warte                             'T15.3b
     GoSub MesseUX0                          'Messe Sourcespannung an X0
     UCO1 = UX                               'GateCutoff Spannung, X0=Source

     GoSub SetRBtoX2                         'RB als Sourcewiderstand an X2
      DDRC = &B00010001                      'Outputs X0, Drain u. RG1, Gate akt.
     PORTC = &B00000001                      'X0=HI:Drain, RG1=Lo:Gate
     Gosub Warte                             'T15.4
     GoSub MesseUX2                          'Messe Sourcespannung an X2
     UCO2 = UX                               'GateCutoff Spannung, X2=Source
     JFET.1 = 1
     GoTo JFETdspl                           'JFET Datenausgabe
   End If
 End If

 JFETdspl:

 IF UCO1 < 1010 Then                         'JFET GateCutoff Spannung < 5V
   IF UCO1 > 14 Then                         'JFET GateCutoff Spannung > 0V

     IF JFET > 0 AND JFET < 33 Then

       Home

       IF JFET > 4 Then                      'P-kanal JFET
         LCD "P"
       Else                                  'N-Kanal JFET
         LCD "N"
       End If
       LCD "CH-JFET         "

       Select Case JFET                      'Anzeige Pinbelegung

         Case 1 : LCD "XXG"
         Case 8 : LCD "XXG"
         Case 2 : LCD "XGX"
         Case 16 : LCD "XGX"
         Case 4 : LCD "GXX"
         Case 32 : LCD "GXX"

       End Select

       Home Lower

       LCD "UCutOff="                        'Anzeige CutOff-Spannung 1 und 2
       UXL = UCO1
       GoSub LCDUXL
       LCD "        "
       'UXL = UCO2
       'GoSub LCDUXL

       GoTo Main                             'zur Hauptschleife

     End If
   End If
 End If

'PullUp-Test fr alle anderen Flle, Dioden oder defekte Halbleiter

 GoSub SetIB0                                'Basiswiderstand abschalten

'Low an X0, Hi b. 1K an X1

GoSub NextTPC                                'Increment X, T=0

 DDRC = &B00010001                           'PC0=O, PC1=I, PC2=I, PC3=I, PC4=O, PC5=I
PORTC = &B00010000                           'PC0=0, PC1=H, PC2=H, PC3=H, PC4=1, PC5=H

Gosub Warte

IF PinC.1 = 0 Then                           'wenn X1=Lo
  Gosub MesseUX1                             'messe Durchlassspannung
End If

SPUp.0 = PinC.1                              'Speichere Zustand in SPUp.0

'Low an X0, Hi b. 1K an X2

GoSub NextTPC                                'Increment X, T=0

 DDRC = &B00100001                           'PC0=O, PC1=I, PC2=I, PC3=I, PC4=I, PC5=O
PORTC = &B00100000                           'PC0=0, PC1=H, PC2=H, PC3=H, PC4=H, PC5=1

Gosub Warte

IF PinC.2 = 0 Then                           'wenn X2=Lo
  Gosub MesseUX2                             'messe Durchlassspannung
End If

SPUp.1 = PinC.2                              'Speichere Zustand in SPUp.1

'Low an X1, Hi b. 1K an X0

GoSub NextTPC                                'Increment X, T=0

 DDRC = &B00001010                           'PC0=I, PC1=O, PC2=I, PC3=O, PC4=I, PC5=I
PORTC = &B00001000                           'PC0=H, PC1=0, PC2=H, PC3=1, PC4=H, PC5=H

Gosub Warte

IF PinC.0 = 0 Then                           'wenn X0=Lo
  Gosub MesseUX0                             'messe Durchlassspannung
End If

SPUp.2 = PinC.0                              'Speichere Zustand in SPUp.2

'Low an X1, Hi b. 1K an X2

GoSub NextTPC                                'Increment X, T=0

 DDRC = &B00100010                           'PC0=I, PC1=O, PC2=I, PC3=I, PC4=I, PC5=O
PORTC = &B00100000                           'PC0=H, PC1=0, PC2=H, PC3=H, PC4=H, PC5=1

Gosub Warte

IF PinC.2 = 0 Then                           'wenn X2=Lo
  Gosub MesseUX2                             'messe Durchlassspannung
End If

SPUp.3 = PinC.2                              'Speichere Zustand in SPUp.3

'Low an X2, Hi b. 1K an X0

GoSub NextTPC                                'Increment X, T=0

 DDRC = &B00001100                           'PC0=I, PC1=I, PC2=O, PC3=O, PC4=I, PC5=I
PORTC = &B00001000                           'PC0=H, PC1=H, PC2=0, PC3=1, PC4=H, PC5=H

Gosub Warte

IF PinC.0 = 0 Then                           'wenn X0=Lo
  Gosub MesseUX0                             'messe Durchlassspannung
End If

SPUp.4 = PinC.0                              'Speichere Zustand in SPUp.4

'Low an X2, Hi b. 1K an X1

GoSub NextTPC                                'Increment X, T=0

 DDRC = &B00010100                           'PC0=I, PC1=I, PC2=O, PC3=I, PC4=O, PC5=I
PORTC = &B00010000                           'PC0=H, PC1=H, PC2=0, PC3=H, PC4=1, PC5=H

Gosub Warte

IF PinC.1 = 0 Then                           'wenn X1=Lo
  Gosub MesseUX1                             'messe Durchlassspannung
End If

SPUp.5 = PinC.1                              'Speichere Zustand in SPUp.5

  IF SPUp = 63 Then                          'SPUp > 63 -> alle Pins offen
    Home Upper
    LCD "Autom. Trans. Tester"
    Home Lower
    LCD "       Ready!       "               'Ready Anzeige
    AltDispl = 0
  Else

    Home                                     'in der erten Zeile

    Select Case SPUp                         'Flle kein Halbleiter

      Case 58 : GoTo KeinHL
      Case 45 : GoTo KeinHL
      Case 23 : GoTo KeinHL
      Case 0 : GoTo KeinHL

    End Select

    UXL = UD - 18                            'Korrektur wegen Spannungsabfall bei R=1K

    LCD "Diode UD="                          'Anzeige: Diode und
    GoSub LCDUXL                             'Durchlasspannung
    LCD "  "

    Home Lower                               'in der zweiten Zeile
    LCD "A=Anode, K=Kathode  "               'Anode, Kathode
    GoTo PinOut

  KeinHL:                                    'Anzeige "Kein Halbleiter"

    LCD "Kein Halbleiter! "
    Home Lower
    LCD "S=Short, O=Open     "

  PinOut:                                    'Anzeige Pinbelegung

    Locate 1 , 18                            'erste Zeile rechts
    Select Case SPUp

      Case 59 : LCD "OKA"
      Case 3 : LCD "KKA"
      Case 47 : LCD "KOA"
      Case 31 : LCD "KAO"
      Case 10 : LCD "KAA"
      Case 62 : LCD "OAK"
      Case 20 : LCD "AAK"
      Case 61 : LCD "AOK"
      Case 33 : LCD "AKA"
      Case 55 : LCD "AKO"
      Case 12 : LCD "KAK"
      Case 58 : LCD "OSS"
      Case 45 : LCD "SOS"
      Case 23 : LCD "SSO"
      Case 0 : LCD "SSS"
      Case Else LCD "???"

    End Select

  End If

  GoTo Main                                  'zurck zur Hauptschleife

'------------------------------------------------------------------------------
CalcBeta:

  'IC = URC/RC, RC = 1K
  'IB = URB/RB, RB = 1K*M, M=siehe unten
  'Beta = IC/IB = (URC/RC)*(RB/URB) = URC*1K*M/URB*1K
  'Beta = URC*M/URB

  Select Case IB
    Case 1 : M = 10000                       'RB=10M
    Case 2 : M = 4700                        'RB=4M7
    Case 4 : M = 1000                        'RB=1M0
    Case 8 : M = 330                         'RB=330K
    Case 16 : M = 100                        'RB=100K
    Case 32 : M = 33                         'RB=33K
    Case 64 : M = 10                         'RB=10K
    Case 128 : M = 3                         'RB=3K0
  End Select

  URCM = URC * M                             'berechne Beta
  Beta = URCM / URB

  UX = URB
  GoSub ComplURB                             'UBE=5V-URB
  UXL = URB

  Home Lower                                 '2. Zeile
  If AltDispl = 0 Then                       'bei normal Display
    LCD "Beta=" ; Beta                       'Anzeige von Beta in der 2. Zeile
    'LCD "BR=" ; BetaRange ; " Beta=" ; Beta  'Anzeige von Beta in der 2. Zeile
  Else                                       'bei alternativ Display
    LCD "UBE="                               'Anzeige der Basis-Emitter Spannung
    GoSub LCDUXL
    LCD "RB=" ; M ; "K    "                  'und des benutzten Basisvorwiderstandes
  End If
  LCD "              "                       'lscht Rest der Zeile

  GoTo DisplTr

  DisplFET:                                  'Anzeige bei FET

  Home Lower                                 '2. Zeile
  LCD "UThreshold="
  UXL = UTH                                  'Schwellenspannung
  GoSub LCDUXL
  LCD "    "                                 'lscht Rest der Zeile

  DisplTr:                                   'Anzeige bipolar Transistor

  Home                                       '1. Zeile
  P = X + FET                                'berechne Pin-Pointer
  IF FET = 0 Then
    IF URB > 100 Then                        'UBE > 0,5V
      LCD "Si "                              'Silizium Transistor
    Else                                     'sonst
      LCD "Ge "                              'Germanium Transistor
    End If
  End If
  LCD TypStr ; "          "                  'Anzeige Transistor-Typ
  Locate 1 , 18                              '1. Zeile rechts
  LCD PinStr(P)                              'Pin-Folge

 Goto Main                                   'zurck zur Hauptschleife

'------------------------------------------------------------------------------
MesseUX0:                                    'messe Spannung an Anschlu X0
 UX = GetADC(0)
Goto TestIB0
'------------------------------------------------------------------------------
MesseUX1:                                    'messe Spannung an Anschlu X1
 UX = GetADC(1)
Goto TestIB0
'------------------------------------------------------------------------------
MesseUX2:                                    'messe Spannung an Anschlu X2
 UX = GetADC(2)
TestIB0:
 IF UX > 40 Then UD = UX                     'Keine Anzeige von UD bei Kurzschlu
 IF IB = 96 Then UX = 512                    'berlauf von IncrIB, beende Loop
Return
'------------------------------------------------------------------------------
LCDUXL:                                      'Anzeige der Spannung UXL auf LCD
 UXL = UXL * 500                             '*500
 Shift UXL , Right , 10                      '/1024, 1024 -> 5V
 UXLStr = Str(UXL)                           'umwandeln in Text
 IF UXL => 100 Then                          'Spannung => 1V
   UXLLStr = Left(UXLStr , 1)                '1 Vorkommastelle
   UXLRStr = Right(UXLStr , 2)               '2 Nachkommastellen
 Else                                        'sonst
   UXLLStr = "0"                             'Vorkommastelle = 0
   UXLRStr = Right(UXLStr , 2)               '2 Nachkommastellen
 End If

 LCD UXLLStr ; "," ; UXLRStr ; "V "          'Ausgabe: Vorkomma,NachkommaV
Return
'------------------------------------------------------------------------------
TestNPN:
 IF UX > 512 Then                            'bei UX > 2,5V
   FET = 12                                  'Index fr PinStr auf FET
   TypStr = "NCH-FET "                       'Typ = NCH-FET
 Else                                        'bei UX <= 2,5V
   IF UX > 215 Then                          'wenn > 1,0V
     Dar = 1
     TypStr = "NPN-Darlingt. "               'Typ = NPN Darlington
   Else                                      'sonst
     TypStr = "NPN-Transist. "               'Typ = NPN Transistor
   End If
 End If

 IF BetaRange = 0 Then
   GoTo SetNPNIB8                            'Set RB=330K
 End If
 IF BetaRange = 1 Then
   GoTo SetNPNIB16                           'Set RB=100K
 End If
 IF BetaRange = 2 Then
   GoTo SetNPNIB32                           'Set RB=33K
 End If
 IF BetaRange = 3 Then
   GoTo SetNPNIB64                           'Set RB=10K
 End If
 IF BetaRange = 4 Then
   GoTo SetNPNIB128                          'Set RB=3,3K
 End If
'------------------------------------------------------------------------------
TestPNP:
 IF UX < 512 Then                            'bei UX < 2,5V
   FET = 12                                  'Index fr PinStr auf FET
   TypStr = "PCH-FET "                       'Typ = PCH-FET
 Else
   IF UX < 809 Then                          'wenn < 4V: PNP Darlington
     Dar = 1
     TypStr = "PNP-Darlingt. "               'Typ = PNP Darlington
   Else
     TypStr = "PNP-Transist. "               'Typ = PNP Transistor
   End If
 End If

 IF BetaRange = 0 Then
   GoTo SetPNPIB8                            'Set RB=330K
 End If
 IF BetaRange = 1 Then
   GoTo SetPNPIB16                           'Set RB=100K
 End If
 IF BetaRange = 2 Then
   GoTo SetPNPIB32                           'Set RB=33K
 End If
 IF BetaRange = 3 Then
   GoTo SetPNPIB64                           'Set RB=10K
 End If
 IF BetaRange = 4 Then
   GoTo SetPNPIB128                          'Set RB=3,3K
 End If
'------------------------------------------------------------------------------
SetRBtoX0:                                   'schalte Basiswiderstand an X0
 PortD.6 = 0
 PortD.7 = 0                                 'Mux-Adresse: 00
Return
'------------------------------------------------------------------------------
SetRBtoX1:                                   'schalte Basiswiderstand an X1
 PortD.6 = 1
 PortD.7 = 0
Return                                       'Mux-Adresse: 01
'------------------------------------------------------------------------------
SetRBtoX2:                                   'schalte Basiswiderstand an X2
 PortD.6 = 0
 PortD.7 = 1
Return                                       'Mux-Adresse: 10
'------------------------------------------------------------------------------
PwrDn:                                       'Power Down, Gert abschalten
 Display OFF                                 'Display aus
 'Stop
 'IB = 128                                    'Basiswiderstand 3K
 IB = 255                                    'Alle Basiswiderstnde aktivieren
 PortD.6 = 1
 PortD.7 = 1                                 'Mux-Adresse: 11
 GoSub SetPNPIB                              'Gate von Q2 b. alle Wid.an GND
 Stop                                        'Stop Prozessor
'------------------------------------------------------------------------------
SetNPNIB0:
 IB = 0                                      'Kein Basisstrom RB = unendlich
 GoTo SetNPNIB
SetNPNIB2:
 IB = 2                                      'RB=3M3
 GoTo SetNPNIB
SetNPNIB4:
 IB = 4                                      'RB=1M0
 GoTo SetNPNIB
SetNPNIB8:
 IB = 8                                      'RB=330K
 GoTo SetNPNIB
SetNPNIB16:
 IB = 16                                     'RB=100K
 GoTo SetNPNIB
SetNPNIB32:
 IB = 32                                     'RB=33K
 GoTo SetNPNIB
SetNPNIB64:
 IB = 64                                     'RB=10K
 GoTo SetNPNIB
SetNPNIB128:
 IB = 128                                    'RB=3K3
SetNPNIB:
  DDRB = IB                                  'IB Output aktivieren
 PORTB = IB                                  'IB Output auf 1
Return
'------------------------------------------------------------------------------
SetIB0:
SetPNPIB0:
 IB = 0                                      'Kein Basisstrom
 GoTo SetPNPIB
SetPNPIB2:
 IB = 2                                      'RB=3M3
 GoTo SetPNPIB
SetPNPIB4:
 IB = 4                                      'RB=1M0
 GoTo SetPNPIB
SetPNPIB8:
 IB = 8                                      'RB=330K
 GoTo SetPNPIB
SetPNPIB16:
 IB = 16                                     'RB=100K
 GoTo SetPNPIB
SetPNPIB32:
 IB = 32                                     'RB=33K
 GoTo SetPNPIB
SetPNPIB64:
 IB = 64                                     'RB=10K
 GoTo SetPNPIB
SetPNPIB128:
 IB = 128                                    'RB=3K3K
SetPNPIB:
  DDRB = IB                                  'IB Output aktivieren
 PORTB = &B00000000                          'PB0...PB7 auf 0
Return
'------------------------------------------------------------------------------
IncrIB:                                      'Increment Basisstrom
 IF IB = 0 Then                              'wenn abgeschaltet
   IB = 1                                    'RB=10M -> kleinster Basisstrom
 Else                                        'sonst
   IF IB < 128 Then                          'wenn Maxwert nicht erreicht
     Shift IB , Left , 1                     'nchst hheren Wert einstellen
   Else                                      'sonst
     IB = 96                                 '3K || 10K einstellen
   End If
 End If
Return
'------------------------------------------------------------------------------
NextTPC:                                     'Nchste  Typ/Pin Config einstellen
  Incr X                                     'Increment Typ/Pin Config
  T = 0                                      'Reset Testpointer
Return
'------------------------------------------------------------------------------
ComplURC:
 URC = 1024 - UX                             'URC = 5V - UX
Return
'------------------------------------------------------------------------------
ComplURB:
 URB = 1024 - UX                             'URB = 5V - UX
Return
'------------------------------------------------------------------------------
ComplUCO1:
 UCO1 = 1024 - UX                            'UCO1 = 5V - UX
Return
'------------------------------------------------------------------------------
ComplUCO2:
 UCO2 = 1024 - UX                            'UCO2 = 5V - UX
Return
'------------------------------------------------------------------------------
ComplUTH:
 UTH = 1024 - UX                             'UTH = 5V - UX
Return
'------------------------------------------------------------------------------
ReadButt:                                    'Tastenabfrage
 DDRD.0 = 0                                  'PD0 Input
 PortD.0 = 1                                 'mit Pullup
 Waitms 50
 Button = PinD.0                             'Read Button an PD0
 DDRD.0 = 1                                  'PD0 wieder Output
Return
'------------------------------------------------------------------------------
Warte:                                       'Wartezeit zum Einschwingen
 Waitms 2                                    'Umschaltungen
 INCR T                                      'Increment Testpointer
'(
 Locate 1 , 18
 LCD IB ; "  "
 Locate 2 , 16
 LCD X ; " "
 Locate 2 , 18
 LCD ":" ; T ; " "
')
 IF Pause = 1 Then GoTo Taste                'Wenn Pause, warten auf Taste
Return
'------------------------------------------------------------------------------
Taste:                                       'Bei Pause Anzeige der Debug-Daten
 CLS
 LCD "DB=" ; DDRB ; " PB=" ; PortB ; " IB=" ; IB
 Home Lower
 LCD "DC=" ; DDRC ; " PC=" ; PortC ; " T=" ; BetaRange ; ":" ; X ; "." ; T
Taste1:
 Do
   PwrDnCtr = 0                              'Reset PwrDnCtr
   GoSub ReadButt                            'Tastenabfrage
   Waitms 20                                 'warte 20ms
 Loop Until Button = 0                       'wiederhole bis Taste gedrckt
Taste2:
 Do
   GoSub ReadButt                            'Tastenabfrage
   Waitms 20                                 'warte 20ms
   'IF T > 0 Then PwrDnCtr = PwrDnCtr + 10
   PwrDnCtr = PwrDnCtr + 10                  'increment PwrDnCtr
   IF PwrDnCtr > 200 Then                    'wenn > 200
     IF T > 0 Then GoTo PwrDn                'und T > 0 Abschalten
   End If
 Loop Until Button = 1                       'wiederhole bis Taste losgelassen
Return
'------------------------------------------------------------------------------
IncrPwrDn:
  'Timer0 = 12                                'Interrupt alle 250ms
  Timer1 = 63583                             'Interrupt alle 250ms
  Incr PwrDnCtr
Return
'------------------------------------------------------------------------------