'SubTone_TY25_PB1PWM.bas: Subtone Generator
'
'Hardware:    ATTiny25 mit 8 MHz Quarz-Oszillator
'
'      Pin 1: Reset (PB5)
'      Pin 2: XTAL1 (PA1)
'      Pin 3: XTAL2 (PA0)
'      Pin 4: GND
'      Pin 5: PB0 (MOSI), FrqSel1
'      Pin 6: PB1 (MISO), SubTone-Output
'      Pin 7: PB2 (SCK),  FrqSel2
'      Pin 8: VDD
'--------------------------------------------------------------------------------------------------------------------

'17.09.2013:  Version 0.1 compiliert mit BC Version 2.0.4.0
'             PWM mit Timer1,
'             Wave-Interrupt mit Timer0
'
'17.10.2013:  Version 1.0 fertiggestellt und getestet
'18.10.2013:  Version 1.1
'             Separate ShortLoop Schleifen eingefhrt, dadurch wurde die Anzahl der Prorammzyklen stark reduziert.
'             Maximale Frequenz ca. 570 Hz
'             Korrektur Algorithmus verbessert, arbeitet jetzt symmetrisch Korrekturen und Nicht-Korrekturen.
'             Version 1.2
'             Compare0A-Interrupt mit Timer0 im CTC Mode spart weitere Programmzyklen
'             Maximale Frequenz ca. 640 Hz
'--------------------------------------------------------------------------------------------------------------------
 'Const SubToneFrequenz1 = 645                               'Subtone Frequenz 1 in Hz, Taste 1
 'Const SubToneFrequenz1 = 280                               'Subtone Frequenz 1 in Hz, Taste 1
 Const SubToneFrequenz1 = 123                               'Subtone Frequenz 1 in Hz, Taste 1
 Const SubToneFrequenz2 = 88.5                              'Subtone Frequenz 2 in Hz, Taste 2
 Const SubToneFrequenz3 = 71.9                              'Subtone Frequenz 3 in Hz, beide Tasten

 Const FrqTest = 0                                          'Frequenztest mit SubToneFrequenz FrqTest
 Const SinIncr = 3                                          'Sinus Increment in Grad
 Const SinTabLg = 360 / SinIncr                             'Lnge der Sinus-Tabelle
 Const SinTabHalbe = SinTabLg / 2                           'Halbe Lnge der Sinus-Tabelle
'--------------------------------------------------------------------------------------------------------------------
 Const OszFreq = 8000000                                    'Oszillatorfrquenz in Hz
 $Regfile = "ATtiny25.dat"                                  'Prozessor ATTiny2313
 $Crystal = OszFreq                                         'Oszillator Quarzfrequenz

 Const TiPrescale = 1                                       'Prescaler Vorgabe

 Const ProgramCykles = 100                                  'Programmzyklen (ShortLoop + Comp0AInt)

 Const NoCounts1 = INT(OszFreq /(SubToneFrequenz1 * SinTabLg))
 Const TiCnt1 = INT(NoCounts1 / TiPrescale)
 Const TiInt1 = INT(TICnt1 / 256)

 Const TiCntF1 = INT(TiCnt1 /(TiInt1 + 1))
 Const TiCntL1 = TiCnt1 -(TiCntF1 * TiInt1)

 Const SollPeriode1 = 1000000 / SubToneFrequenz1            'Soll-Periodendauer des SubTones in us
 Const IstPeriode1 = NoCounts1 * SinTabLg * 1000000 / OszFreq       'Ist-Periodendauer des SubTones in us
 Const Differenz1 = SollPeriode1 - IstPeriode1              'Differenz in us
 Const CycleDiff1 = Differenz1 * OszFreq / 1000000          'Differenz in Zyklen = Anzahl von Korrekturen
 Const CycleDiff1x =(OszFreq / SubToneFrequenz1) - NoCounts1 * SinTabLg       'Differenz in Zyklen

 'Const CycleDiff1 = 115

#if CycleDiff1 <= SinTabHalbe
 Const Korrektur1 = INT(SinTabLg / CycleDiff1)              'Korrektur Abstand
#else
 Const Korrektur1 = INT(SinTabLg /(SinTabLg - CycleDiff1))  'Korrektur Abstand
#endif
 Const KorrStart1 = INT(Korrektur1 / 2)                     'Korrektur Start

#if TiCntL1 <= ProgramCykles
 Const TiCntL1 = "Frequenz nicht mglich!"
#endif

 Const NoCounts2 = INT(OszFreq /(SubToneFrequenz2 * SinTabLg))
 Const TiCnt2 = INT(NoCounts2 / TiPrescale)
 Const TiInt2 = INT(TICnt2 / 256)

 Const TiCntF2 = INT(TiCnt2 /(TiInt2 + 1))
 Const TiCntL2 = TiCnt2 -(TiCntF2 * TiInt2)

 Const SollPeriode2 = 1000000 / SubToneFrequenz2            'Soll-Periodendauer des SubTones in us
 Const IstPeriode2 = NoCounts2 * SinTabLg * 1000000 / OszFreq       'Ist-Periodendauer des SubTones in us
 Const Differenz2 = SollPeriode2 - IstPeriode2              'Differenz in us
 Const CycleDiff2 = Differenz2 * OszFreq / 1000000          'Differenz in Zyklen
 Const CycleDiff2x =(OszFreq / SubToneFrequenz2) - NoCounts2 * SinTabLg       'Differenz in Zyklen

#if CycleDiff2 <= SinTabHalbe
 Const Korrektur2 = INT(SinTabLg / CycleDiff2)              'Korrektur Abstand
#else
 Const Korrektur2 = INT(SinTabLg /(SinTabLg - CycleDiff2))  'Korrektur Abstand
#endif
 Const KorrStart2 = INT(Korrektur2 / 2)                     'Korrektur Start

#if TiCntL2 <= ProgramCykles
 Const TiCntL2 = "Frequenz nicht mglich!"
#endif

 Const NoCounts3 = INT(OszFreq /(SubToneFrequenz3 * SinTabLg))
 Const TiCnt3 = INT(NoCounts3 / TiPrescale)
 Const TiInt3 = INT(TICnt3 / 256)

 Const TiCntF3 = INT(TiCnt3 /(TiInt3 + 1))
 Const TiCntL3 = TiCnt3 -(TiCntF3 * TiInt3)

 Const SollPeriode3 = 1000000 / SubToneFrequenz3            'Soll-Periodendauer des SubTones in us
 Const IstPeriode3 = NoCounts3 * SinTabLg * 1000000 / OszFreq       'Ist-Periodendauer des SubTones in us
 Const Differenz3 = SollPeriode3 - IstPeriode3              'Differenz in us
 Const CycleDiff3 = Differenz3 * OszFreq / 1000000          'Differenz in Zyklen
 Const CycleDiff3x =(OszFreq / SubToneFrequenz3) - NoCounts3 * SinTabLg       'Differenz in Zyklen

#if CycleDiff3 <= SinTabHalbe
 Const Korrektur3 = INT(SinTabLg / CycleDiff3)              'Korrektur Abstand
#else
 Const Korrektur3 = INT(SinTabLg /(SinTabLg - CycleDiff3))  'Korrektur Abstand
#endif
 Const KorrStart3 = INT(Korrektur3 / 2)                     'Korrektur Start

#if TiCntL3 <= ProgramCykles
 Const TiCntL3 = "Frequenz nicht mglich!"
#endif

'--------------------------------------------------------------------------------------------------------------------
 Dim K1 AS Byte                                             'Korrekturzeiger
 Dim K2 AS Byte                                             'Korrekturwert
 Dim KS AS Byte                                             'Start des Korrekturzeigers
 Dim I AS Byte                                              'Pointer in Sinustabelle
 Dim IntCnt AS Byte                                         'Anzahl der Anfabgsphasen
 Dim FrqSel AS Byte                                         'Frequenzwahl Variable
 Dim Port AS Byte                                           'Port Wert
'--------------------------------------------------------------------------------------------------------------------
 DDRB = &B000011010                                         'PORTB.1, B.3 und B.4 Output, Rest Input
PORTB = &B111100101                                         'Outputs LO, alle Inputs mit PullUp

 FrqSel2 Alias PINB.2                                       'FrqSel2 an INT0, fr Tone2
 FrqSel1 Alias PINB.0                                       'FrqSel1 fr Tone1
 SubTone Alias PortB.0                                      'PWM-Ausgang OC0A oder OC1A| fr Sub-Ton Output
 PWM_Reg Alias OCR1A                                        'Output Compare Register fr Sub-Ton ist OCR1A
 Tmp_Reg Alias OCR1B                                        '
 Test1 Alias PortB.3                                        'Testsignal (nur mit internem Oszillator)
 Test2 Alias PortB.4                                        'Testsignal1 fr Interrupt-Test (nur mit internem Oszillator)
'--------------------------------------------------------------------------------------------------------------------

 'OSCCAL = &H5C                                              '251,5KHz * 32 = 8,048 MHz
 OSCCAL = &H5B                                              '250KHz * 32 = 8,000 MHz

 Waitus 100
 PLLCSR.1 = 1                                               'PLL Enable

 While PLLCSR.0 = 0                                         'Wait for PLL-Lock
 Wend

 Waitus 100

 PLLCSR.2 = 1                                               'PCK Enable: PWM-Periode 4us, sonst 32us
 'PLLCSR.7 = 1                                               'Low Speed Mode: PWM-Periode 8us

 On Compare0A Comp0AInt , NOSAVE                            'Compare0A Interrupt-Routine
 TccR0A = &B00000010                                        'Timer0: CTC Mode
 TccR0B = &B00000001                                        'Timer0: no Prescaling
 OCR0A = 47                                                 'OCRA = Count-1, min = 39 -> 5 us
 Enable Compare0A                                           'Compare0A Interrupt


 TccR1 = &B01010001                                         'Timer1: no Prescaling, phasecorrect PWM on Output A, Clr on up, Set on down,
 OCR1C = 255

 Enable Interrupts

'--------------------------------------------------------------------------------------------------------------------


Main:

#if FrqTest = 0
  FrqSel = PINB AND &B00000101
#endif

#if FrqTest = 1
  FrqSel = 4
#endif
#if FrqTest = 2
  FrqSel = 1
#endif
#if FrqTest = 3
  FrqSel = 0
#endif

  IF FrqSel = 4 Then Goto ShortLoop1                        'Frequenz 1

  IF FrqSel = 1 Then Goto ShortLoop2                        'Frequenz 2

  IF FrqSel = 0 Then Goto ShortLoop3                        'Frequenz 3

  PWM_Reg = 127

  OCR0A = 250

  Idle

  Goto Main


ShortLoop1:

  Idle                                                      '??? Zyklen

  IF IntCnt = 0 Then                                        '5 Zyklen
    ReadEEPROM PWM_Reg , I                                  '36 Zyklen
    IntCnt = TiINT1                                         '3 Zyklen
    Incr I                                                  '6 Zyklen
    IF I => SinTabLg Then                                   '5 Zyklen
      I = 0                                                 '3 Zyklen
      K1 = KorrStart1                                       '3 Zyklen
      K2 = Korrektur1                                       '3 Zyklen
      Port = PINB AND &B00000101                            '6 Zyklen
     #if FrqTest = 0
      IF FrqSel <> Port Then Goto Main                      '9 Zylen
     #endif
    Else                                                    '6 Zyklen
      Incr K1                                               '6 Zyklen
     #if CycleDiff1 <= SinTabHalbe
      IF K1 => K2 Then                                      '6 Zyklen
        K2 = K2 + Korrektur1                                '6 Zyklen
        OCR0A = TiCntL1                                     '3 Zyklen
      Else                                                  '6 Zyklen
        OCR0A = TiCntL1 - 1                                 '3 Zyklen
      End If
    #else
      IF K1 => K2 Then                                      '6 Zyklen
        K2 = K2 + Korrektur1                                '6 Zyklen
        OCR0A = TiCntL1 - 1                                 '3 Zyklen
      Else                                                  '6 Zyklen
        OCR0A = TiCntL1                                     '3 Zyklen
      End If
    #endif
    End If
  Else
    OCR0A = TiCntF1 - 1                                     '3 Zyklen
    Decr IntCnt                                             '5Zyklen
  End If

  Goto ShortLoop1                                           '2 Zyklen

ShortLoop2:

  Idle                                                      '??? Zyklen

  IF IntCnt = 0 Then                                        '5 Zyklen
    ReadEEPROM PWM_Reg , I                                  '36 Zyklen
    IntCnt = TiINT2                                         '3 Zyklen
    Incr I                                                  '6 Zyklen
    IF I => SinTabLg Then                                   '5 Zyklen
      I = 0                                                 '3 Zyklen
      K1 = KorrStart2                                       '3 Zyklen
      K2 = Korrektur2                                       '3 Zyklen
      Port = PINB AND &B00000101                            '6 Zyklen
     #if FrqTest = 0
      IF FrqSel <> Port Then Goto Main                      '9 Zylen
     #endif
    Else                                                    '6 Zyklen
      Incr K1                                               '6 Zyklen
     #if CycleDiff2 <= SinTabHalbe
      IF K1 => K2 Then                                      '6 Zyklen
        K2 = K2 + Korrektur2                                '6 Zyklen
        OCR0A = TiCntL2                                     '3 Zyklen
      Else                                                  '6 Zyklen
        OCR0A = TiCntL2 - 1                                 '3 Zyklen
      End If
    #else
      IF K1 => K2 Then                                      '6 Zyklen
        K2 = K2 + Korrektur2                                '6 Zyklen
        OCR0A = TiCntL2 - 1                                 '3 Zyklen
      Else                                                  '6 Zyklen
        OCR0A = TiCntL2                                     '3 Zyklen
      End If
    #endif
    End If
  Else
    OCR0A = TiCntF2 - 1                                     '3 Zyklen
    Decr IntCnt                                             '5Zyklen
  End If

  Goto ShortLoop2                                           '2 Zyklen

ShortLoop3:

  Idle                                                      '??? Zyklen

  IF IntCnt = 0 Then                                        '5 Zyklen
    ReadEEPROM PWM_Reg , I                                  '36 Zyklen
    IntCnt = TiINT3                                         '3 Zyklen
    Incr I                                                  '6 Zyklen
    IF I => SinTabLg Then                                   '5 Zyklen
      I = 0                                                 '3 Zyklen
      K1 = KorrStart3                                       '3 Zyklen
      K2 = Korrektur3                                       '3 Zyklen
      Port = PINB AND &B00000101                            '6 Zyklen
     #if FrqTest = 0
      IF FrqSel <> Port Then Goto Main                      '9 Zylen
     #endif
    Else                                                    '6 Zyklen
      Incr K1                                               '6 Zyklen
     #if CycleDiff3 <= SinTabHalbe
      IF K1 => K2 Then                                      '6 Zyklen
        K2 = K2 + Korrektur3                                '6 Zyklen
        OCR0A = TiCntL3                                     '3 Zyklen
      Else                                                  '6 Zyklen
        OCR0A = TiCntL3 - 1                                 '3 Zyklen
      End If
    #else
      IF K1 => K2 Then                                      '6 Zyklen
        K2 = K2 + Korrektur3                                '6 Zyklen
        OCR0A = TiCntL3 - 1                                 '3 Zyklen
      Else                                                  '6 Zyklen
        OCR0A = TiCntL3                                     '3 Zyklen
      End If
    #endif
    End If
  Else
    OCR0A = TiCntF3 - 1                                     '3 Zyklen
    Decr IntCnt                                             '5Zyklen
  End If

  Goto ShortLoop3                                           '2 Zyklen

'--------------------------------------------------------------------------------------------------------------------
Comp0AInt:                                                  'Interrupt Timer0
  Return                                                    '4 Zyklen
'--------------------------------------------------------------------------------------------------------------------
'Sinusdefinitionen

Const SinTab0 = INT(0.5 +(1 + Sin(6.28 * 0 * SinIncr / 360)) * 127)
Const SinTab1 = INT(0.5 +(1 + Sin(6.28 * 1 * SinIncr / 360)) * 127)
Const SinTab2 = INT(0.5 +(1 + Sin(6.28 * 2 * SinIncr / 360)) * 127)
Const SinTab3 = INT(0.5 +(1 + Sin(6.28 * 3 * SinIncr / 360)) * 127)
Const SinTab4 = INT(0.5 +(1 + Sin(6.28 * 4 * SinIncr / 360)) * 127)
Const SinTab5 = INT(0.5 +(1 + Sin(6.28 * 5 * SinIncr / 360)) * 127)
Const SinTab6 = INT(0.5 +(1 + Sin(6.28 * 6 * SinIncr / 360)) * 127)
Const SinTab7 = INT(0.5 +(1 + Sin(6.28 * 7 * SinIncr / 360)) * 127)
Const SinTab8 = INT(0.5 +(1 + Sin(6.28 * 8 * SinIncr / 360)) * 127)
Const SinTab9 = INT(0.5 +(1 + Sin(6.28 * 9 * SinIncr / 360)) * 127)
Const SinTab10 = INT(0.5 +(1 + Sin(6.28 * 10 * SinIncr / 360)) * 127)
Const SinTab11 = INT(0.5 +(1 + Sin(6.28 * 11 * SinIncr / 360)) * 127)
Const SinTab12 = INT(0.5 +(1 + Sin(6.28 * 12 * SinIncr / 360)) * 127)
Const SinTab13 = INT(0.5 +(1 + Sin(6.28 * 13 * SinIncr / 360)) * 127)
Const SinTab14 = INT(0.5 +(1 + Sin(6.28 * 14 * SinIncr / 360)) * 127)
Const SinTab15 = INT(0.5 +(1 + Sin(6.28 * 15 * SinIncr / 360)) * 127)
Const SinTab16 = INT(0.5 +(1 + Sin(6.28 * 16 * SinIncr / 360)) * 127)
Const SinTab17 = INT(0.5 +(1 + Sin(6.28 * 17 * SinIncr / 360)) * 127)
Const SinTab18 = INT(0.5 +(1 + Sin(6.28 * 18 * SinIncr / 360)) * 127)
Const SinTab19 = INT(0.5 +(1 + Sin(6.28 * 19 * SinIncr / 360)) * 127)
Const SinTab20 = INT(0.5 +(1 + Sin(6.28 * 20 * SinIncr / 360)) * 127)
Const SinTab21 = INT(0.5 +(1 + Sin(6.28 * 21 * SinIncr / 360)) * 127)
Const SinTab22 = INT(0.5 +(1 + Sin(6.28 * 22 * SinIncr / 360)) * 127)
Const SinTab23 = INT(0.5 +(1 + Sin(6.28 * 23 * SinIncr / 360)) * 127)
Const SinTab24 = INT(0.5 +(1 + Sin(6.28 * 24 * SinIncr / 360)) * 127)
Const SinTab25 = INT(0.5 +(1 + Sin(6.28 * 25 * SinIncr / 360)) * 127)
Const SinTab26 = INT(0.5 +(1 + Sin(6.28 * 26 * SinIncr / 360)) * 127)
Const SinTab27 = INT(0.5 +(1 + Sin(6.28 * 27 * SinIncr / 360)) * 127)
Const SinTab28 = INT(0.5 +(1 + Sin(6.28 * 28 * SinIncr / 360)) * 127)
Const SinTab29 = INT(0.5 +(1 + Sin(6.28 * 29 * SinIncr / 360)) * 127)
Const SinTab30 = INT(0.5 +(1 + Sin(6.28 * 30 * SinIncr / 360)) * 127)
Const SinTab31 = INT(0.5 +(1 + Sin(6.28 * 31 * SinIncr / 360)) * 127)
Const SinTab32 = INT(0.5 +(1 + Sin(6.28 * 32 * SinIncr / 360)) * 127)
Const SinTab33 = INT(0.5 +(1 + Sin(6.28 * 33 * SinIncr / 360)) * 127)
Const SinTab34 = INT(0.5 +(1 + Sin(6.28 * 34 * SinIncr / 360)) * 127)
Const SinTab35 = INT(0.5 +(1 + Sin(6.28 * 35 * SinIncr / 360)) * 127)
Const SinTab36 = INT(0.5 +(1 + Sin(6.28 * 36 * SinIncr / 360)) * 127)
Const SinTab37 = INT(0.5 +(1 + Sin(6.28 * 37 * SinIncr / 360)) * 127)
Const SinTab38 = INT(0.5 +(1 + Sin(6.28 * 38 * SinIncr / 360)) * 127)
Const SinTab39 = INT(0.5 +(1 + Sin(6.28 * 39 * SinIncr / 360)) * 127)
Const SinTab40 = INT(0.5 +(1 + Sin(6.28 * 40 * SinIncr / 360)) * 127)
Const SinTab41 = INT(0.5 +(1 + Sin(6.28 * 41 * SinIncr / 360)) * 127)
Const SinTab42 = INT(0.5 +(1 + Sin(6.28 * 42 * SinIncr / 360)) * 127)
Const SinTab43 = INT(0.5 +(1 + Sin(6.28 * 43 * SinIncr / 360)) * 127)
Const SinTab44 = INT(0.5 +(1 + Sin(6.28 * 44 * SinIncr / 360)) * 127)
Const SinTab45 = INT(0.5 +(1 + Sin(6.28 * 45 * SinIncr / 360)) * 127)
Const SinTab46 = INT(0.5 +(1 + Sin(6.28 * 46 * SinIncr / 360)) * 127)
Const SinTab47 = INT(0.5 +(1 + Sin(6.28 * 47 * SinIncr / 360)) * 127)
Const SinTab48 = INT(0.5 +(1 + Sin(6.28 * 48 * SinIncr / 360)) * 127)
Const SinTab49 = INT(0.5 +(1 + Sin(6.28 * 49 * SinIncr / 360)) * 127)
Const SinTab50 = INT(0.5 +(1 + Sin(6.28 * 50 * SinIncr / 360)) * 127)
Const SinTab51 = INT(0.5 +(1 + Sin(6.28 * 51 * SinIncr / 360)) * 127)
Const SinTab52 = INT(0.5 +(1 + Sin(6.28 * 52 * SinIncr / 360)) * 127)
Const SinTab53 = INT(0.5 +(1 + Sin(6.28 * 53 * SinIncr / 360)) * 127)
Const SinTab54 = INT(0.5 +(1 + Sin(6.28 * 54 * SinIncr / 360)) * 127)
Const SinTab55 = INT(0.5 +(1 + Sin(6.28 * 55 * SinIncr / 360)) * 127)
Const SinTab56 = INT(0.5 +(1 + Sin(6.28 * 56 * SinIncr / 360)) * 127)
Const SinTab57 = INT(0.5 +(1 + Sin(6.28 * 57 * SinIncr / 360)) * 127)
Const SinTab58 = INT(0.5 +(1 + Sin(6.28 * 58 * SinIncr / 360)) * 127)
Const SinTab59 = INT(0.5 +(1 + Sin(6.28 * 59 * SinIncr / 360)) * 127)
Const SinTab60 = INT(0.5 +(1 + Sin(6.28 * 60 * SinIncr / 360)) * 127)
Const SinTab61 = INT(0.5 +(1 + Sin(6.28 * 61 * SinIncr / 360)) * 127)
Const SinTab62 = INT(0.5 +(1 + Sin(6.28 * 62 * SinIncr / 360)) * 127)
Const SinTab63 = INT(0.5 +(1 + Sin(6.28 * 63 * SinIncr / 360)) * 127)
Const SinTab64 = INT(0.5 +(1 + Sin(6.28 * 64 * SinIncr / 360)) * 127)
Const SinTab65 = INT(0.5 +(1 + Sin(6.28 * 65 * SinIncr / 360)) * 127)
Const SinTab66 = INT(0.5 +(1 + Sin(6.28 * 66 * SinIncr / 360)) * 127)
Const SinTab67 = INT(0.5 +(1 + Sin(6.28 * 67 * SinIncr / 360)) * 127)
Const SinTab68 = INT(0.5 +(1 + Sin(6.28 * 68 * SinIncr / 360)) * 127)
Const SinTab69 = INT(0.5 +(1 + Sin(6.28 * 69 * SinIncr / 360)) * 127)
Const SinTab70 = INT(0.5 +(1 + Sin(6.28 * 70 * SinIncr / 360)) * 127)
Const SinTab71 = INT(0.5 +(1 + Sin(6.28 * 71 * SinIncr / 360)) * 127)
Const SinTab72 = INT(0.5 +(1 + Sin(6.28 * 72 * SinIncr / 360)) * 127)
Const SinTab73 = INT(0.5 +(1 + Sin(6.28 * 73 * SinIncr / 360)) * 127)
Const SinTab74 = INT(0.5 +(1 + Sin(6.28 * 74 * SinIncr / 360)) * 127)
Const SinTab75 = INT(0.5 +(1 + Sin(6.28 * 75 * SinIncr / 360)) * 127)
Const SinTab76 = INT(0.5 +(1 + Sin(6.28 * 76 * SinIncr / 360)) * 127)
Const SinTab77 = INT(0.5 +(1 + Sin(6.28 * 77 * SinIncr / 360)) * 127)
Const SinTab78 = INT(0.5 +(1 + Sin(6.28 * 78 * SinIncr / 360)) * 127)
Const SinTab79 = INT(0.5 +(1 + Sin(6.28 * 79 * SinIncr / 360)) * 127)
Const SinTab80 = INT(0.5 +(1 + Sin(6.28 * 80 * SinIncr / 360)) * 127)
Const SinTab81 = INT(0.5 +(1 + Sin(6.28 * 81 * SinIncr / 360)) * 127)
Const SinTab82 = INT(0.5 +(1 + Sin(6.28 * 82 * SinIncr / 360)) * 127)
Const SinTab83 = INT(0.5 +(1 + Sin(6.28 * 83 * SinIncr / 360)) * 127)
Const SinTab84 = INT(0.5 +(1 + Sin(6.28 * 84 * SinIncr / 360)) * 127)
Const SinTab85 = INT(0.5 +(1 + Sin(6.28 * 85 * SinIncr / 360)) * 127)
Const SinTab86 = INT(0.5 +(1 + Sin(6.28 * 86 * SinIncr / 360)) * 127)
Const SinTab87 = INT(0.5 +(1 + Sin(6.28 * 87 * SinIncr / 360)) * 127)
Const SinTab88 = INT(0.5 +(1 + Sin(6.28 * 88 * SinIncr / 360)) * 127)
Const SinTab89 = INT(0.5 +(1 + Sin(6.28 * 89 * SinIncr / 360)) * 127)
Const SinTab90 = INT(0.5 +(1 + Sin(6.28 * 90 * SinIncr / 360)) * 127)
Const SinTab91 = INT(0.5 +(1 + Sin(6.28 * 91 * SinIncr / 360)) * 127)
Const SinTab92 = INT(0.5 +(1 + Sin(6.28 * 92 * SinIncr / 360)) * 127)
Const SinTab93 = INT(0.5 +(1 + Sin(6.28 * 93 * SinIncr / 360)) * 127)
Const SinTab94 = INT(0.5 +(1 + Sin(6.28 * 94 * SinIncr / 360)) * 127)
Const SinTab95 = INT(0.5 +(1 + Sin(6.28 * 95 * SinIncr / 360)) * 127)
Const SinTab96 = INT(0.5 +(1 + Sin(6.28 * 96 * SinIncr / 360)) * 127)
Const SinTab97 = INT(0.5 +(1 + Sin(6.28 * 97 * SinIncr / 360)) * 127)
Const SinTab98 = INT(0.5 +(1 + Sin(6.28 * 98 * SinIncr / 360)) * 127)
Const SinTab99 = INT(0.5 +(1 + Sin(6.28 * 99 * SinIncr / 360)) * 127)
Const SinTab100 = INT(0.5 +(1 + Sin(6.28 * 100 * SinIncr / 360)) * 127)
Const SinTab101 = INT(0.5 +(1 + Sin(6.28 * 101 * SinIncr / 360)) * 127)
Const SinTab102 = INT(0.5 +(1 + Sin(6.28 * 102 * SinIncr / 360)) * 127)
Const SinTab103 = INT(0.5 +(1 + Sin(6.28 * 103 * SinIncr / 360)) * 127)
Const SinTab104 = INT(0.5 +(1 + Sin(6.28 * 104 * SinIncr / 360)) * 127)
Const SinTab105 = INT(0.5 +(1 + Sin(6.28 * 105 * SinIncr / 360)) * 127)
Const SinTab106 = INT(0.5 +(1 + Sin(6.28 * 106 * SinIncr / 360)) * 127)
Const SinTab107 = INT(0.5 +(1 + Sin(6.28 * 107 * SinIncr / 360)) * 127)
Const SinTab108 = INT(0.5 +(1 + Sin(6.28 * 108 * SinIncr / 360)) * 127)
Const SinTab109 = INT(0.5 +(1 + Sin(6.28 * 109 * SinIncr / 360)) * 127)
Const SinTab110 = INT(0.5 +(1 + Sin(6.28 * 110 * SinIncr / 360)) * 127)
Const SinTab111 = INT(0.5 +(1 + Sin(6.28 * 111 * SinIncr / 360)) * 127)
Const SinTab112 = INT(0.5 +(1 + Sin(6.28 * 112 * SinIncr / 360)) * 127)
Const SinTab113 = INT(0.5 +(1 + Sin(6.28 * 113 * SinIncr / 360)) * 127)
Const SinTab114 = INT(0.5 +(1 + Sin(6.28 * 114 * SinIncr / 360)) * 127)
Const SinTab115 = INT(0.5 +(1 + Sin(6.28 * 115 * SinIncr / 360)) * 127)
Const SinTab116 = INT(0.5 +(1 + Sin(6.28 * 116 * SinIncr / 360)) * 127)
Const SinTab117 = INT(0.5 +(1 + Sin(6.28 * 117 * SinIncr / 360)) * 127)
Const SinTab118 = INT(0.5 +(1 + Sin(6.28 * 118 * SinIncr / 360)) * 127)
Const SinTab119 = INT(0.5 +(1 + Sin(6.28 * 119 * SinIncr / 360)) * 127)

 $EEPROM

 Data SinTab0
 Data SinTab1
 Data SinTab2
 Data SinTab3
 Data SinTab4
 Data SinTab5
 Data SinTab6
 Data SinTab7
 Data SinTab8
 Data SinTab9
 Data SinTab10
 Data SinTab11
 Data SinTab12
 Data SinTab13
 Data SinTab14
 Data SinTab15
 Data SinTab16
 Data SinTab17
 Data SinTab18
 Data SinTab19
 Data SinTab20
 Data SinTab21
 Data SinTab22
 Data SinTab23
 Data SinTab24
 Data SinTab25
 Data SinTab26
 Data SinTab27
 Data SinTab28
 Data SinTab29
 Data SinTab30
 Data SinTab31
 Data SinTab32
 Data SinTab33
 Data SinTab34
 Data SinTab35
 Data SinTab36
 Data SinTab37
 Data SinTab38
 Data SinTab39
 Data SinTab40
 Data SinTab41
 Data SinTab42
 Data SinTab43
 Data SinTab44
 Data SinTab45
 Data SinTab46
 Data SinTab47
 Data SinTab48
 Data SinTab49
 Data SinTab50
 Data SinTab51
 Data SinTab52
 Data SinTab53
 Data SinTab54
 Data SinTab55
 Data SinTab56
 Data SinTab57
 Data SinTab58
 Data SinTab59
 Data SinTab60
 Data SinTab61
 Data SinTab62
 Data SinTab63
 Data SinTab64
 Data SinTab65
 Data SinTab66
 Data SinTab67
 Data SinTab68
 Data SinTab69
 Data SinTab70
 Data SinTab71
 Data SinTab72
 Data SinTab73
 Data SinTab74
 Data SinTab75
 Data SinTab76
 Data SinTab77
 Data SinTab78
 Data SinTab79
 Data SinTab80
 Data SinTab81
 Data SinTab82
 Data SinTab83
 Data SinTab84
 Data SinTab85
 Data SinTab86
 Data SinTab87
 Data SinTab88
 Data SinTab89
 Data SinTab90
 Data SinTab91
 Data SinTab92
 Data SinTab93
 Data SinTab94
 Data SinTab95
 Data SinTab96
 Data SinTab97
 Data SinTab98
 Data SinTab99
 Data SinTab100
 Data SinTab101
 Data SinTab102
 Data SinTab103
 Data SinTab104
 Data SinTab105
 Data SinTab106
 Data SinTab107
 Data SinTab108
 Data SinTab109
 Data SinTab110
 Data SinTab111
 Data SinTab112
 Data SinTab113
 Data SinTab114
 Data SinTab115
 Data SinTab116
 Data SinTab117
 Data SinTab118
 Data SinTab119
 Data SinTab0