'------------------------------------------------------------------------------
'RI-TesterV2.bas       Innenwiderstands-Messgert Version 2
'                      ILmax=210mA
'Historie:
'
'
'V1: 19.12.09
'    Erste erprobte Version nach prinzipiellem Test
'
'-------------------------------------------------------------------------------
'Hardware:     Stromlauf RI-Messer.dsn

'              Prozessor: ATtiny26
'              LCD Display HMC16223SG-3 von Pollin:
'
'              16x2 LCD-Anzeige
'              LCD-Verbindungen:

'              LCD01 an Masse (VSS)
'              LCD02 an +5V   (VDD)
'              LCD03 an Poti  (VLC)
'              LCD04 an PB5   (RS)
'              LCD05 an Masse (RW)
'              LCD06 an PB4   (E)
'              LCD07 an Masse (VSS)
'              LCD08 an Masse (VSS)
'              LCD09 an Masse (VSS)
'              LCD10 an Masse (VSS)
'              LCD11 an PB3   (DB4)
'              LCD12 an PB2   (DB5)
'              LCD13 an PB1   (DB6)
'              LCD14 an PB0   (DB7)

'Der RW-Eingang der LCD-Anzeige wird fest auf Masse gelegt.
'
'------------------------------------------------------------------------------
'Portbelegung: PortA Analog-Inputs und Lastschalter-Outputs:
'
'              PortA.0 = ADC0: UBT/1in, Input ohne Pullup
'              PortA.1 = ADC1: UBT/2in, Input ohne Pullup
'              PortA.2 = ADC2: UBT/5in, Input ohne Pullup
'              PortA.3 = Signal zum Kurzschlieen der Verpolschutz-Diode
'              PortA.4 = ADC3: UBat/2in, Input ohne Pullup
'              PortA.5 = LastStrom Bit 0, Output
'              PortA.6 = LastStrom Bit 1, Output
'              PortA.7 = LastStrom Bit 2, Output
'
'              PortB LCD Display und Power-Schalter:
'
'              PortB.0 = Db7, Output
'              PortB.1 = Db6, Output
'              PortB.2 = Db5, Output
'              PortB.3 = Db4, Output
'              PortB.4 = E, Output
'              PortB.5 = RS, Output
'              PortB.6 = PwrOn, Output
'              PortB.7 = Reset
'
'-------------------------------------------------------------------------------
'Funktionsbeschreibung:
'
'-------------------------------------------------------------------------------

'1992 Bytes, 97%
'-------------------------------------------------------------------------------
'$regfile = "ATtiny26.dat"
$regfile = "AT26def.dat"
$crystal = 1000000                           '1,00000 MHz interner Oszillator

$hwstack = 32                                'default use 32 for the hardware stack
$swstack = 10                                'default use 10 for the SW stack
$framesize = 24                              'default use 40 for the frame space

'------------------------------------------------------------------------------
'Variablen

Dim J As Byte                                'Zhlvariable fr ADC Eingang
Dim PwrDn As Byte                            'Zhlvariable fr Power Down
Dim LTemp As Long                            'Hilfsvariable zur UB-Berechnung
Dim TmpLen As Byte                           'Lnge von TmpTxt
Dim UA As Byte                               'min. Spannungsabfall fr Laststromwahl
Dim UB As Word                               'aktuell gemessene Spannung
Dim TX As Word At $68 Overlay                'Wert fr Textausgabe Overlay auf UB
Dim UB0 As Word                              'Leerlaufspannung 16 Bit
Dim UBL As Word                              'Lastspannung 16 Bit
Dim RI As Word                               'Innenwiderstand
Dim IL As Byte                               'relativer Belastungsstrom
Dim ILakt As Byte                            'aktueller Belastungsstrom
Dim TmpTxt As String * 6                     'Hilfsstring

'------------------------------------------------------------------------------

'Ausgabe-Ports

 DDRA = &B11101000                           'PA0 bis PA2 u. PA4 Input, PA3 u. PA.5 bis PA7 Output
PORTA = &B00000000                           'Alle Inputs ohne Pullup, alle Outputs = 0

 DDRB = &B11111111                           'Alles Output, fr LCD und PwrOn
PORTB = &B01000000                           'PB6=1, Alle anderen Outputs = 0

'------------------------------------------------------------------------------

 Config Lcd = 16 * 2                         'LCD Konfiguration

 Config Lcdpin = Pin , Db4 = PortB.3 , Db5 = PortB.2 , Db6 = PortB.1 , Db7 = PortB.0 , E = PortB.4 , Rs = PortB.5

'------------------------------------------------------------------------------

 Config Adc = Single , Prescaler = Auto

'------------------------------------------------------------------------------
 Cls                                         'Display lschen
 Cursor Off                                  'LCD-Kursor ausschalten

 Start ADC
 GOTO Logo
'------------------------------------------------------------------------------
Main:

 IL = 0                                      'Belastung abschalten, IL=0
 PORTA = PORTA AND &B00001000                'Laststrom abschalten
 J = 2                                       'UB >= 408  1:5 Bereich 10...25V

 Gosub MesseUB                               'Leerlaufspannung ber 1:5 Teiler
 Home Upper
 IF UB > 20 Then                             'Messwertausgabe wenn > 0,5V
   UA = 100                                  'Spannungsabfall 1V
   IF UB < 408 Then                          '204...408 1:2 Bereich  5...10V
     J = 1
     UA = 50                                 'Spannungsabfall 0,5V
   End If
   IF UB < 204 Then
     J = 0                                   '< 204     1:1 Bereich  0...5V
     UA = 20                                 'Spannungsabfall 0,2V
   End If

   Gosub MesseUB                             'messe Lerlaufspannung, IL=0
   UB0 = UB

IncrIL:

   IL = IL + 32                              'IL = 10..70 mA in 10mA Schritten
   PORTA = IL
   IF UB0 < 300 Then                         'wenn UB < 3V
     PORTA = PORTA OR &B00001000             'Verpolschutzdiode kurzschlieen
   End If
   Gosub MesseUB                             'messe Spannung unter Last
   UBL = UB                                  '100 facher Wert
   IF UBL > UB0 Then UBL = UB0               'definierter Nullpunkt
   RI = UB0 - UBL                            'Spannungsabfall bei Last, 2 Nachkommastellen
   IF IL < 224 Then                          'Laststrom max. 7*32 => 70mA
     IF RI < UA Then GOTO IncrIL             'Wenn Spannungsabfall < UA, Laststrom erhhen
   End If

   Shift , IL , Right , 5                    'IL-Wert 1...7
   ILakt = IL * 3
   RI = RI * 10                              'Berechnung auf 1 Nachkommastelle
   RI = RI / ILakt                           'Textausgabe RI=(U0-UL)/IL

   LCD "U0="
   UB = UB0                                  '100 facher Wert
   Gosub UBout                               'U0-Ausgabe mit 1 Nachkommastelle
   LCD " I="
   LCD ILakt                                 'IL-Ausgabe
   LCD "0mA "                                '*10mA
   Home Lower
   LCD "UL="
   UB = UBL                                  '100 facher Wert
   Gosub UBout                               'UL-Ausgabe mit 1 Nachkommastelle

   LCD " RI="                                'RI-Ausgabe maximal dreistellig
   TX = RI
   Gosub GetTxt                              'RI-Wert in String umwandeln

   IF TmpLen = 0 Then
     Lcd "0"                                 '0 und Komma
     Gosub LcdRight                          'Komma und Nachkommastelle
   Else
     IF TmpLen > 3 Then                      'berlauf >999 mehr als dreistellig
       LCD "999"
     Else
       Gosub LcdLeft                         'Ausgabe von 1, 2 oder 3 Stellen
     End If
     IF TmpLen = 1 Then                      'bei einer Stelle
       Gosub LcdRight                        'Komma und Nachkommastelle
     End If
   End If
   LCD Chr(&HF4)                             'Ohm Symbol
   LCD "  "                                  'lscht Rest der Zeile
   PwrDn = 0                                 'Power On
   PortB.6 = 1
 Else                                        'sonst Logo und Batteriesannung
Logo:
   PortA = 0                                 'Laststrom abscchalten und Verpolschutzdiode aktivieren
   LCD "RI-Tester DJ1MHR"
   Home Lower
   J = 3                                     'Betriebsspannung an ADC3
   Gosub MesseUB
   LCD "  UBatt = "
   Gosub UBout                               'UB-Ausgabe
   LCD " "
   Incr PwrDn                                'Incr Power Down Zhler
   If PwrDn > 50 Then PortB.6 = 0            'Abschalten nach ca. 15 sec

 End If

 Goto Main
'------------------------------------------------------------------------------
MesseUB:                                     'Messen der Spannung

 Waitms 100
 UB = GetAdc(J)
 LTemp = 500 * UB
 LTemp = LTemp / 1023
 UB = LTemp                                  '*1 bei J=0
 IF J = 1 Then UB = UB * 2                   '*2 bei J=1
 IF J > 1 Then UB = UB * 5                   '*5 bei J=2 und 3

 Return
 '-------------------------------------------------------------------------------
UBout:                                       'Anzeige der Spannung
 TX = UB / 10                                'Textausgbe auf 1 Nachkommastelle
 Gosub GetTxt                                'Wert in Text wandeln und Lnge berechnen
 IF TmpLen = 0 Then
   Lcd " 0"                                  '0
 Else
   IF TmpLen = 1 Then LCD " "                'Blank wenn zweistellig
   Gosub LcdLeft                             'dann Ausgabe von 1 oder 2 Stellen
 End If
 Gosub LcdRight                              'Komma und eine Nachkommastelle
 Lcd "V"                                     '"V" anfgen
Return
'-------------------------------------------------------------------------------
GetTxt:
  TmpTxt = Str(TX)                           'Spannungswert in String umwandeln
  TmpLen = Len(TmpTxt)                       'Lnge des Strings in TmpLen
  TmpLen = TmpLen - 1                        'TmpLen reduzieren fr Index
Return
'-------------------------------------------------------------------------------
LcdLeft:
 Lcd Left(TmpTxt , TmpLen)                   'Ausgabe von S Stellen vor dem Komma
Return
'-------------------------------------------------------------------------------
LcdRight:
 Lcd ","                                     'Komma anfgen
 LCD Right(TmpTxt , 1)                       'Ausgabe einer Nachkommastelle
Return
'-------------------------------------------------------------------------------