'------------------------------------------------------------------------------
'LiIonLaderV41.bas Ladegert fr Lithium-Ionen-Akkus Version 41 mit Schaltregler
'                  und ATtiny861 Prozessor
'Historie:
'
'
'V4:  01.01.10     Erste erprobte Version nach prinzipiellem Test
'V41: 11.02.2012   Fehler in der Ladestrommessung beseitigt.
'                  der gemessene Ladestrom muss durch 8 geteilt werden, nicht durch 4
'                  Softwareergnzung zur Anzeige des letzten Wertes von UB bei Ladungsunterbrechung
'                  Softwareergnzung damit nach Beenden eines Ladevorgangs die letzten Ladedaten (QL, RI und UB)
'                  nur solange stehen bleiben, bis eine der Voreinstellungen (UBmax oder ILmax) gendert wird.
'                  Fehler "kein Ready!" bei QL > 99: Ursache Lnge von TmpTxt, von 4 auf 8 gendert.
'                  ILmin von konstant 5mA auf Variable ILmax/4 umgestellt.
'                  Anzeige des letzten Wertes von UB bei Ladungsunterbrechung
'                  Laufzeittest mit LZTest = 1 eingebaut. LZPuls an PA0, IL=300mA fest vorgegeben.
'                  Laufzeiten gemessen, Werte aktualisiert, Zykluslnge auf 1680us eingestellt.
'
'---------------------------------------------------------------------------------------------------------------
'Hardware:     Stromlauf LiIonLader.dsn

'              Prozessor: ATtiny26
'              LCD Display HMC16223SG-3 von Pollin:
'
'              16x2 LCD-Anzeige
'              LCD-Verbindungen:

'              LCD01 an Masse (VSS)
'              LCD02 an +5V   (VDD)
'              LCD03 an Poti  (VLC)
'              LCD04 an PB5   (RS)
'              LCD05 an Masse (RW)
'              LCD06 an PB4   (E)
'              LCD07 an Masse (VSS)
'              LCD08 an Masse (VSS)
'              LCD09 an Masse (VSS)
'              LCD10 an Masse (VSS)
'              LCD11 an PB3   (DB4)
'              LCD12 an PB2   (DB5)
'              LCD13 an PB6   (DB6)
'              LCD14 an PB0   (DB7)

'Der RW-Eingang der LCD-Anzeige wird fest auf Masse gelegt.
'
'------------------------------------------------------------------------------
'Portbelegung: PortA Analog-Inputs und Lastschalter-Outputs:
'
'              PortA.0 = ADC0: IL-Vorgabe ILin, Input ohne Pullup
'              PortA.1 = ADC1: UBmax-Vorgabe, Input ohne Pullup
'              PortA.2 = ADC2: ULin, Input ohne Pullup
'              PortA.3 = RelOn, Output, Batterie-Relais Schalter
'              PortA.4 = ADC3: UBin, Input ohne Pullup
'              PortA.5 = ADC4: UVin, Input ohne Pullup,  Polarittsprfung
'              PortA.6 = ADC5: Negative Input IL-Sense, Input ohne Pullup
'              PortA.7 = ADC6: Positive Input IL-Sense, Input ohne Pullup
'
'              PortB LCD Display und Power-Schalter:
'
'              PortB.0 = Db6, Output
'              PortB.1 = OC1A: PWM
'              PortB.2 = Db5, Output
'              PortB.3 = Db4, Output
'              PortB.4 = RS, Output
'              PortB.5 = E, Output
'              PortB.6 = Db7, Output
'              PortB.7 = Reset
'
'-------------------------------------------------------------------------------
'Funktionsbeschreibung:  siehe Fludiagramm und Kommentare im Code
'
'-------------------------------------------------------------------------------

'Compiliert mit Bascom Version 20: 3226 Bytes, 39%
'-------------------------------------------------------------------------------
 'Const DefAusg = "UB=1,11V I=1,25ARI=????? 9999mAh"
 Const DefAusg = "                                "

 Const LoopCycl = 1680                                      ' 1670 us Prozessorloopyckle, gemessen
 'Const DisplayCycl = 333                                    ' Displayzyklus:  1/3 Sek, gewnscht
 Const DisplayCycl = 500                                    ' Displayzyklus:  500 ms, gewnscht
 'Const DisplayCycl = 1000                                   ' Displayzyklus: 1000 ms, gewnscht


 Const DC = INT(1000 * DisplayCycl /(4 * LoopCycl)) - 20    '
 'Const DC = 30                                              ' (80+ 30*4)*1,666 ms =  333 ms
 'Const DC = 55                                              ' (80+ 55*4)*1,666 ms =  500 ms
 'Const DC = 130                                             ' (80+130*4)*1,666 ms = 1000 ms

 Const QLdiv = 360000 / DisplayCycl

 Const RIcompCyl = 60                                       '60s
 Const RIC = RIcompCyl * 1000 / DisplayCycl                 '60*1000/500 = 120

 Const FcntMax = 30
 Const UBmin = 200
 'Const ILmin = 5
 Const OCR1Cmax = 250                                       'fpwm=fck/(OCR1C+1) = 8000000/250 = 30KHz

 Const UB_RBuff = 1                                         'UB-Ringpuffer
 Const IL_RBuff = 1                                         'IL-Ringpuffer

 Const RP_Div = 4                                           'Rinpuffer Divisor
 Const RP_Len = 2 ^ RP_Div                                  'nur 2^N Werte, max 32

 Const LZTest = 0                                           'Laufzeittest aus
 'Const LZTest = 1                                           'Laufzeittest ein, LZPuls an PA0, IL=300mA
 '-------------------------------------------------------------------------------
$regfile = "ATtiny861.dat"
$crystal = 8000000                                          '8,00000 MHz interner Oszillator

'$hwstack = 16                                               'default use 32 for the hardware stack
'$swstack = 8                                                'default use 10 for the SW stack
'$framesize = 16                                             'default use 40 for the frame space

'------------------------------------------------------------------------------
'Variablen

Dim QL As Long                                              'Ladung

Dim Ausgabe As String * 32                                  'Ausgabestring, Beginn bei $64
Dim UBbez As String * 3 At $64 Overlay                      'UB-Bezeichner-String
Dim UBtxt As String * 4 At $67 Overlay                      'UB-String
Dim EoUBtxt As Byte At $6B Overlay                          'End of UB-Text
Dim BlkM1Z As Byte At $6C Overlay                           'Blank Mitte 1. Zeile
Dim StatTxt As String * 6 At $6D Overlay                    'Status-Text, anstelle IL
Dim ILbez As String * 3 At $6D Overlay                      'IL-Bezeichner-String
Dim ILtxt As String * 4 At $6F Overlay                      'IL-String
Dim EoILtxt As Byte At $73 Overlay                          'End of IL-Text
Dim RIbez As String * 3 At $74 Overlay                      'RI- od. UV-Bezeichner-String
Dim RItxt As String * 4 At $77 Overlay                      'RI- od. UV-String
Dim EoRItxt As Byte At $7B Overlay                          'End of RI-Text
Dim BlkM2Z As Byte At $7C Overlay                           'Blank Mitte 2. Zeile
Dim QLtxt As String * 4 At $7D Overlay                      'QL-String
Dim EoQLtxt As String * 3 At $81 Overlay                    'End of QL-Text
Dim IMbez As String * 2 At $7D Overlay                      'ILmax-Bezeichner-String
Dim IMtxt As String * 4 At $7F Overlay                      'ILmax-String
Dim EoIMtxt As Byte At $83 Overlay                          'End of IM-Text

Dim UB As Word                                              'Batteriespannung
Dim OldUB As Word                                           'Batteriespannung bei Ladung
Dim UBmax As Word                                           'maximale Batteriespannung
Dim OldUBmax As Word                                        'zuletzt gemessene maximale Batteriespannung
Dim LstUB As Word                                           'zuletzt gemessene Batteriespannung
Dim UBM As Word                                             'Mittelwert der Batteriespannung fr Anzeige
Dim UV As Word                                              'Versorgungsspannung
Dim UL As Word                                              'Ladespannung am Reglerausgang
Dim IL As Word                                              'Ladestrom
Dim ILmax As Word                                           'maximaler Ladestrom
Dim ILmin As Word                                           'Ladestrom fr Vollmeldung
Dim OldILmax As Word                                        'zuletzt gemessener maximaler Ladestrom
Dim LstIL As Word                                           'zuletzt gemessener Ladestrom
Dim ILofs As Word                                           'Offset des IL-Verstrkers
Dim ILM As Word                                             'Mittelwert des Ladestroms fr Anzeige
Dim RI As Word                                              'Innenwiderstand
Dim TmpTxt As String * 8                                    'Hilfsstring
Dim TmpLen As Byte                                          'Lnge von TmpTxt
Dim Fcnt As Byte                                            'Voll-Zhler
Dim Temp As Long                                            'Hilfsvariable zur Anzeige von Q
Dim Tmp As Word                                             'Hilfsvariable
Dim UXtxt As String * 6                                     'UX-String
Dim IL_RP(RP_Len) As Word                                   'IL Ringpuffer
Dim UB_RP(RP_Len) As Word                                   'UB Ringpuffer
Dim RP_Ptr As Byte                                          'Ringpuffer Pointer
Dim LFlg As Byte                                            'LadeFlag
Dim N As Byte                                               'Zeichenausgabe Zhler 1...80
Dim B As Byte                                               'Eintrags Zhler 1...4
Dim C As Byte                                               'Ausgabefolge Zhler
Dim D As Byte                                               'Durchlaufzhler zur IL-Abschaltung fr RI-Bestimmung
Dim I As Byte                                               'Index fr Zeichenausgabe

'------------------------------------------------------------------------------

'Ausgabe-Ports

 DDRA = &B00001000                                          'PA3 Output, Rest Input
PORTA = &B00000000                                          'Alle Inputs ohne Pullup, alle Outputs = 0

 DDRB = &B11111111                                          'Alles Output, fr LCD und PWM
PORTB = &B00000000                                          'Alle Outputs = 0

 RelOn Alias PortA.3                                        'Batterie-Relais Schalter

#IF LZTest = 1
 LZPuls Alias PortA.0                                       'bei Laufzeittest LZPuls an PA0
#endif

 LZPuls2 Alias PortB.4                                      '2. Laufzeit-Puls auf RS fr LCD-Display

'------------------------------------------------------------------------------

 Config Lcd = 16 * 2                                        'LCD Konfiguration

 Config Lcdpin = Pin , Db4 = PortB.3 , Db5 = PortB.2 , Db6 = PortB.0 , Db7 = PortB.6 , E = PortB.5 , Rs = PortB.4

'------------------------------------------------------------------------------
 'Config Timer1 = Pwm , Compare A Pwm = Clear Down , Compare B Pwm = Clear Down , Prescale = 1

 TCCR1A = &B10000010                                        'PWM nur an OC1A, Null bei OCR1A
 TCCR1B = &B00000001                                        'Prescale = 1
 'TCCR1C = &B00000000                                       'No OC1D
 'TCCR1D = &B00000000                                       'No Fault Protection, Fast PWM: WGM10=0, WGM11=0
 'TCCR1E = &B00000000                                       'No Fault Protection
 OCR1C = OCR1Cmax                                           'fpwm=fck/(OCR1C+1) = 8000000/250 = 30KHz
 OCR1A = 0                                                  'OCR1A < OCR1C

 Config Adc = Single , Prescaler = Auto , REFERENCE = INTERNAL_2.56_NOCAP
 Start ADC

 ' (
 'MCUCR = $28                                               'Set Sleep Enable for Noise Reduction Mode
 'ADMUX = $80                                               'REF Internal, Channel 0
 'ADCSR = $86                                               'Start ADC mit Prescaler/64 ohne ADIE
 'ADCSR = $8E                                               'Start ADC mit Prescaler/64 und ADIE fr Interrupt bei EoC
' )
 'Enable Interrupts
'------------------------------------------------------------------------------
 Cls                                                        'Display lschen
 Cursor Off                                                 'LCD-Kursor ausschalten
' (
 LCD "LiIon Akku Lader"                                     'Logo ausgeben
 Home Lower
 LCD "     DJ1MHR"
 Wait 1
 CLS
' )
'------------------------------------------------------------------------------

Ausgabe = DefAusg
'BlkM1Z = 32
'BlkM2Z = 32

Main:

 'LZPuls = NOT LZPuls                                        'bei Ladung 1,68 ms

 'LZPuls = 1                                                 'Main Loop Entry

#if UB_RBuff = 1 OR IL_RBuff = 1
 Incr RP_Ptr                                                'Ringpuffer Pointer incrementieren
 IF RP_Ptr > RP_Len Then RP_Ptr = 1                         'bei 1 beginnen wenn Lnge erreicht
#endif

 'ADMUX = $83                                                'REF Internal, Channel 3
 'Gosub GetUX
 UB = GetAdc(3)                                             'messe UB
 Shift UB , Right , 1                                       '/2

#if UB_RBuff = 1                                            'wenn UB-Ringpuffer aktiv
 UBM = UBM - UB_RP(RP_Ptr)                                  'Mittelwert = Mittelwert - Wert aus Ringpuffer der ersetzt wird
 UBM = UBM + UB                                             'Neuen Wert zu Mittelwert addieren
 UB_RP(RP_Ptr) = UB                                         'Neuen Wert in Ringpuffer eintragen
#endif

 'ADMUX = $97                                               'REF Internal, Channel 23
 'Waitus 125
 'Gosub GetUX
 'ILofs = GetAdc(22)                                        'messe IL Offset an Diff.Input ADC5-ADC5
 IL = GetAdc(23)                                            'messe IL an Diff.Input (ADC6-ADC5)*20
 Shift IL , Right , 3                                       '/8, IL = 0 ... 128

#if IL_RBuff = 1                                            'wenn IL-Ringpuffer aktiv
 ILM = ILM - IL_RP(RP_Ptr)                                  'Mittelwert = Mittelwert - Wert aus Ringpuffer der ersetzt wird
 ILM = ILM + IL                                             'Neuen Wert zu Mittelwert addieren
 IL_RP(RP_Ptr) = IL                                         'Neuen Wert in Ringpuffer eintragen
#endif

 IF UB > UBmin Then                                         'Batteriespannung angelegt
   IF LFlg > 0 Then                                         'Ladung schon eingeschaltet
     IF Fcnt < FcntMax Then                                 'Voll-Zhler < Maxwert
       IF D < RIC Then                                      'Displaydurchlufe < RI-Cycle
         LstUB = UB                                         'UB bei Ladung fr RI-Bestimmung
         LstIL = IL                                         'LL bei Ladung fr RI-Bestimmung

         IF UB < UBmax Then                                 'UBmax nicht erreicht
           IF IL < ILmax Then                               'wenn IL < ILmax
             IF OCR1A < OCR1Cmax Then Incr OCR1A            'Buck-Regler, erhhe Spannung
           Else
             Goto DecrPwr                                   'bei IL>ILmax Spannung reduzieren
           End If
         Else
         DecrPwr:
           IF OCR1A => 1 Then Decr OCR1A                    'Buck-Regler, reduziere Spannung
         End If

       Else
         IF D > RIC Then                                    'Displaydurchlufe > RI-Cycle
           RI = LstUB - UB                                  'RI Berechnung
           Temp = RI * 100
           Temp = Temp / LstIL                              '/IL  RImax ca. 200 Ohm
           RI = Temp
           D = 1                                            'Reset Durchlaufzhler
         Else                                               'Displaydurchlufe = RI-Cycle
           OCR1A = 0                                        'Ladestrom abschalten
           Waitms 200                                       'warten bis Ladestrom abgeklungen
           INCR D                                           'Durchlaufzhler incrementieren
         End If
       End If
       'Temp = UBmax + 50
       'IF UB > Temp Then Goto Ready
       IF IL > ILmin Then                                   'Letze Batteriespannung bei ladung speichern
      #if UB_RBuff = 1
        OldUB = UBM
      #else
        OldUB = UB
      #endif
       End If
     End If
   Else                                                     'Ladung noch nicht eingeschaltet
     OCR1A = 10                                             'Ladestrom einschalten
     UL = 0
     While UL < UB                                          'Warte bis Ladespannung gleich Batteriespannung
       UL = GetAdc(2)                                       'messe UL
       Shift UL , Right , 1                                 '/2
     Wend                                                   'Geringster Stromsto ber Relaiskontakte
     RelOn = 1                                              'Laderelais aktivieren
     RI = 0                                                 'RI Null setzen
     QL = 0                                                 'QL Null setzen
     D = 1                                                  'D auf 1 setzen
     LFlg = 1                                               'Ladeflag setzen
     OldUBmax = UBmax
     OldILmax = ILmax
   End If
 Else                                                       'keine Batteriespannung angelegt

Ready:
   IF OldUBmax > UBmax Then
     Tmp = OldUBmax - UBmax
   Else
     Tmp = UBmax - OldUBmax
   End If
   IF Tmp > 3 Then Goto ResetOld                            'bei nderung der UBmax-Einstellung
   IF OldILmax > ILmax Then
     Tmp = OldILmax - ILmax
   Else
     Tmp = ILmax - OldILmax
   End If
   IF Tmp > 3 Then                                          'bei nderung der UBmax-Einstellung
   ResetOld:
     QL = 0                                                 'Lschen der letzten Ladedaten
     RI=0
   End If

   RelOn = 0                                                'Laderelais abschalten
   OCR1A = 0                                                'Buck Regler abschalten
   LFlg = 0                                                 'Ladeflag Null setzen
   Fcnt = 0                                                 'Voll-Zhler Null setzen
   StatTxt = "Ready!"                                       'Status "Ready!" eintragen
   EoILtxt = " "
   IF UB = 0 Then                                           'Wenn Batteriespannung Null bzw. negativ
     StatTxt = "ChkPol"                                     'Verpolungswarnung ausgeben
   EoILtxt = "!"
   End If
 End If

'LZPuls = 0                                                  '480 us ab Main Loop Entry

 IF N > 80 Then                                             'wenn 80 Zeichen ausgegeben

   'LZPuls = NOT LZPuls                                      '1680 us Zyklus

   'LZPuls = 1                                               'Start Eintrge
   Incr B                                                   'Eintrags-Zhler ingrementieren
   IF B > 4 Then                                            'alle Eintrge ausgefhrt
     B = 1                                                  'Eintrags-Zhler auf 1. Eintrag setzen
     Incr C                                                 'Zhler fr Displayzykluslnge incrementieren
     IF C => DC Then                                        'Zhler gleich o. grer Maxwert
       'LZPuls2 = 0
       C = 0                                                'Displayzykluszhler auf 0 setzen
       N = 1                                                'Ausgabezeichenzhler auf 1 setzen
       INCR D                                               'Zhler fr RI-Berechnung incrementieren
       QL = QL + IL                                         'Ladung aufsummieren
       'LZPuls2 = 1
     End If
   End If
   'LZPuls = 0                                               '2 o.4 us ab Start Eintrge

   IF B = 1 Then                                            'UB Ausgabe
     'LZPuls = 1                                             'B1 Eintrag
     IF LFlg = 1 Then                                       'wenn Ladung aktiv
    #if UB_RBuff = 1
       Tmp = UBM                                            'Ausgabe UB Mittelwert
       Shift Tmp , Right , RP_Div
    #else
       Tmp = UB                                             'Ausgabe aktueller UB Wert
    #endif
       UBbez = "UB="                                        'Bezeichner eintragen
     Else                                                   'sonst Ausgabe UBmax
       UBmax = GetAdc(1)                                    'messe UBmax Einstellung
       Shift UBmax , Right , 3                              '/2
       UBmax = UBmax + 300                                  'berechne UBmax Vorgabe 3,00...4,20V
       Tmp = UBmax                                          'Ausgabe UBmax
       UBbez = "U0="                                        'Bezeichner eintragen
     End If
     'LZPuls = 0                                             'ab B1 Eintrag, Lflg=0: 240us, Lflg=1: 17us
     IF LFlg = 0 Then
       IF QL > 0 Then
         Tmp = OldUB                                        'Eintrag des Wertes, 1. Zeile links
         Shift Tmp , Right , RP_Div
       End If
     End If
     Gosub GetUXtxt                                         'UL-Anzeige in Text umrechnen
     UBtxt = UXtxt                                          'Eintrag des Wertes, 1. Zeile links
     EoUBtxt = "V"                                          'Eintrag Dimension
     'LZPuls = 0                                             'ab B1 Eintrag, Lflg=0: 650us Lflg=1: 430us
     'LZPuls = 1                                             'Start ILmax Messung
     ILmax = GetAdc(0)                                      'messe ILmax Einstellung
     Shift ILmax , Right , 3                                '/8  0...125
    #IF LZTest = 0
     ILmax = ILmax + 10                                     'berechne ILmax Vorgabe 0,10...1,35A
    #else
     ILmax = 30                                             'bei LZTest ILmax = 300mA
    #endif
     ILmin = ILmax
     Shift ILmin , Right , 2                                'ILmin = ILmax/4
     'LZPuls = 0                                             '225 us ab Start ILmax Messung
   End If
   'LZPuls = 0                                               'ab B1 Eintrag, Lflg=0: 880us, Lflg=1: 660us
   IF B = 2 Then
     'LZPuls = 1                                             'B2 Eintrag
     IF IL => ILmin Then                                    'wenn Ladestrom => ILmin
    #if IL_RBuff = 1
       Tmp = ILM                                            'Ausgabe IL Mittelwert
       Shift Tmp , Right , RP_Div
    #else
       Tmp = IL                                             'Ausgabe aktueller IL Wert
    #endif
       Gosub GetUXtxt                                       'IL-Anzeige in Text umrechnen
       ILbez = "I="                                         'Bezeichner eintragen
       ILtxt = UXtxt                                        'Eintrag des Wertes, 1. Zeile rechts
       EoILtxt = "A"                                        'Eintrag Dimension
     Else                                                   'wenn Ladestrom > ILmin    (450 us)
       IF Fcnt => FcntMax Then                              'wenn Vollzhler => Maxwert
         RelOn = 0                                          'Laderelais abschaltem
         OCR1A = 0                                          'Bukregler abschalten
         StatTxt = "Full!!"                                 'Satausanzeige "Full!!"
         EoILtxt = " "
       Else                                                 '20 us
         Incr Fcnt                                          'Vollzhler inkrementieren
       End If                                               '3 us
     End If
     'LZPuls = 0                                             'ab B2 Eintrag, Lflg=1: 460us
     Waitus 200                                             '+200=660us
   End If

   IF B = 3 Then
     'LZPuls = 1                                             'B3 Eintrag
     UV = GetAdc(4)                                         'messe Versorgungsspannung
     Shift UV , Left , 1                                    '*2
     IF RI > 0 Then                                         'wenn RI Wert vorliegt
       Tmp = RI                                             'RI-Ausgabe
       RIbez = "RI="                                        'Bezeichner eintragen
       Gosub GetUXtxt                                       'RI-Anzeige in Text umrechnen
       RItxt = UXtxt                                        'Eintrag des Wertes, 2. Zeile links
       EoRItxt = 244                                        'Ohm Symbol: $F4 = 244
     Else
       Tmp = UV                                             'UV-Ausgabe
       RIbez = "UV="                                        'Bezeichner eintragen
       Gosub GetUXtxt                                       'UV-Anzeige in Text umrechnen
       RItxt = UXtxt                                        'Eintrag des Wertes, 2. Zeile links
       EoRItxt = "V"                                        'Eintrag Dimension
     End If
     'LZPuls = 0                                             'ab B3 Eintrag, RI Zweig bei Ladung 650us
     Waitus 10                                              '+10=660us
   End If

   IF B = 4 Then
     'LZPuls = 1                                             'B4 Eintrag
     IF QL > 0 Then                                         'wenn Ladung vorliegt, Ausgabe Ladung in mAh
       Temp = QL / QLdiv                                    '/2*3600 bei 2 Additionen pro Sekunde
       TmpTxt = "   " + STR(Temp)                           'in Text umwandeln
       QLtxt = Right(TmpTxt , 4)                            'Eintrag des Wertes, 2. Zeile rechts
       EoQLtxt = "mAh"
     Else                                                   'sonst ILmax Vorgabe
       Tmp = ILmax                                          'ILmax-Ausgabe
       IMbez = "I="                                         'Bezeichner eintragen
       Gosub GetUXtxt                                       'ILmax-Anzeige in Text umrechnen
       IMtxt = UXtxt                                        'Eintrag des Wertes, 2. Zeile rechts
       EoIMtxt = "A"                                        'Eintrag Dimension
     End If                                                 '450 us
     'LZPuls = 0                                             'ab B4 Eintrag, QL Zweig bei Ladung 520us
     Waitus 140                                             '+140=660us

   End If

   Waitus 560                                               'Summe wie Ausgabe 1,22 ms

 Else

   'LZPuls = 1                                               'Start Ausgabe
   IF N > 40 Then                                           'fr Zeichen grer 40
     I = N - 24                                             'Index = N-24
   Else                                                     'fr Zeichen bis 40
     I = N                                                  'Index = N
   End If
   IF I > 32 Then I = 10                                    'Blank im Ausgabestring, Zeichen nicht sichtbar
   LCD Mid(Ausgabe , I , 1)                                 'Ausgabe Zeichen I
   Incr N                                                   'Increment N
   'LZPuls = 0                                               '1220 us ab Start Ausgabe

 End If

 Goto Main

'-------------------------------------------------------------------------------
' (
GetUXtxt:
 TmpTxt = Str(Tmp)                                          'Wert in String umwandeln
 TmpLen = Len(TmpTxt)                                       'Lnge des Strings in TmpLen
 IF TmpLen = 4 Then                                         'bei 4 Zeichen: xx.x
   UXtxt = Left(TmpTxt , 2) + ","                           'die 2 linken Zeichen und Komma
   UXtxt = UXtxt + Mid(TmpTxt , 3 , 1)                      'dann das dritte Zeichen ausgeben
 Else                                                       'bei < 4 Zeichen: x.xx
   IF TmpLen = 3 Then UXtxt = Left(TmpTxt , 1)              'bei 3 Zeichen: erstes Zeichen
   IF TmpLen < 3 Then                                       'bei < 3 Zeichen:
     UXtxt = "0"                                            ' Zeichen 0
     TmpTxt = "0" + TmpTxt                                  'weitere Null vorstellen, falls nur 1 Zeichen
   End If
   UXtxt = UXtxt + "," + Right(TmpTxt , 2)                  'dann rechte zwei Zeichen ausgeben
 End If
 Return
' )
'-------------------------------------------------------------------------------
'(
GetUX:                                                      'alternative Assemblerroutine fr ADC Wandlung
          'sbi    6, 6                                      'ADCSR.6 = 1, Start Conversion #1
ContC1:
          'sbic 6 , 6                                       'Wait for End of Conversion
          'rjmp    ContC1
          'sleep
          sbi    6, 6                                       'ADCSR.6 = 1, Start Conversion #2
ContC2:
          sbic 6 , 6                                        'Wait for End of Conversion
          rjmp   ContC2
          in     r24, 4                                     'ADCL nach r24
          in     r25, 5                                     'ADCH nach r25

          Loadadr UX , X                                    'Lade Adresse der Zielvariablen
          'ldi    XL, $60                                   'Lade Adresse der Zielvariablen SRAM Adr $60
          st     X+, r24                                    'R24 nach $60
          st     X, r25                                     'R25 nach $61

 Return
')
'-------------------------------------------------------------------------------