'------------------------------------------------------------------------------
'CW-TrainerV9.51.bas  mit ATMega168 und 1 ms Timer-Interrupt
'
'31.01.2016
'Erster Tastaturinterrupt nach dem Einschalten wird gelscht, sonst keine UB-Anzeige. Zeile 417
'Zur Sicherheit wird auch der Keyer-Interrupt gelscht. Zeile 415
'Interrupts werden in der UB-Messchleife abgeschaltet, ein Keyboard- oder Keyer-Interrupt,
'der whrend der UB-Messung auftritt wird sonst wegen UBCykl = 0 nicht erkannt.
'
'28.04.2014
'Gebemglichkeit mit Paddle eingebaut.
'Erfordert zweiten Anschlu des Paddles an PD1. Hardwareaufbau 5
'Alte Hardware Varianten entfernt.
'Fehler in ScanCode Tabelle bei KP_Div beseitigt
'Batteriespannungsmessung mit Aktivierung der Kalibrierfunktion ber NUM Taste
'Kalibrierung mit Links- bzw. Rechts-Pfeil
'Neue Zeichen: @, !, $, & und  implementiert
'Dauerausgabe ohne Random-Funktion kann mit ALT ein- und mit ALT GR abgeschaltet werden.
'Testausgabe ber RS232 nicht nutzbar, weil die Ports dafr nicht mehr zur Verfgung stehen.
'
'27.01.2013
'Batteriespannungsanzeige nach dem Einschalten eingebaut
'
'14.04.2012
'Wiedergabe-Betrieb ohne Tastatur, Bedienung mit Taste.
'Hardwareaufbau 0 ist unverndert
'Zustzlich Hardwareaufbau 4 wie Hardwareaufbau 3 mit Bedien-Taste anstelle RXD an PortD.0
'zur Wiedergabe ohne angeschlossene Tastatur
'
'02.10.2011
'Falche Codierung Semicolon als Komma repariert (Zeilen 1359 und 1368)
'
'Telegrafie mit AT-Tastatur
'
'CW-Zeichen:
'Zeichen a..z incl. Umlaute, Ziffern und Sonderzeichen wie Tastaturbeschriftung
'auch die mit Shift zu erreichenden Zeichen, soweit sie im Morsecode definiert sind
'Enter im Zahlenblock: = (Trennung)
'Punkt im Zahlenblock: [hh] (Irrung)
'Trennung ganze Zahl / Bruch: 
'Shift a:[ar], Shift c:[ch], Shift e:[eb], Shift k:[ka], Shift v:[ve], Shift s:[sk]
'
'Tastenbefehle:
'Cw-Tempo: 0-5 im Zahlenblock
'Abstand:  6-9 im Zahlenblock
'Auf-Pfeil: CW-Tonfrequenz um 100 Hz erhhen
'Ab-Pfeil: CW-Tonfrequenz um 100 Hz reduzieren
'Links-Pfeil: Zeichenausgabe auf LCD abschalten
'Rechts-Pfeil: Zeichenausgabe auf LCD einschalten
'Einf: Speichern des Tastaturpuffer Inhaltes im EEPROM
'Entf: Lesen des Tastaturpuffer Inhaltes aus dem EEPROM
'Pos1: Wiederholen des Tastaturpuffer Inhaltes
'Ende: Abbruch der Ausgabe aus den Tastaturpuffer
'Rck-Taste: Lscht letztes Zeichen im Tastaturpuffer
'ESC: Rcksetzen bzw. Lschen des Tastaturpuffers
'Shift: bliche Shift Funktion zur Doppelbelegung der Tasten
'F1..F12: Ausgabe der Lektionenteile F1...F12
'SF1..SF12:  Ausgabe der Lektionenteile SF1...SF12
'Bild Auf: Einschalten des Editier Modus fr F1 bis F12 und SF1 bis SF12
'Bild Ab: Beenden des Editier Modus und Speichern der nderungen im EEPROM
'TAB: Einschalten der Lektionenausgabe F1 bis Fx bzw. SF1 bis SFx
'Shift Lock: Abschalten der Lektionenausgabe ab F1 bzw SF1, Teil-Lektionen
'Rechts Strg: Einschalten der Random Endlos-Ausgabe der Lektionenspeicher
'Links Strg: Abschalten der Random Ausgabe der Lektionenspeicher
'ALT: Einschalten der Endlos-Ausgabe auch ohne Random Funktion
'ALT GR: Abschalten der Endlos-Ausgabe ohne Random Funktion
'Zahlenblock +: Einschalten des Kontroll Mode
'Zahlenblock -: Abschalten des Kontroll Mode
'Zahlenblock /: nicht nutzbar
'Zahlenblock *: unbenutzt
'Space: Abbruch des Kontrollmode
'Druck: Ausgabe der internen Programm Parameter auf dem LCD Display
'NUM: Ein-/Ausschalten des Kalibrier-Modes fr die Batteriespannungsanzeige
'Taste ^: CW-Eingabe mit Taste
'Taste : CW-Eingabe mit Paddle
'Abbruch einer laufenden Sequenz mit einer beliebigen Zeichen-Taste
'
'Anleitung zur Lektionenausgabe:
'Drcken einer Funktionstaste
'Anleitung zum Editiermode:
'1. Editiermode mit Bild Auf Einschalten.
'2. Drcken der Funktionstaste F1 ... F12 oder SF1 ... SF12
'   deren Inhalt gendert werde soll
'3. Eingabe der Zeichen fr diese Lektion ber die Tastatur
'4. Drcken von Bild Ab, zum Beenden und Abspeichern der nderungen
'
'------------------------------------------------------------------------------

'xxxx Bytes, xx%

Const RS232Debg = 0                                         'Testausgabe agbeschaltet
'Const RS232Debg = 1                                         'Testausgabe der Tastatur Codes und R6

Const DebugDsp = 0                                          'Debuganzeige am LCD aus
'Const DebugDsp = 1                                          'Debuganzeige am LCD nach getatkbd ein
'Const DebugDsp = 2                                          'Debuganzeige am LCD nach Umcodierung ein
'Const DebugDsp = 3                                          'Debuganzeige am LCD nach Ausfhrung ein

Const HwAufbau = 5                                          'Leiterplatte mit Taste und Paddleanschlu an PD1

Const QFreq = 16000000                                      '16,00000 MHz-Quarz

#if QFreq > 8192000
 'Const Val_TCCR2 = &B00011100                               'CS2:0=4, WGM21=1, COM20=1
 Const Val_TCCR2A = &B01000010                              'WGM21=1, COM2A0=1
 Const Val_TCCR2B = &B00000100                              'CS2:0=4, Rest 0
 Const CwCLK = QFreq /(128 * 100)
#else
 'Const Val_TCCR2 = &B00011011                               'CS2:0=3, WGM21=1, COM20=1
 Const Val_TCCR2A = &B01000010                              'WGM21=1, COM2A0=1
 Const Val_TCCR2B = &B00011011                              'CS2:0=3
 Const CwCLK = QFreq /(64 * 100)
#endif

'$regfile = "m8def.dat"                                      'ATMega8
$regfile = "m168def.dat"                                    'ATMega168
$crystal = QFreq                                            'Quarzfrequenz
'$Baud = 19200

$hwstack = 70                                               'default use 32 for the hardware stack 60
$swstack = 60                                               'default use 10 for the SW stack       30
$framesize = 90                                             'default use 40 for the frame space

'------------------------------------------------------------------------------

CONST U_ARROW = 8                                           'CW-Tonfrequenz um 100 Hz erhhen
CONST D_ARROW = 9                                           'CW-Tonfrequenz um 100 Hz reduzieren
CONST L_ARROW = 10                                          'Display aus, bei Com decr UBKorr
CONST R_ARROW = 11                                          'Display ein, bei Com incr UBKorr
CONST INSERT = 14                                           'Speichern des Tastaturpuffer Inhaltes im EEPROM
CONST DELETE = 15                                           'Lesen des Tastaturpuffer Inhaltes aus dem EEPROM
CONST POS1 = 16                                             'Wiederholen des Tastaturpuffer Inhaltes
CONST ENDE = 17                                             'Abbruch der Ausgabe aus den Tastaturpuffer
CONST PG_UP = 18                                            'Einschalten des Editier Modus fr F1 bis F12 und SF1 bis SF12
CONST PG_DN = 19                                            'Beenden des Editier Modus und Speichern der nderungen im EEPROM
'CONST KP_Div = frei, nicht nutzbar
CONST KP_Mul = 24                                           'nicht benutzt
CONST KP_Plus = 25                                          'Einschalten des Kontroll Mode
CONST KP_Minus = 26                                         'Abschalten des Kontroll Mode
CONST KP_EN = 27                                            'Irrung
CONST NUM = 28                                              'Enter/Leave Com-Mode fr Batteriespannungskalbriereung
CONST L_CTRL = 30                                           'Abschalten der Random Ausgabe der Lektionenspeicher
CONST R_CTRL = 31                                           'Einschalten der Random Ausgabe der Lektionenspeicher
CONST ESC = 32                                              'Rcksetzen bzw. Lschen des Tastaturpuffers
CONST BKSP = 33                                             'Letzes Zeichen im Tastaturpuffer lschen
CONST ENTER = 253                                           'Trennung "="
CONST L_ALT = 37                                            'Einschalten der Endlos-Ausgabe
CONST R_ALT = 38                                            'Abschalten der Endlos-Ausgabe
CONST TAB = 39                                              'Einschalten der Lektionenausgabe F1 bis Fx bzw. SF1 bis SFx
CONST KP_0 = 40                                             'CW-Tempo 30
CONST KP_1 = 41                                             'CW-Tempo 45
CONST KP_2 = 42                                             'CW-Tempo 60
CONST KP_3 = 43                                             'CW-Tempo 80
CONST KP_4 = 44                                             'CW-Tempo 100
CONST KP_5 = 45                                             'CW-Tempo 120
CONST KP_6 = 46                                             'Zeichenabstand 8
CONST KP_7 = 47                                             'Zeichenabstand 28
CONST KP_8 = 48                                             'Zeichenabstand 52
CONST KP_9 = 49                                             'Zeichenabstand 100
CONST CAPS = 56                                             'Abschalten der Lektionenausgabe ab F1 bzw SF1, Teil-Lektionen
CONST PRNT = 57                                             'Ausgabe der internen Programm Parameter auf dem LCD Display
CONST F1 = 87                                               'Ausgabe Lektion 1
CONST F2 = 88                                               'Ausgabe Lektion 2
CONST F3 = 89                                               'Ausgabe Lektion 3
CONST F4 = 90                                               'Ausgabe Lektion 4
CONST F5 = 91                                               'Ausgabe Lektion 5
CONST F6 = 92                                               'Ausgabe Lektion 6
CONST F7 = 93                                               'Ausgabe Lektion 7
CONST F8 = 94                                               'Ausgabe Lektion 8
CONST F9 = 95                                               'Ausgabe Lektion 9
CONST F10 = 96                                              'Ausgabe Lektion 10
CONST F11 = 97                                              'Ausgabe Lektion 11
CONST F12 = 98                                              'Ausgabe Lektion 12
CONST SF1 = 103                                             'Ausgabe Lektion S1
CONST SF2 = 104                                             'Ausgabe Lektion S2
CONST SF3 = 105                                             'Ausgabe Lektion S3
CONST SF4 = 106                                             'Ausgabe Lektion S4
CONST SF5 = 107                                             'Ausgabe Lektion S5
CONST SF6 = 108                                             'Ausgabe Lektion S6
CONST SF7 = 109                                             'Ausgabe Lektion S7
CONST SF8 = 110                                             'Ausgabe Lektion S8
CONST SF9 = 111                                             'Ausgabe Lektion S9
CONST SF10 = 112                                            'Ausgabe Lektion S10
CONST SF11 = 113                                            'Ausgabe Lektion S11
CONST SF12 = 114                                            'Ausgabe Lektion S12
CONST Karate = 118                                          'CW-Eingabe mit Taste
CONST Grad = 119                                            'CW-Eingabe mit Paddle
CONST SC_E0 = 224
CONST Textende = 240
CONST _Space = 255                                          'Abbruch des Kontroll-Mode

CONST F0 = F1 - 1

Const Cwtempo0 = 30
Const Cwtempo1 = 45
Const Cwtempo2 = 60
Const Cwtempo3 = 80
Const Cwtempo4 = 100
Const Cwtempo5 = 120

Const Abstand0 = 4 - 1                                      'Punkteinheiten - 1 (1 Einheit nach jedem Zeichenelement)
Const Abstand1 = 8 - 1
Const Abstand2 = 14 - 1
Const Abstand3 = 26 - 1

Const TastRP = 250                                          'Lnge des Tastatur Ringpuffers, max 254
'------------------------------------------------------------------------------
'Variablen
Dim IR6 As Byte At &H100                                    'IR6 Speicherstelle fr R6
Dim Key As Byte                                             'aktuelles Zeichen von der Tastatur
Dim PKey As Byte                                            'Letztes Zeichen von der Tastatur
Dim XKey As Byte                                            'Im Kontroll Mode ausgegebenes Zeichen
Dim J As Word                                               'Zhlvariable im CW-Decoder
Dim Zeichen As Byte                                         'Cw-Zeichen fr Anzeige, wird nicht verndert
Dim Zeichenx As Byte                                        'Cw-Zeichen fr CW-Ausgabe, wird verndert
Dim Vcw As Byte                                             'CW Geschwindigkeit
Dim VcwAlt As Byte                                          'alte CW Geschwindigkeit
Dim RVcw As Word                                            'mit CW-Decoder festgestellte CW Geschwindigkeit
Dim Tcw As Word                                             'kleinste CW Zeiteinheit = Dauer fr Punkt
Dim Abstand As Word                                         'CW Zeiteinheiten fr Abstand zwischen Zeichen
Dim Abstand_d As Byte                                       'Abstandsfaktor
Dim AbstandAlt As Word                                      'alter Abstandsfaktor
Dim Punkt As Word                                           'CW Zeiteinheiten fr Punkt
Dim Strich As Word                                          'CW Zeiteinheiten fr Strich
Dim Pause As Word                                           'Tast-Pause zwischen Symbolen (CW-Dec)
Dim Einh15 As Word                                          '1,5 Cw Zeiteinheiten (CW-Dec)

Dim A as Word                                               'Interruptzhler fr Punkt, Strich, Pause und Abstand
Dim C as Byte                                               'C=1: Endlos Ausgabe, C=0: Einmalige Ausgabe
Dim S as Byte                                               'S=1: Symbolabstand aktiviert, S=0: Symbolabstand ausgefhrt
Dim ET as Byte                                              'Erste Tabelle
Dim T as Byte                                               'Tabellen Nummer 1...24
Dim T1 as Byte                                              'Nummer der 1. auszugebenden Tabelle
Dim H As Byte                                               'Hilfsvariable
Dim I as Byte                                               'Letztes Zeichen im Tasturpuffer
Dim K as Byte                                               'Ausgabe Zeiger im Tastaturpuffer
Dim L as Byte                                               'Lnge des CW-Zeichens
Dim N as Byte                                               '5er Gruppenzhler
Dim Z as Word                                               'Zeiger auf auszugebendes Zeichen
Dim EZ as Word                                              '1. Zeichen der aktiven Tabelle
Dim AZ as Byte                                              'Anzahl Zeichen der aktiven Tabelle
Dim LZ as Word                                              'Letztes Zeichen der aktiven Tabelle
Dim CwTabIdx(25) As Word                                    'Indextabelle fr Lektionen
Dim R as Byte                                               'R=1 Random Ausgabe Flag
Dim KM as Word                                              'Kontroll Mode Flag
Dim Stp as Byte                                             'Stop Flag fr Kontroll Mode
Dim EDIT as Byte                                            'Edit Mode Flag
Dim Dsp as Byte                                             'Display Flag fr LCD Ausgabe
Dim AChr as Byte                                            'ASCII Wert des Zeichens fr LCD Ausgabe
Dim DZ as Byte                                              'Doppelzeichen
Dim Epa as Byte                                             'EPROM Adresse
Dim WRFlag as Byte                                          'EEPROM Write Flag
Dim ChrRP(TastRP) As Byte                                   'Tastatur Ringpuffer
Dim ChrMem(8) As Word                                       'Character Memory fr CW-Decoder
Dim CwTonFreq As Byte                                       'Cw Tonfrequenz/100, 3 ... 20
Dim CwTonAlt As Byte                                        'alter Wert von Cw Tonfrequenz
Dim CwTon As Word                                           'aktueller OCR2 Wert fr CW-Ton
Dim LCDSTR As String * 21                                   '24 Zeichen Ausgabestring
Dim PrFlag As Byte                                          'Flag fr Bearbeitung nach Interrupt (CW-Dec)
Dim CwDec As Byte                                           'Flag CW-Decoder
Dim ChrOut As Byte                                          'Zeichenausgabe Flag
Dim Taste As Byte                                           'CW-Tastenzustand zur Flankenerkennung
Dim WPause As Word                                          'Wortpause (CW-Dec)
'Dim LPause As Word                                          'Lange Pause = Wortpause (CW-Dec)
'Dim KPause As Word                                          'Kurze Pause = Zeichenpause (CW-Dec)
Dim PEinh As Word                                           'Punkteinheit (CW-Dec)
Dim PEinh2 As Word                                          'Doppelte Punkteinheit  (CW-Dec)
Dim SEinh As Word                                           'Stricheinheit (CW-Dec)

Dim ___rseed as Word                                        'Random Number seed

Dim Logo As Byte                                            'Merker fr Logoausgabe
Dim UBCykl As Byte                                          'Zyklenzhler fr UBatt Messung
Dim PlayMenue As Byte                                       'Zustand des Play-Tasten Menues
Dim LastMenue As Byte                                       'Letzter Zustand des Play-Tasten Menues
Dim TastTime As Word                                        'Tastzeit der Play-Taste
Dim PlayFlag As Byte                                        '1 bei Verlassen des Play-Menues
Dim VKey As Byte                                            'Key fr aktuelle CW-Geschwindigkeit
Dim AKey As Byte                                            'Key fr aktuellen Abstand
Dim UBatt as Word                                           'Batteriespannung
Dim UBSTR As String * 4                                     '4 Zeichen UB String
Dim UBSTR_L As String * 2                                   '2 Zeichen Vorkomma-UB String
Dim UBSTR_R As String * 2                                   '2 Zeichen Nachkomma-UB String

Dim Paddle as Byte                                          '0=CW-Eingabe mit Taste, 1= CW-Eingabe mit Paddle
Dim PaddleAlt as Byte                                       'alter Wert von Paddle
Dim UBcal As Byte                                           '255=UB-Kalibriermode aktiv
Dim UBKorr As Byte                                          'UB-Korrekturwert
Dim UBKorrAlt As Byte                                       'alter UB-Korrekturwert
Dim Tmp As Byte                                             'Hilfsvariable Byte
Dim Temp As Word                                            'Hilfsvariable Word
Dim Temp2 As Word                                           'Hilfsvariable Word

'Variablen fr RS232 Testroutine
'(
Dim TestRP(16) As Byte                                      'Test Ringpuffer fr Code
Dim TestR6(16) As Byte                                      'Test Ringpuffer fr R6
Dim TI As Byte                                              'Testausgabe Index
Dim W As Byte                                               'Wait fr Testausgabe                           '
')
'------------------------------------------------------------------------------
#if HwAufbau = 5                                            'wie HW Aufbau 4 mit Paddleanschlu an PD1

'Portbelegung:
'PB0: LCD E,  Pin 6
'PB1: LCD DB4
'PB2: LCD DB5
'PB3: CW-Ton
'PB4: LCD DB6
'PB5: LCD DB7
'PB6: nicht nutzbar
'PB7: nicht nutzbar

'PC0: LED KM
'PC1: LED Com
'PC2: LED CW
'PC3: Batterieberwachung ab Version 9.3
'PC4: frei
'PC5: TestOut
'PC6: nicht vothanden
'PC7: nicht vothanden

'PD0: Bedien-Taste
'PD1: Paddle Anschluss DA
'PD2: INT0, CW-Taste bzw.Paddle Anschluss DIT
'PD3: INT1, KBDCLK
'PD4: KBDDAT
'PD5: Ausgang Tastung invers
'PD6: Ausgang TX-Tastung
'PD7: LCD RS

'Ausgabe-Ports

 DDRB = &B00111111                                          'PortB alles Output fr LCD Display und
PORTB = &B00000000                                          'Portb.3, OC2, Timer2 Ton Ausgang

' DDRC = &B00100101                                          'PortC alles Input auer PC0, PC2 und PC5
'PORTC = &B11010010                                          'Pullup an allen Inputs

 DDRC = &B00100111                                          'PortC alles Input auer PC0 bis PC2 und PC5
PORTC = &B11010000                                          'Pullup an allen Inputs, auer PC3

 DDRD = &B11100000                                          'Outputs PD5, PD6, PD7, Rest Input
PORTD = &B00111111                                          'Pullup an allen Inputs

'Portnamen Definitionen
 Port_PlayTaste Alias PinD.0                                'PLay-Taste an PD0
 Port_Paddle_DA Alias PinD.1                                'Input Paddle DA
 Port_Paddle_DIT Alias PinD.2                               'Input Paddle DIT
 Port_CW_Taste Alias PinD.2                                 'Input CW_Taste
 Port_KbdClk Alias Pind.4                                   'Keyboard Clock
 Port_TxTastungI Alias PortD.5                              'TX-Tastung invers
 Port_TxTastung Alias PortD.6                               'TX-Tastung
 Read_TxTastung Alias PinD.6                                'Input TX-Tastung fr CW-Decoder
 Port_Kontrolle Alias PortC.0                               'LED KM
 Port_com Alias PortC.1                                     'LED Com
 Port_CW_LED Alias PortC.2                                  'LED CW
 Port_Test Alias PortC.5                                    'Test Ausgang

'------------------------------------------------------------------------------

'PS/2-Stecker: 1=Data, 2=NC, 3=GND, 4=+5V, 5=Clock, 6=NC
'Keyboard=Clock auf PD3 (INT1), Data PD4

Config Keyboard = Pind.3 , Data = PinD.4 , Keydata = Keydata

'------------------------------------------------------------------------------

 Const LCD_Dsp = 1                                          'LCD Display vorhanden

 Config Lcd = 16 * 2                                        'LCD Konfiguration

 Config Lcdpin = Pin , Db4 = Portb.1 , Db5 = Portb.2 , Db6 = Portb.4 , Db7 = Portb.5 , E = PortB.0 , Rs = Portd.7

#endif
'------------------------------------------------------------------------------
 Const IntTime = 1                                          '1 ... 10 ms
 Const UBCycleMax = 250 / IntTime                           'Zykluszeit fr Batteriespannungsmessung 250 ms
 Const TastTimeMax = 2500 / IntTime                         'Tastzeitbegrenzung bei 2,5 sec
 Const TastTimeStart = 500 / IntTime                        'Tastzeit fr Start 500 ms
 Const TcwFaktor = 5000 / IntTime                           'CW-Geschwindigkeits Zeitfaktor 5 sec

 Config Timer1 = Timer , Prescale = 8                       'Qf/(8*(65536-T1Preset)=>Int-Frq
 Const T1Preset = 65536 -(QFreq * IntTime) /(1000 * 8)

 Config Adc = Single , Prescaler = Auto                     'externe Referenz 5V

 On Timer1 T1int                                            'Interrupt Routine alle  IntTime ms

  TCCR2B = &B00000001                                       'Start Timer2 for Random Number Seed

 Config Int1 = Falling                                      'Interrupt bei Keyboard-Signal
 On Int1 ActKBD                                             'NOSAVE funktioniert nicht!

 Config Int0 = Falling                                      'Interrupt bei CW-Taste (PD3)
 On Int0 ActCwDec                                           'NOSAVE funktioniert nicht!

 '------------------------------------------------------------------------------

 Set Port_com                                               'Com-LED ein

#if LCD_Dsp = 1
 Cls                                                        'Display lschen
 Cursor Off                                                 'LCD-Kursor ausschalten
 LCD "  CW-Trainer V9.51"                                   'Logo-Ausgabe
 Home Lower
 LCD " DJ3YB  und  DJ1MHR"
 Waitms 500                                                 '500 ms
#endif

#if RS232Debg = 1                                           'Testhilfe ber RS232
 TI = 1                                                     'Test Index
#endif

 EIFR.INT0 = 1
 Enable Int0                                                'Keyer-Interrupt
 EIFR.INT1 = 1                                              'ersten Tastatur-Interrupt nach Einschalten lschen
 Enable Int1                                                'Tastatur-Interrupt

 Enable Timer1                                              'Timer1-Interrupt ein
 Enable Timer2
 Enable Interrupts                                          'Interrupts global einschalten

'------------------------------------------------------------------------------

 Readeeprom UBKorr , 251                                    'Korrekturwert fr Battereispannungsmessung aus EEPROM holen
 UBKorrAlt = UBKorr                                         'als alten Wert festhalten
 Readeeprom Paddle , 252                                    'Einstellung Taste/Paddle aus EEPROM holen
 PaddleAlt = Paddle                                         'als alten Wert festhalten
 Readeeprom CwTonFreq , 253                                 'CW-Ton aus EEPROM holen
 CwTonAlt = CwTonFreq                                       'als alten Wert festhalten
 Readeeprom Vcw , 254                                       'CW-Geschwindigkeitseinstellung aus EEPROM holen
 VcwAlt = Vcw                                               'als alten Wert festhalten
 Readeeprom Abstand_d , 255                                 'Abstandseinstellung aus EEPROM holen
 AbstandAlt = Abstand_d                                     'als alten Wert festhalten

 Gosub CWtempoX                                             'CW-Tempo einstellen
 GOSUB SetCwTonX                                            'CW-Ton einstellen

 GOSUB GetIndex                                             'Tabellen Indizes berechnen

 Restore CWTab                                              'aus CWTab
 VKey = 255
 Do
 Incr VKey                                                  'VKey den zugehrigen Wert zuweisen
 Read H
 Loop Until H = Vcw

 Restore ATab                                               'aus ATab
 AKey = 255
 Do
 Incr AKey                                                  'AKey den zugehrigen Wert zuweisen
 Read H
 Loop Until H = Abstand_d
 AKey = AKey + 6                                            '+6 weil Abstand KP6 bis KP9

 Dsp = 1                                                    'Display aktivieren

 While UBCykl < 255                                         'continuierliche UB-Messung
   IF UBCykl = UBCycleMax Then                              'alle 250 ms
     Disable Interrupts                                     'Interrupts abschalten
     Gosub ReadUB                                           'Batteriespannung messen und ausgeben
     UBCykl = 0                                             'wieder initialisieren
     Enable Interrupts                                      'Interrupts einschalten
   End If
   IF Port_PlayTaste = 0 Then UBCykl = 255
 Wend                                                       'bis Interrupt durch Taste oder Keyboard

 Logo = 1                                                   'Logo unterdrcken

 PlayMenue = 255                                            'Tastmenue in Einschaltzustand bringen

 Reset Port_com                                             'Com-LED aus

 Do                                                         'Hauptschleife

   Gosub ResBuff                                            'Bufferzeiger initialisieren
   Gosub CWtempoX                                           'CW-Tempo einstellen

   While CwDec = 0                                          'CW-Decoder deaktivieren

     While Port_PlayTaste = 0                               'wenn Play-Taste gedrckt ist
     Wend                                                   'warten bis Taste losgelassen wird

     Key = Getatkbd()                                       'auf Keyboard-Input warten

    #if DebugDsp = 1                                        'Debug-Ausgabe auf Display nach Keyboardausgabe
     IF Key > 0 Then                                        'nur definierte Keys anzeigen
       Home Lower
       LCD "K" ; Key ; " I" ; IR6 ; " P" ; Paddle ; " V" ; Vcw ; " A" ; Abstand ; "       "
     End If
    #endif

    #if RS232Debg = 1                                       'Testhilfe
     TestRP(TI) = Key
     TestR6(TI) = IR6
     IF TI < 17 Then Incr TI
     W = 0                                                  'Reset Wartezhler
    #endif

     IF PlayFlag = 1 Then                                   'bei Rckkehr aus dem Play-Menue
       'CLS
       Home Upper
       LCD SPC(20)                                          'erste Zeile lschen
       'LCDSTR = ""                                          'Lscht Anzeigestring
       Dsp = 1                                              'schaltet wieder auf normale Display Ausgabe
       PlayFlag = 0                                         'Play-Menu Flag lschen
     End If

     IF Port_PlayTaste = 0 Then                             'wenn Play-Taste gedrckt
       Gosub TastInp                                        'gehe zum Play-Tasten-Menue
       While Port_PlayTaste = 0                             'Loop wenn Taste noch gedrckt
         IF Key = &H56 Then                                 'aber bei Stopp-Zeichen "."
           Goto HX56                                        'Zeichen ausfhren
         End If
       Wend
       Home Upper
       LCD SPC(20)                                          'erste Zeile lschen
       'LCDSTR = ""                                          'Lscht Anzeigestring
     End If
   HX56:

     Ldi R27 , $01                                          'Load R27 with MSB of IR6
     Ldi R26 , $00                                          'Load R26 with LSB of IR6
     ST X,R6                                                'read R6 into memory location $0100

     IF IR6 = &H90 Then                                     'Rcksetzen des E0 Flags
       IR6 = 0
       Ldi R27 , $01                                        'Load R27 with MSB of IR6
       Ldi R26 , $00                                        'Load R26 with LSB of IR6
       Ld R6,X                                              'store IR6 into R6
     End If

     IF Key = SC_E0 Then                                    'Bei Tasten beginnend mit E0 im Scan Code
                                                            'wird fr den Folge Code Shift aktiviert
       IR6 = &H90                                           'Shift Mode &H10 + Flag &H80 = &H90
       Ldi R27 , $01                                        'Load R27 with MSB of IR6
       Ldi R26 , $00                                        'Load R26 with LSB of IR6
       Ld R6,X                                              'setze R6 in Shift Mode + Flag
       Key = 0                                              'keine andere Aktion

     End If

     IF PlayFlag = 0 Then                                   'wenn nicht im Play-Mode
       IF Key = F5 Then                                     'F5 oder Shift F7, Code aus Pos 03 ohne Shift
         Ldi R27 , $01                                      'Load R27 with MSB of IR6
         Ldi R26 , $00                                      'Load R26 with LSB of IR6
         ST X,R6                                            'read R6 into memory location $0100
         IF IR6 > 0 Then Key = SF7                          'wenn Shift ersetze Code mit SF7
       End If
       IF Key = F7 Then                                     'F7 oder Shift F5, Code aus Pos 83 mit Shift
         Ldi R27 , $01                                      'Load R27 with MSB of IR6
         Ldi R26 , $00                                      'Load R26 with LSB of IR6
         ST X,R6                                            'read R6 into memory location $0100
         IF IR6 > 0 Then Key = SF5                          'wenn Shift ersetze Code mit SF5
       End If
     End If

    #if DebugDsp = 2                                        'Debug-Ausgabe auf Display nach Umcodierung
     IF Key > 0 Then
       Home Lower
       LCD "K" ; Key ; " I" ; IR6 ; " P" ; Paddle ; " V" ; Vcw ; " A" ; Abstand ; "       "
     End If
    #endif

     GOSUB UBoff                                            'UB-Messung abschalten

     Select Case Key                                        'Key Aktionen
       Case 0                                               'nichts

       Case KP_0 to KP_9                                    'Ziffernblock Tasten 0...9, fortlaufend codiert
         GOSUB CWtempo                                      'speichert genderten Wert im EEPROM
         GOSUB LCDout3                                      'Statusausgabe in der 2. Zeile

       Case F1 To F12                                       'F1 bis F12
         T = Key - F0                                       'F0=F1-1 => -F1+1
         IF ET = 0 Then                                     'wenn Ausgabe ab erster Tabelle ausgeschaltet
           T1 = T                                           'nur ausgewhlte Tabelle ausgeben
         Else                                               'wenn Ausgabe ab erster Tabelle eingeschaltet
           T1 = 1                                           'ab erster bis ausgewhlte Tabelle ausgeben
         End If
         Goto TabOut                                        'starte tabellenausgabe

       Case SF1 To SF12                                     'Shift F1 bis Shift F12
         T = Key - F4                                       'F4=F1-3 => -F1+1-4

         IR6 = 0                                            'Aufheben des Shift Modes
         Ldi R27 , $01                                      'Load R27 with MSB of IR6
         Ldi R26 , $00                                      'Load R26 with LSB of IR6
         Ld R6,X                                            'store IR6 into R6

         IF ET = 0 Then                                     'wenn Ausgabe ab erster Tabelle ausgeschaltet
           T1 = T                                           'nur ausgewhlte Tabelle ausgeben
         Else                                               'wenn Ausgabe ab erster Tabelle eingeschaltet
           T1 = 13                                          'ab erster Shift-Tabelle bis ausgewhlte Tabelle
         End If

      TabOut:                                               'Tabellenausgabe

         IF EDIT = 1 Then                                   'wenn Edit-Mode gestartet
           Disable Interrupts                               'sonst wird K verndert
           LCD "Lektion " ; T                               'Anzeige der zu editierenden Lektionsnummer

           Z = CwTabIdx(1) - 1                              ' Beginn der EEPROM-Tabelle (erstes &HF0), hier 256
           K = CwTabIdx(T) - 256                            'Letzes zu lesendes Zeichen (&HF0 der Vorgnger Tabelle)

           'LCD "T" ; T ; "Z" ; Z ; "I" ; I ; "K" ; K ; "     "       'Testausgabe
           For I = 1 To K
             Readeeprom ChrRP(I) , Z                        'Tabellen aus EEPROM in Tastaturpuffer kopieren
             Z = Z + 1
           Next I
           EIFR.INT1 = 1                                    'Lsche Interrupt1 Flag
           Enable Interrupts
           EDIT = 2                                         'Edit-Flag auf "Edit begonnen" setzen
           PKey = 0                                         'Letztes Zeichen von der Tastaur auf Null stellen
         Else                                               'Im Normal-Mode
           Home Lower
           LCD "Lektion "                                   'Aktionsanzeige
           IF T = T1 Then
             LCD T ; "           "
           Else
             LCD "1 bis " ; T ; "     "
           End If
           Waitms 500

           EZ = CwTabIdx(T1)                                '1. Zeichen der aktiven Tabelle
           T = T + 1                                        'Index auf Start der Folgetabelle
           LZ = CwTabIdx(T) - 1                             'Letztes Zeichen der aktiven Tabelle
           AZ = LZ - EZ                                     'Anzahl der Zeichen (ohne Trennzeichen)
           Z = EZ                                           'Beginn mit erstem Zeichen
           N = 0                                            'Reset des 5er Gruppen Zhlers

           PKey = F1                                        'Letztes Zeichen von der Tastaur auf F1 stellen
         End If

       Case NUM
         UBcal = NOT UBcal                                  'Toggle Batterie-Kalibriermode
         IF UBcal = 0 Then                                  'bei abgeschaltetem Kalibriermode
           Port_com = 0                                     'Com-LED aus
           Gosub LCDout3                                    'Statusausgabe in der 2. Zeile
           If UBKorr <> UBKorrAlt Then                      'bei nderung des Korrekturwertes
             Writeeeprom UBKorr , 251                       'neuen Wert im EEPROM speichern
             UBKorrAlt = UBKorr                             'und als jetzt alten Wert merken
           End If
         Else                                               'bei eingeschaltetem Kalbriermode
           Port_com = 1                                     'Com-LED ein
           Gosub ReadUB                                     'Batteriespannung messen und anzeigen
         End If
       Case L_ALT
         C = 0                                              'Einmalige Ausgabe
         PKey = 0
         Home Lower
         LCD "Endlosausgabe AUS   "                         'Aktionsanzeige
         'Wait 1
       Case R_ALT
         PKey = 0
         C = 1                                              'Endlos Ausgabe einschalten
         Home Lower
         LCD "Endlosausgabe EIN   "                         'Aktionsanzeige
         'Wait 1
       Case L_CTRL
         Home Lower
         LCD "Zufallsausgabe AUS  "                         'Aktionsanzeige
         R = 0                                              'Random Ausgabe abschalten
       Case R_CTRL
         Home Lower
         LCD "Zufallsausgabe EIN  "                         'Aktionsanzeige
         R = 1                                              'Random Ausgabe einschalten
       Case KP_MINUS
         Home Lower
         LCD "Kontroll-Mode AUS   "                         'Aktionsanzeige
         GOSUB KMaus                                        'Kontroll Mode ausschalten
       Case KP_PLUS
         Home Lower
         LCD "Kontroll-Mode EIN   "                         'Aktionsanzeige
         KM = 1                                             'Kontroll Mode einschalten
         Dsp = 0                                            'Zeichen Ausgabe abschalten
       Case CAPS
         Home Lower
         LCD "Ab Lektion 1 AUS    "                         'Aktionsanzeige
         ET = 0                                             'Ausgabe ab Tabelle 1 abschalten
       Case TAB
         Home Lower
         LCD "Ab Lektion 1 EIN    "                         'Aktionsanzeige
         ET = 1                                             'Ausgabe ab Tabelle 1 einschalten
       Case POS1                                            'Tastaturpufferzeiger auf 1. Zeichen
         Home Lower
         LCD "T-Puffer wiederholen"                         'Aktionsanzeige
         Waitms 500
         K = 1
         PKey = POS1
       Case DELETE                                          'Tastaturpuffer aus EEPROM lesen
         Home Lower
         LCD "T-Puffer aus EEPROM "                         'Aktionsanzeige
         Gosub ReadEprDaten
       Case INSERT                                          'Tastaturpuffer is EEPROM schreiben
         Home Lower
         LCD "T-Puffer nach EEPROM"                         'Aktionsanzeige
         Gosub WriteEprDaten
       Case ENDE                                            'Ausgabe beenden
         K = I                                              'Tastaturpufferzeiger auf Ende
         PKey = 0
         Home Lower
         LCD "Ausgabe angehalten! "                         'Aktionsanzeige
       Case ESC                                             'Lsche Tastaturpuffer
         Gosub ResBuff                                      'Bufferzeiger initialisieren
         Home Lower
         LCD "T-Puffer gel" ; CHR(239) ; "scht!  "          'Aktionsanzeige
       Case BKSP                                            'Lsche letztes Zeichen im Tastaturpuffer
         Disable Interrupts                                 'verhindert,dass Ausgabe los luft
         I = I - 1                                          'Letztes Zeichen zurcknehmen
         K = K - 1                                          'Ausgabezeiger anpassen
         Enable Interrupts
       Case PG_UP                                           'Edit Mode Einschalten
         Gosub ResBuff                                      'Bufferzeiger initialisieren
         EDIT = 1
         Port_com = 1
         Cls
         Home Lower
         LCD "Edit "
       Case PG_DN                                           'Edit Mode beenden
         IF EDIT = 2 Then                                   'wenn Edit begonnen, Folgetabellen in den Tastaturpuffer kopieren
           Home Lower
           LCD "Lektion gepeichert! "
           Disable Interrupts                               'sonst wird K verndert
           'T = T + 1                                        'Nummer der Folgetabelle
           Z = CwTabIdx(T + 1) - 1                          'Trennzeichen vor der Folgetabelle
           Temp = CwTabIdx(25) + 1                          'Zeichen nach letztem Trennzeichen
           'Home Lower : LCD "T" ; T ; "Z" ; Z ; "I" ; I ; "M" ; Temp ; "     "       'Testausgabe
           While Z < Temp                                   'Zeichen von Z bis Temp
             IF I < 248 Then                                'wenn Pufferenden nicht erreicht
               Readeeprom ChrRP(I) , Z                      'aus EEPROM in Tastaturpuffer kopieren
               Z = Z + 1                                    'EEPROM Adresse inkrementieren
               I = I + 1                                    'Pufferzeiger inkrementieren
             Else                                           'wenn vorher Pufferende erreicht wird
               ChrRP(248) = Textende                        'Textende erzwingen
               ChrRP(249) = 0                               'und Tabellenende eintragen
             End If
           Wend
           K = I
           'Home Lower : LCD "T" ; T ; "Z" ; Z ; "I" ; I ; "K" ; K ; "M" ; Temp ; "     "       'Testausgabe
           Gosub Save                                       'gesamten Tastaturpuffer in EEPROM zurckschreiben
           EIFR.INT1 = 1                                    'Lsche Interrupt1 Flag
           Enable Interrupts
         End If
         EDIT = 0                                           'Edit-Mode abschalten
         GOSUB GetIndex                                     'Tabellen Indizes neu berechnen
         Port_com = 0
         Gosub LCDout3
       Case Karate                                          'CW-Eingabe mit Taste
         Paddle = 0
         GOSUB SavePaddle                                   'speichert genderten Wert im EEPROM
         GOSUB LCDout4                                      'Anzeige der Einstellung auf dem Display
       Case Grad                                            'CW-Eingabe mit Paddle
         Paddle = 128
         GOSUB SavePaddle                                   'speichert genderten Wert im EEPROM
         GOSUB LCDout4                                      'Anzeige der Einstellung auf dem Display
       'Case KP_Div
         'nicht nutzbar weil Scan Code E0 4A und 4A bereits belegt ist
       Case KP_Mul
         Gosub ReadIndex
         'frei fr weitere Funktion
       Case U_ARROW                                         'CwTonfrequenz um 100 Hz erhhen
         Gosub SetCwTon                                     'CW-Ton einstellen
       Case D_ARROW                                         'CwTonfrequenz um 100 Hz reduzieren
         Gosub SetCwTon                                     'CW-Ton einstellen
       Case L_ARROW
         IF UBcal = 255 Then                                'bei eingeschaltetem Kalibriermode
           DECR UBKorr                                      'Korrekturwert reduzieren
           Gosub ReadUB                                     'Batteriespannung messen und anzeigen
         Else                                               'bei eingeschaltetem Kalibriermode
           Dsp = 0                                          'LCD Ausgabe ausschalten
         End If
       Case R_ARROW
         IF UBcal = 255 Then                                'bei eingeschaltetem Kalibriermode
           INCR UBKorr                                      'Korrekturwert erhhen
           Gosub ReadUB                                     'Batteriespannung messen und anzeigen
         Else
           Dsp = 1                                          'LCD Ausgabe einschalten
         End If
       Case PRNT                                            'mit PRINT-Taste
        #if LCD_Dsp = 1
         GOSUB ParOut                                       'Programmparameter Ausgabe
        #endif
       Case Else                                            'in allen anderen Fllen (keine Steuerzeichen)
         IF Stp = 1 Then                                    'wenn Stop fr Kontrollmode gesetzt
           GOSUB Kontrolle                                  'Kontrolle durchfhren
         Else
           ChrRP(I) = Key                                   'Zeichen in Tastaturpuffer eintragen
           Incr I                                           'Eintragszeiger incrementieren
           IF I > TastRP Then I = 1                         'wenn Pufferende erreicht, wieder bei 1 beginnen
           AZ = AZ + 1
           PKey = Key                                       'Key in PKey speichern
           Zeichen = Key                                    'Key nach Zeichen bergeben
          #if LCD_Dsp = 1
           GOSUB LCDout                                     'Zeichen in Anzeigestring eintragen und anzeigen
          #endif
           R = 0                                            'Zufallsausgabe abschalten
           C = 0                                            'Endlossausgabe abschalten
           N = 0                                            'Reset des 5er Gruppen Zhlers
         End If
     End Select

     IF Dsp = 2 Then                                        'bei Rckkehr aus dem Play-Menue mit Start
       Gosub StatDspl                                       'Einstell-Menue Status anzeigen
       Dsp = 1                                              'Display aktivieren
     End If
     IF Dsp = 3 Then                                        'bei Rckkehr aus dem Play-Menue mit Stopp
       CLS                                                  'Display lschen
       'Home Upper
       LCD "Stopp!"                                         'in erster Zeile "Stopp!" und
       Gosub LCDout3                                        'in zweiter Zeile Zustand anzeigen
       Dsp = 1                                              'Display aktivieren
     End If

     IF I = 2 Then                                          'bei I=2 ???
       ___rseed = Timer2                                    'Random seed von Timer2 holen
     End If

    #if DebugDsp = 3                                        'Debug-Ausgabe auf Display nach Ausfhrung
     IF Key > 0 Then
       Home Lower
       LCD "K" ; Key ; " I" ; IR6 ; " P" ; Paddle ; " V" ; Vcw ; " A" ; Abstand ; "       "
     End If
    #endif

  NoKey:

   Wend


   Gosub ResBuff                                            'Bufferzeiger initialisieren
   Gosub CWTempoX

   'Punkt = 80                                               'Defaultvorgabe fr Punkt
   'Strich = 240                                             'Defaultvorgabe fr Strich

   Punkt = Tcw                                              'Defaultvorgabe fr Punkt
   Strich = 3 * Tcw                                         'Defaultvorgabe fr Strich

   Einh15 = Punkt + Strich                                  'Symbol-Mittelwert =
   Shift Einh15 , Right , 1                                 'Einh15=(Punkt+Strich)/2

   Taste = 0                                                'Steuervariablen initialisieren
   Pause = 0
   ChrOut = 0
   N = 1                                                    'Symbolzhler auf 1 setzen
   ChrMem(1) = 0                                            'Speicherwert fr Dauer von Symbol 1 auf Null setzen

   While CwDec = 1                                          'solange CW-Decoder aktiv

   'Set Port_Test

   IF Port_PlayTaste = 0 Then                               'wenn Play-Taste gedrckt wird
     While Port_PlayTaste = 0 : Wend                        'warten bis sie wieder losgelassen ist
     Gosub ActKBD                                           'dann Keyboard (Trainer-Mode) aktivieren
   End If

   IF Paddle < 128 Then                                     'Bei Tasten-Betrieb
     IF Port_CW_Taste = 0 Then                              'wenn CW-Taste gedrckt
       Gosub TastOn                                         'Tastung ein
     Else                                                   'wenn CW-Taste losgelassen
       Gosub TastOff                                        'Tastung aus
     End If
   Else                                                     'bei Paddle-Betrieb
     Paddle = 128
     IF Port_Paddle_DIT = 0 Then                            'bei Paddle-DIT
       Paddle = 129                                         'Paddle = 129
     End If
     IF Port_Paddle_DA = 0 Then                             'bei Paddle-DA
       Paddle = 130                                         'Paddle = 130
     End If
   End If

     If PrFlag = 1 Then                                     'wird alle 10ms vom Timer-Interrupt gesetzt

       If Pause > Einh15 Then                               'wenn Pause > Symbol-Mittelwert

         IF ChrOut = 0 Then                                 'und mindestens 1 Symbol erkannt wurde

           PEinh = 1000                                     'Punkteineit auf max
           SEinh = 0                                        'Stricheinheit auf min

           Decr N                                           'Symbolzhler decrementieren

           For J = 1 To N                                   'alle Symbolwerte testen
             If ChrMem(J) < PEinh Then                      'wenn Symboldauer kleiner als aktuelle Punkteinheit
               PEinh = ChrMem(J)                            'kleineren Wert als neue Punkteinheit verwenden
             End If
             If ChrMem(J) > SEinh Then                      'wenn Symboldauer grer als aktuelle Stricheinheit
               SEinh = ChrMem(J)                            'greren Wert als neue Stricheinheit verwenden
             End If
           Next J

           PEinh2 = PEinh + PEinh                           'doppelte Punkteinheit
           Temp = PEinh - Punkt
           IF SEinh > PEinh2 Then                           'wenn Stricheinheit grer als doppelte Punkteinheit
             Punkt = PEinh                                  'Punkt = Punkteinheit
             Strich = SEinh                                 'Strich = Stricheinheit
           End If

           Einh15 = Punkt + Strich
           Shift Einh15 , Right , 1                         'Symbol-Mittelwert = (Punkt+Strich)/2

           IF N = 6 Then                                    'bei 6 Symbolen
             IF ChrMem(6) < Einh15 Then                     'und 6. Symbol = Punkt
               N = 7                                        'Lnge = 7
             Else                                           'sonst
               N = 2                                        'Lnge = 2
             End If
           End If

           Zeichen = 0                                      'Zeichenwert lschen (alles Punkte)
           For J = 1 To 6                                   'beginnend mit MSB
             IF ChrMem(J) > Einh15 Then                     'wenn Symboldauer grer als Symbol-Mittelwert
               Zeichen = Zeichen + 1                        'Symbol = Strich
             End If
             Shift Zeichen , Left , 1                       'nchstes Symbol
             ChrMem(J) = 0                                  'Speicherwert fr Symboldauer wieder Null setzen
           Next J
           Shift Zeichen , Left , 1                         'Zeichen fr Lngenaddition positionieren
           Zeichen = Zeichen + N                            'Zeichenlnge addieren

#if LCD_Dsp = 1
           GOSUB LCDout                                     'Zeichen auf Display ausgeben
#endif
           Temp = Punkt + Strich
           Temp = Temp / 4
           RVcw = TcwFaktor / Temp


           N = 1                                            'Symbolzhler fr nchstes Zeichen wieder auf 1 stellen
           ChrMem(1) = 0                                    'Symboldauer fr erstes Symbol Null setzen
           ChrOut = 1                                       'Zeichenausgabeflag setzen
         End iF


         IF Pause > WPause Then                             'wenn Paus grer Wort-Pause
           If ChrOut = 1 Then
             Zeichen = 255
#if LCD_Dsp = 1
             GOSUB LCDout                                   'Blank Ausgabe
#endif
             ChrOut = 2                                     'Ausgabe weiterer Blank Sperren
           End If
         End If

       End iF
       PrFlag = 0                                           'Interrupt-Bearbeitungs-Flag lschen

     End If
     Gosub LCDout3

     'Reset Port_Test

     Idle                                                   'warten auf nchsten Interrupt

   Wend                                                     'Schleifenende CW-Decoder

 Loop                                                       'Schleifenende Main-Loop

 End
'------------------------------------------------------------------------------
T1int:                                                      'Timer1-Interrupt

 Timer1 = T1Preset                                          '

 'SET Port_Test

 IF CwDec = 0 Then                                          'CW Geber Interrupt Routine

   IF Stp = 1 Then GOTO NoAct                               'wenn Sopsignal aktiv, keine Aktion

   IF L = 0 Then                                            'wenn Zeichen vollstndig ausgegeben

     IF K <> I Then                                         'wenn noch Zeichen im Tastaturpuffer stehen
       IF R = 0 Then
         Zeichenx = ChrRP(K)                                'Zeichen aus Tastaturpuffer lesen
         Incr K                                             'nchstes Zeichen adressiern
         IF K > TastRP Then K = 1                           'wenn Tastaturpufferende erreicht, K=1
       Else                                                 'bei Zufallsausgabe
         IF N < 5 Then                                      'und noch keine 5 Zeichen ausgegeben sind
           IF KM = 0 Then Incr N                            'bei abgeschaltetem Kontroll-Mode nchste Zeichen
           K = RND(I)                                       'zuflliges Zeichen auswhlen
           Zeichenx = ChrRP(K)                              'Zeichen aus Tastaturpuffer lesen
         Else                                               'wenn 5er Gruppe voll
           Goto Blank                                       'Blank ausgeben
         End If
       End If
     Else                                                   'wenn Tastaturpuffer ganz ausgegeben
       IF PKey = POS1 Then                                  'bei Tastaturpuffer Wiederholung
         IF C = 1 Then                                      'bei Endlosausgabe
           Zeichenx = 255                                   'Blank ausgeben
           K = 1                                            'und Endlosausgabe Zeiger wieder auf Anfang stellen
         End If
       End If
     End If

     IF PKey = F1 Then                                      'wenn letzte Taste eine Funktionstaste war
       IF N < 5 Then                                        'und noch keine 5 Zeichen ausgegeben sind
       Again:
         IF R = 1 Then                                      'wenn Zufallsausgabe aktiv
           Z = EZ + RND(AZ)                                 'zuflliges Zeichen auswhlen
           IF KM = 0 Then Incr N                            'bei abgeschaltetem Kontroll-Mode nchste Zeichen
         End If
         Readeeprom Zeichenx , Z                            'Zeichen aus EEPROM lesen

         IF Zeichenx = Textende Then                        'wenn Zeichen=Textende
           IF R = 1 Then                                    'und Zufallsausgabe aktiv
             Decr N                                         'Zeichen nicht ausgeben und
             Goto Again                                     'neues Zeichen holen
           End If
           Zeichenx = 255                                   'sonst Ausgabe beenden
         End If

         ' XKey = Zeichenx                                    'Zeichen fr Kontroll-Mode merken

       Else                                                 'wenn 5er Gruppe ausgegeben
         Blank:
         Zeichenx = 255                                     'Ausgabe beenden
         N = 0                                              '5er Gruppen Zhler auf Null stellen                                              '
       End if

     End If

     XKey = Zeichenx                                        'Zeichen fr Kontroll-Mode merken

     IF Zeichenx = Textende Then                            'wenn Textende erreicht
       Zeichenx = 255                                       'Ausgabe beenden
     End If

     Zeichen = Zeichenx                                     'Zeichen fr Displayausgabe speichern

     L = Zeichenx AND 7                                     'extrahieren der Zeichenlnge

     IF Zeichenx = 255 Then                                 'Wortabstand einstellen
       Zeichenx = 0                                         'keine Tastung
       A = Abstand * 3                                      'Wortabstand = 3 * Zeichenabstand
       S = 1                                                'Symbolabstand aktivieren
       L = 1                                                'einen Wortabstand warten
     End If

     IF Zeichenx = &H07 Then                                'Sonderfall Irrung mit 8 Punkten
       L = 8
       Zeichenx = 0
       Goto NoChange
     End If

     IF Zeichenx = &H3F Then                                'Sonderfall  Lnge = 7
       L = 7
       Zeichenx = 24
       Goto NoChange
     End If

     IF L = 7 Then                                          '6-stelliges Zeichen mit Punkt endend
       L = 6
       Zeichenx = Zeichenx AND &B11111011
       Goto NoChange
     End If

     IF Zeichenx = &H06 Then                                'Sonderfall @ Lnge = 6
       L = 6
       Zeichenx = 104
       Goto NoChange
     End If

     IF Zeichenx = &H0C Then                                'Sonderfall $ Lnge = 7
       L = 7
       Zeichenx = 18
       Goto NoChange
     End If

     IF Zeichenx = &H35 Then                                'Sonderfall & Lnge = 5
       L = 5
       Zeichenx = 64
     End If

   NoChange:
   Else                                                     'wenn Zeichen oder Wortabstand noch nicht vollstndig ausgegeben, L>0

     IF A = 0 Then                                          'wenn Tastzeit und
       IF S = 0 Then                                        'Silbenpause abgelaufen
         Gosub TastOn                                       'Tastung aktivieren
         S = 1                                              'Silbenpause aktivieren
         IF Zeichenx > 127 Then                             'wenn MSB = 1
           A = Strich                                       'Da
         Else                                               'sonst
           A = Punkt                                        'Dit
         End if
       End if
     End if
     IF A = 0 Then                                          'wenn Tastzeit abgelaufen und Silbenpause nicht begonnen (S=1)
       Gosub TastOff                                        'Tastung deaktivieren
       Decr L                                               'Restzeichenlnge decrementieren
       IF L = 0 Then                                        'wenn Zeichen ganz ausgegeben

#if LCD_Dsp = 1

         IF PKey = Pos1 Then Goto Ausgabe                   'bei Tastaturpuffer Wiederholung
         IF R = 1 Then Goto Ausgabe                         'bei Zufallsausgabe
         IF C = 1 Then Goto Ausgabe                         'bei Endlosausgabe
         IF PKey = F1 Then                                  'bei Lektionenausgabe wenn letzte Eingabe Funktionstaste war
           Ausgabe:
           Gosub LCDout                                     'Zeichen-Ausgabe am Display
         End If

#endif
         A = Abstand                                        'Zeichen Abstand, Lnge Abstand
         Zeichenx = 0                                       'Abstand ausgeben

         IF PKey <> POS1 Then                               'wenn keine Tastaturpufferwiederholung Ausgabe beenden
           IF R = 0 Then Incr Z                             'im Normal-Mode Zeichenzeiger incrementieren
           IF Z => LZ Then                                  'wenn letzes Zeichen erreicht
             IF C = 0 Then                                  'und Einmalige Ausgabe
               PKey = 0                                     'Ausgabe beenden
             End If
           End If
           IF Z > LZ Then Z = EZ                            'fr Tabellenausgabe
         Else
           IF C = 0 Then                                    'und Einmalige Ausgabe
             'PKey = 0                                       'Ausgabe beenden
           End If
         End If


         IF KM = 1 Then                                     'im Kontroll-Mode
           Stp = 1                                          'Ausgabe stoppen und
           Set Port_Kontrolle                               'Kontroll-LED aktivieren
         End If

       Else
         A = Punkt                                          'Silbenpause mit Lnge Punkt eintragen
       End If

       Shift Zeichenx , Left , 1                            'nchstes Symbol des Zeichens auf MSB schieben
       S = 0                                                'Silbenpause deaktivieren
     End If                                                 'IF A = 0

   End If                                                   'IF L = 0

   IF A > 0 Then                                            'wenn A>0
     Decr A                                                 'A decrementieren
   End If

NoAct:

   IF UBCykl < UBCycleMax Then Incr UBCykl                  'nach dem Einschalten UBCykl incrementieren

#if RS232Debg = 1
   If TI > 1 Then
     W = W + 1
     IF W > 100 Then Gosub TestOut
   End If
#endif

 Else                                                       'CwDecoder Interrupt Routine

   IF Paddle > 127 Then                                     'bei Paddle-Betrieb Automatische Wiederholung von DIT und DA
     IF Paddle > 128 Then                                   'wenn Paddle (DIT oder DA) gedrckt
       IF A = 0 Then                                        'und aktuelle Tastung
         IF S = 0 Then                                      'und Symbolabstand abgelaufen
           Gosub TastOn                                     'Tastung einschalten
           S = 1                                            'Symbolabstand aktivieren
           IF Paddle = 129 Then                             'wenn Paddle auf DIT
             A = Tcw                                        'Tast-Dauer = Punkt
           Else                                             'wenn Paddle auf DA
             A = 3 * Tcw                                    'Tast-Dauer = Strich
           End If
         End If
       End If

     End If

     IF A = 0 Then                                          'Wenn Tastzeit abgelaufen
       Gosub TastOff                                        'Tastung abschalten
       A = Tcw                                              'Symbolabstand eintragen
       S = 0                                                'und deaktivieren
     End If
     IF A > 0 Then                                          'Wenn Tastzeit oder Symbolabstand nicht abgelaufen
       Decr A                                               'Tastzeit decrementieren
     End If
     IF Read_TxTastung = 1 Then                             'wenn Tastung aktiv
       Gosub ReadSymbol
     Else
       Gosub ReadPause
     End If
   Else
     IF Port_CW_Taste = 0 Then                              'wenn Tastung aktiv
       Gosub ReadSymbol
     Else
       Gosub ReadPause
     End If
   End If

   PrFlag = 1                                               'Interruptprocessing Flag setzen

 End If

 IF Port_PlayTaste = 0 Then                                 'wenn Bedientaste gedrckt
   IF TastTime < TastTimeMax Then Incr TastTime             'Tastenzeitzhler incrementieren
   ERR = 1                                                  'verlt die Keyboard Polling Routine
 End If

 Reset Port_Test

Return
'------------------------------------------------------------------------------
ReadSymbol:
 IF Taste = 0 Then                                          'und vorher nicht aktiv, dh. Beginn einer Tastung
   IF N = 1 Then
     IF Pause < 20000 Then
       IF ChrOut = 2 Then
         WPause = Pause / 2
       Else
         WPause = Pause * 2
       End If
     End If
   End If
   Pause = 0                                                'Pausenzhler auf Null
   ChrOut = 0                                               'Zeichenausgabeflag rcksetzen
 End If
 Incr ChrMem(N)                                             'Lnge von Symbol N incrementieren
 Taste = 1                                                  'merken, dass Tastung aktiv
Return
'------------------------------------------------------------------------------
ReadPause:
 IF Taste = 1 Then                                          'und vorher aktiv war, dh. Ende einer Tastung
   IF N < 9 Then
     Incr N                                                 'Symbolzhler bis max 9 incrementieren
     ChrMem(N) = 0                                          'Speicherwert fr Dauer von Symbol N auf Null setzen
   End If
 End If
 Taste = 0                                                  'merken, dass Tastung inaktiv
 IF Pause < 20000 Then
   Incr Pause                                               'Pausenzhler bis max 20 sec incrementieren
 End If
Return
'------------------------------------------------------------------------------
#if LCD_Dsp = 1
LCDout:

  AChr = Lookup(Zeichen , CW2ASCII)
  IF Achr < 32 Then
    DZ = Lookup(Achr , Doppelzeichen)
    LCDSTR = LCDSTR + Chr(DZ)
    Achr = Achr - 16
    DZ = Lookup(Achr , Doppelzeichen)
    LCDSTR = LCDSTR + Chr(DZ)
  else
    LCDSTR = LCDSTR + Chr(AChr)
  End If
  IF Len(LCDSTR) > 20 Then
    LCDSTR = Right(LCDSTR , 20)
  End If

  IF Dsp = 0 Then Return

LCDout2:

  Home Upper
  LCD LCDSTR

LCDout3:

 #if DebugDsp = 0                                           'wenn Debug Display abgeschaltet, Standardausgabe
  IF Edit = 0 Then
  Temp = Abstand / 10
  If CwDec = 0 Then                                         'bei CW-Geber
    Home Lower                                              'in der zweiten Zeile
    LCD "Trainer "                                          'Anzeige "TRainer:"
    'LCD "Key=" ; Key ; "   "
    'LCD "Z=" ; Zeichen ; "   "
    LCD "V=" ; Vcw ; " A=" ; Temp ; "   "                   'Vcw und Abstand/10
    'LCD "V=" ; Vcw ; " T=" ; CwTonFreq ; "   "
  Else
LCDout4:
    Home Lower
    IF Paddle < 128 Then                                    'bei Taste
      LCD "Taste:  " ;
      LCD "V=" ; RVcw ; " " ; Punkt ; "|" ; Strich ; "     "
      'LCD Punkt ; "|" ; Strich ; "|" ; WPause ; "     "
      'LCD Punkt ; "|" ; Strich ; "|" ; WPause ; "     "
      'IF LPause > 0 Then
        'LCD "K=" ; KPause ; " L=" ; LPause ; " W=" ; WPause ; "     "
      'End If
'(
      IF Zeichen < 255 Then
        'LCD "T: Z=" ; Zeichen ; " N=" ; N ; " P=" ; Pause ; "     "
        LCD "P" ; Punkt ; "|" ; PEinh ; " S" ; Strich ; "|" ; SEinh ; "   "
        'IF Pause > 0 Then LCD "E15=" ; Einh15 ; " P=" ; Pause ; " W=" ; WPause ; "     "
      End If
')
    Else                                                    'bei Paddle
      LCD "Paddle:  " ;
      'LCD "P: " ;
      'LCD "V=" ; Vcw ; " A=" ; Temp ; "   "
      LCD "V=" ; Vcw ; " A=" ; Temp ; " T=" ; Tcw ; "   "   'Vcw, Abstand/10 und Tcw
    End If
  End If
  End If
#endif

Return
'------------------------------------------------------------------------------
UBoff:

  IF UBCykl < 255 Then
    Disable Interrupts
    CLS
    UBCykl = 255
    Enable Interrupts
  End If
Return
'------------------------------------------------------------------------------
 GetIndex:
'Suchen der Tabellenindizes aus den Data Statements im EEPROM ab Adr. 256

 Z = 256                                                    'Start der Lektionentabellen im EEPROM
'(
 For T = 1 To 25                                            'Fr Tabellen 1 bis 25, 25 ist Zeichen nach letzter Tabelle
   Readeeprom Zeichen , Z
   Z = Z + 1                                                'Zeichenzeiger incrementieren
   IF Zeichen = &HF0 Then                                   'bei Tabellenendezeichen
     CwTabIdx(T) = Z                                        'Eintragen des Tabellenbeinns
   End If
 Next T
')
' (
 T = 1                                                      'Tabellen Nummer: 1...25, 25 ist Zeichen nach letzter Tabelle
 Do
   Readeeprom Zeichen , Z
   IF Zeichen = &HF0 Then                                   'bei Tabellenendezeichen
     CwTabIdx(T) = Z + 1                                    'Eintragen des Tabellenbeinns
     T = T + 1                                              'Indexzeiger incrementieren
   End If
   Z = Z + 1                                                'Zeichenzeiger incrementieren
 Loop Until Zeichen = 0                                     'bis zum Ende der letzten Tabelle
' )
 Return
'------------------------------------------------------------------------------
ReadIndex:
 T = T + 1
 IF T > 25 Then T = 1
 Temp = CwTabIdx(T)
 Temp2 = Temp - 256
 'K = Temp
 Home Lower
 LCD "T=" ; T ; " I=" ; Temp ; " K=" ; Temp2 ; "          "
Return
'------------------------------------------------------------------------------
Save:

 'CLS
 For I = 1 To K
   Z = I + 255                                              'Lektioenen Daten ab EEPROM-Adresse 256
'(
   Tmp = ChrRP(I)
   AChr = Lookup(Tmp , CW2ASCII)
   IF I < 21 Then
     LCD CHR(AChr)
   End If
   IF I = 25 Then Home Lower
   IF I > 210 Then
     LCD CHR(AChr)
   End If
')
   Writeeeprom ChrRP(I) , Z                                 'Daten schreiben
 Next I
 Gosub GetIndex

Return
'------------------------------------------------------------------------------
Kontrolle:

 IF Key = 255 Then                                          'mit Blank
KMaus:
   PKey = 0
   KM = 0                                                   'Kontrollmode ausschalten
   K = I                                                    'Ausgabezeiger auf Tastaturpufferende
   Goto KM1
 End If

 IF Key <> XKey Then
   'OCR2 = 255
   OCR2A = 255                                              'tiefsten Ton einstellen
   TCCR2A = Val_TCCR2A                                      'Fehler Ton Ein
   TCCR2B = Val_TCCR2B                                      'Fehler Ton Ein
   Waitms 500                                               'Fehlerton fr 500ms
   TCCR2A = 0                                               'Fehler Ton Aus
   TCCR2B = 0                                               'Fehler Ton Aus
   'OCR2 = CwTon
   OCR2A = CwTon                                            'wieder CW-Ton einstellen
 Else
KM1:
   Stp = 0                                                  'Stoppsignal aufheben
   Reset Port_Kontrolle                                     'LED Kontrolle Aus
 End If

 Return
'------------------------------------------------------------------------------
#if RS232Debg = 1
TestOut:

 H = TI - 1
 Print "Bytes " ; Hex(H) ; ": ";
 H = 1
 While TI > H
 Print Hex(TestRP(H)) ; ", ";
 H = H + 1
 Wend
 Print

 Print "R6:       " ;
 H = 1
 While TI > H
 Print Hex(TestR6(H)) ; ", ";
 H = H + 1
 Wend
 Print
 TI = 1
 W = 0

Return
#endif
'------------------------------------------------------------------------------
ParOut:
 CLS
 LCD "E" ; Edit ; " T" ; ET ; " D" ; Dsp ; " G" ; Paddle ; "   "
 Home Lower
 LCD "R" ; R ; " K" ; KM ; " B" ; I ; " P" ; Punkt ; " V" ; Vcw ; " A" ; Abstand ; "   "

Return
#endif
'------------------------------------------------------------------------------
ResBuff:                                                    'Bufferzeiger initialisieren
  K = 1                                                     'Ausgabezeiger initialisieren
  I = 1                                                     'Fllzeiger initialisieren
#if LCD_Dsp = 1
  LCDSTR = ""                                               'Ausgabestring lschen
  IF Logo = 0 Then Return                                   'bei Logo=0 Display nicht lschen
  CLS
  GOSUB LCDout2                                             'Display lschen und Statusanzeige in Zeile 2
#endif
Return
'------------------------------------------------------------------------------
CWtempo:                                                    'CW-Tab lesen und neue Werte speichern und einstellen

 Tmp = Key - KP_0                                           'Tabellenindex berechnen

 H = Lookup(Tmp , CWtab)                                    'Eintrag aus CWTab holen
 IF Tmp < 6 Then                                            'bei Tasten 0..5
   Vcw = H                                                  'Tabellenwert Vcw zuweisen
 Else                                                       'bei Tasten 6..9
   Abstand_d = H                                            'Tabellenwert Abstand_d zuweisen
 End If

 If Vcw <> VcwAlt Then                                      'bei nderung des Wertes
   Writeeeprom Vcw , 254                                    'Wert im EEPROM speichern
   VcwAlt = Vcw                                             'neuen Wert als alten Wert speichern
 End If
 If Abstand_d <> AbstandAlt Then                            'bei nderung des Wertes
   Writeeeprom Abstand_d , 255                              'Wert im EEPROM speichern
   AbstandAlt = Abstand_d                                   'neuen Wert als alten Wert speichern
 End If

CWtempoX:                                                   'nur Tempo und Abstand einstellen

  Tcw = TcwFaktor / Vcw                                     'kleinste CW-Zeiteinheit (Punkt)

  Abstand = Abstand_d * Tcw                                 'variabler Abstand in Abstand_d Zeiteinheiten
  Punkt = Tcw                                               'Punkt zuweisen
  Strich = 3 * Tcw                                          'Strich = 3 Tcw zuweisen

Return
'------------------------------------------------------------------------------
 SavePaddle:                                                'CW-Geber Einstellung speichern

 If Paddle <> PaddleAlt Then                                'bei nderung des Wertes
   Writeeeprom Paddle , 252                                 'Wert im EEPROM speichern
   PaddleAlt = Paddle                                       'neuen Wert als alten Wert speichern
 End If

Return
'------------------------------------------------------------------------------
SetCwTon:

 IF Key = U_Arrow Then                                      'bei AUF-Pfeil
   Incr CwTonFreq                                           'Tonfrequenzwert erhhen
   IF CwTonFreq > 20 Then CwTonFreq = 20                    'Begrenzung bei 20 (2000 Hz)
 Else                                                       'bei AB-Pfeil
   Decr CwTonFreq                                           'Tonfrequenzwert reduzieren
   IF CwTonFreq < 5 Then CwTonFreq = 5                      'Begrenzung bei 5 (500 Hz)
 End If
 If CwTonFreq <> CwTonAlt Then                              'bei nderung des Wertes
   Writeeeprom CwTonFreq , 253                              'Wert im EEPROM speichern
   CwTonAlt = CwTonFreq                                     'neuen Wert als alten Wert speichern
 End If

 Home Lower                                                 'in der zweiten Zeile
 LCD "CW-Tonfreq.=" ; CwTonFreq ; "00Hz   "                 'Einstellung ausgeben

 SetCwTonX:

 CwTon = CwCLK / CwTonFreq                                  'Timereinstellung berechnen

 'OCR2 = CwTon
 OCR2A = CwTon

 Return
'------------------------------------------------------------------------------
TastOn:
 Set Port_TxTastung                                         'Tastung Ein
 Reset Port_TxTastungI                                      'Tastung Ein, inverser Ausgang
 Set Port_CW_LED                                            'CW-LED Ein
 'TCCR2 = Val_TCCR2                                          'Ton Ein
 TCCR2A = Val_TCCR2A                                        'Ton Ein
 TCCR2B = Val_TCCR2B                                        'Ton Ein
Return
'------------------------------------------------------------------------------
TastOff:
 Reset Port_TxTastung                                       'Tastung Aus
 Set Port_TxTastungI                                        'Tastung Aus, inverser Ausgang
 Reset Port_CW_LED                                          'CW-LED Ein
 TCCR2A = 0                                                 'Ton Aus
 TCCR2B = 0                                                 'Ton Aus
Return
'------------------------------------------------------------------------------
ActCwDec:                                                   'Interrupt0 CW-Taste
  Disable Int0
  'GIFR.INT1 = 1                                             'Lsche Interrupt1 Flag
  EIFR.INT1 = 1                                             'Lsche Interrupt1 Flag
  Enable Int1
  CwDec = 1                                                 'CW-Decoder aktivieren
  UBCykl = 255
  Err = 1                                                   'verlt die Keyboard Polling Routine
Return
'------------------------------------------------------------------------------
ActKBD:                                                     'Interrupt1 Keybord
  Disable Int1
  'GIFR.INT0 = 1                                             'Lsche Interrupt0 Flag
  EIFR.INT0 = 1                                             'Lsche Interrupt0 Flag
  Enable Int0
  CwDec = 0                                                 'CW-Geber (Trainer) aktivieren
  UBCykl = 255
Return
'------------------------------------------------------------------------------
ReadUB:                                                     'Batteriespannung messen

 Start Adc                                                  'Starte ADC

 Waitms 100
 :
 UBatt = Getadc(3)                                          'Messe Batteriespannung an PC3

 Stop Adc                                                   'Stop ADC

 'Tmp = UBKorr + 128
 UBatt = UBatt + UBKorr                                     'Korrektur der Batteriespannungsanzeige

 UBSTR = Str(UBatt)                                         'Spannungswert in String umwandeln
 IF Len(UBSTR) > 3 Then                                     'wenn ber 10 Volt, max 10,23 Volt
   UBSTR_L = Left(UBSTR , 2)                                'zwei Vorkommastellen
 Else                                                       'wenn unter 10 Volt
   UBSTR_L = " " + Left(UBSTR , 1)                          'eine Vorkommastelle mit Blank
 End If
 UBSTR_R = Right(UBSTR , 2)                                 'zwei Nachkommastellen

 Home Lower
 LCD " UBatt = " ; UBSTR_L ; "," ; UBSTR_R ; " Volt "       'LCD Ausgabe der Batteriespannung

 Return
'------------------------------------------------------------------------------
Writeeprdaten:                                              'EEPROM Daten schreiben
 IF I = 1 Then Return
 Wrflag = 1                                                 'Write-Flag setzen
'-------------------------------------------------------------------------------
Readeprdaten:                                               'EEPROM Daten lesen
 Epa = 1                                                    'ab Adresse 1
 Do
 If Wrflag = 1 Then                                         'wenn geschrieben werden soll
   Disable Interrupts
   Writeeeprom I , 0                                        'Akt. Lnge des Tastaturpuffers auf Adresse 0
   Writeeeprom ChrRP(Epa) , Epa                             'Daten schreiben, sonst
   Enable Interrupts
 Else
   Readeeprom I , 0                                         'Lesen der Lnge des gesp. Tastaturpuffers
   Readeeprom ChrRP(Epa) , Epa                              'Lesen des Eprominhaltes
 End If
 Incr Epa                                                   'EEPROM Adresse inkrementieren
 Loop Until Epa = I
 'K = 1                                                     'Ausgabe sofort starten
 K = I                                                      'keine sofortige Ausgabe
 Wrflag = 0                                                 'Write Flag lschen
Return
'------------------------------------------------------------------------------
TastInp:

 UBCykl = 255                                               'Abschaltung der Batterispannungsmessung
 IF PlayMenue = 255 Then                                    'bei Start
   R = 1 : ET = 1 : C = 1                                   'Randomausgabe, ab 1. Lektion und Endlosausgabe Ein
 End If
 PlayMenue = LastMenue                                      'Beginn bei letztem Menue

 IF R = 1 Then Key = &H56                                   'Punkt fr Ende

 NxtTast:
 TastTime = 0                                               'Tastendruckzeit Null setzen
 While Port_PlayTaste = 0                                   'warten bis Taste losgelassen
   Waitms 10                                                'Prellzeit abwarten
   IF L > 0 Then Goto Stopp
   IF TastTime > TastTimeStart Then Goto Done               'Bei Tastendruckzeit > 70 Start
 Wend
 Waitms 20                                                  'Entprellzeit abwarten

 Incr PlayMenue
 IF PlayMenue > 19 Then PlayMenue = 1                       'Menues 1...18
 Home Upper
 IF PlayMenue < 13 Then                                     'Lektionen 1 bis 12
   LCD "Starte Lektion " ; PlayMenue ; "    "
   Key = 86 + PlayMenue
 Else                                                       'Einstellfunktionen
   IF PlayMenue = 13 Then
     LCD "T-Speicher Ausgabe  "
     Key = DELETE                                           'Daten aus Tastaturpuffer im EEPROM
   End If
   IF PlayMenue = 14 Then
     LCD "Start m. Lekt. 1    "
     IF ET = 0 Then
       Key = TAB                                            'Ausgabe ab Tabelle 1 einschalten
       Else
       Key = CAPS                                           'Ausgabe ab Tabelle 1 abschalten
     End If
   End If
   IF PlayMenue = 15 Then
     LCD "Zufalls Ausgabe     "
     IF R = 0 Then
       Key = R_CTRL                                         'Random Dauer-Ausgabe in 5er Gruppen Einschalten
       Else
       Key = L_CTRL                                         'Random Ausgabe Abschalten
     End If
   End If
   IF PlayMenue = 16 Then
     LCD "Tempo h" ; CHR(239) ; "her         "
     IF VKey < 5 Then Incr VKey                             'Geschwindigkeit erhhen
     Key = VKey + KP_0
   End If
   IF PlayMenue = 17 Then
     LCD "Tempo langsamer     "
     IF VKey > 1 Then Decr VKey                             'Geschwindigkeit reduzieren
     Key = VKey + KP_0
   End If
   IF PlayMenue = 18 Then
     LCD "Abstand gr" ; CHR(239) ; CHR(226) ; "er      "
     IF AKey < 9 Then Incr AKey                             'Zeichenabstand erhhen
     Key = AKey + KP_0
   End If
   IF PlayMenue = 19 Then
     LCD "Abstand kleiner     "
     IF AKey > 6 Then Decr AKey                             'Zeichenabstand reduzieren
     Key = AKey + KP_0
   End If
 End If
 Gosub StatDspl                                             'Einstellungen anzeigen

 While Port_PlayTaste = 1                                   'warten bis Taste gedrckt
   IF Port_KbdClk = 0 Then Goto Stopp                       'bei Keyboardinput, Stopp
   IF Port_Paddle_DA = 0 Then Goto Stopp                    'bei Paddle DA, Stopp
   IF Port_Paddle_DIT = 0 Then Goto Stopp                   'bei Paddle DIT, Stopp
 Wend
 Waitms 20
 Goto NxtTast

 Done:
 IF Key = &H56 Then                                         'bei "." Stopp
 Stopp:
   Waitms 10                                                'Entprellzeit abwarten
   Key = &H56                                               'Dot
   'Key = &HFF                                               'Space
   Dsp = 3                                                  'Displayausgabe auf Stopp-Anzeige stellen
 Else                                                       'bei Start
   Dsp = 2                                                  'Displayausgabe auf Start-Anzeige stellen
   Locate 1 , 18                                            'Zeile 1 Spalte 18
   LCD "ok!"                                                'ok! ausgeben
 End If

 PlayFlag = 1                                               'Play-Flag aktivieren

 IF PlayMenue > 12 Then                                     'wenn Playmenue im Einstellbereich
   PlayMenue = PlayMenue - 1                                'letztes Menue beibehalten
 Else                                                       'wenn Playmenue im Startbereich
   PlayMenue = 0                                            'mit Lektion 1 beginnen
 End If
 LastMenue = PlayMenue                                      'Einstellung in LastMenue speichern

 LCDSTR = ""                                                'Anzeigestring lschen
 'Err = 0
Return
'-------------------------------------------------------------------------------
 StatDspl:                                                  'Statusanzeige fr Play-Menue
 Home Lower                                                 'in der zweiten Zeile
 LCD "Zufall:"                                              'Zufall Einstellung
 IF R = 0 Then                                              'bei R=0
   LCD "Aus"                                                'Aus
 Else                                                       'bei R=1
   LCD "Ein"                                                'Ein
 End If
 LCD " Ab L1:"                                              'Ab Lektion 1 Einstellung
 IF ET = 0 Then                                             'bei ET=0
   LCD "Aus"                                                'Aus
 Else                                                       'bei ET=1
   LCD "Ein"                                                'Ein
 End If
Return
'-------------------------------------------------------------------------------
'Scan-Code bersetzungstabelle:

Keydata:
'      0      1      2      3      4      5      6      7      8      9      A      B      C      D      E      F
Data &H00 , &H5F , &H00 , &H5B , &H59 , &H57 , &H58 , &H62 , &H00 , &H60 , &H5E , &H5C , &H5A , &H27 , &H76 , &H00       ' 0
Data &H00 , &H25 , &H00 , &H00 , &H1E , &HD4 , &H7D , &H25 , &H00 , &H00 , &HB4 , &H03 , &H42 , &H63 , &H3D , &H00       ' 1, 16
Data &H00 , &HA4 , &H94 , &H83 , &H01 , &H0D , &H1D , &H00 , &H00 , &HFF , &H14 , &H24 , &H81 , &H43 , &H05 , &H00       ' 2, 32
Data &H00 , &H82 , &H84 , &H04 , &HC3 , &HC4 , &H85 , &H00 , &H00 , &H00 , &HC2 , &H74 , &H23 , &HC5 , &HE5 , &H00       ' 3, 48
Data &H00 , &HCE , &HA3 , &H02 , &HE3 , &HFD , &HF5 , &H00 , &H00 , &H56 , &H86 , &H44 , &HE4 , &H64 , &H3F , &H00       ' 4, 64
Data &H00 , &H00 , &H54 , &H00 , &H34 , &H00 , &H00 , &H00 , &H38 , &H00 , &H8D , &H00 , &H00 , &H00 , &H00 , &H00       ' 5, 80
Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H21 , &H00 , &H00 , &H29 , &H00 , &H2C , &H2F , &H00 , &H00 , &H00       ' 6, 96
Data &H28 , &H07 , &H2A , &H2D , &H2E , &H30 , &H20 , &H1C , &H61 , &H19 , &H2B , &H1A , &H18 , &H31 , &H00 , &H00       ' 7, 112
'Tasten mit Shift
Data &H00 , &H6F , &H00 , &H5D , &H69 , &H67 , &H68 , &H72 , &H00 , &H70 , &H6E , &H6C , &H6A , &H00 , &H77 , &H00       ' 0
Data &H00 , &H26 , &H00 , &H00 , &H1F , &H06 , &HAE , &H26 , &H00 , &H00 , &H00 , &H16 , &H55 , &H00 , &H4F , &H00       ' 1, 16
Data &H00 , &HF4 , &H00 , &H00 , &H45 , &H0C , &H00 , &H00 , &H00 , &H00 , &H15 , &H00 , &H00 , &H4D , &H00 , &H00       ' 2, 32
Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H35 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H95 , &HB5 , &H00       ' 3, 48
Data &H00 , &HAF , &HAD , &H00 , &H00 , &H8D , &HB6 , &H00 , &H00 , &HE7 , &H36 , &H00 , &H00 , &H00 , &H37 , &H00       ' 4, 64
Data &H00 , &H00 , &H00 , &H00 , &H00 , &H7F , &H00 , &H00 , &H00 , &H00 , &H8D , &H00 , &H00 , &H00 , &H00 , &H00       ' 5, 80
Data &HE0 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H11 , &H00 , &H0A , &H10 , &H00 , &H00 , &H00       ' 6, 96
Data &H0E , &H0F , &H09 , &H00 , &H0B , &H08 , &H00 , &H00 , &H71 , &H00 , &H13 , &H00 , &H39 , &H12 , &H00 , &H00       ' 7, 112

 CW2ASCII:

Data 000 , 101 , 105 , 115 , 104 , 053 , 064 , 035          ' 0
Data 035 , 035 , 035 , 035 , 036 , 052 , 000 , 000          ' 8
Data 035 , 035 , 035 , 035 , 118 , 017 , 020 , 036          ' 16
Data 035 , 035 , 035 , 035 , 035 , 051 , 017 , 226          ' 24
Data 035 , 035 , 035 , 117 , 102 , 000 , 000 , 000          ' 32
Data 000 , 000 , 000 , 000 , 000 , 000 , 000 , 000          ' 40
Data 000 , 000 , 000 , 000 , 245 , 038 , 095 , 063          ' 48
Data 000 , 000 , 000 , 000 , 000 , 050 , 000 , 226          ' 56
Data 000 , 000 , 097 , 114 , 108 , 018 , 000 , 000          ' 64
Data 000 , 000 , 000 , 000 , 000 , 022 , 000 , 034          ' 72
Data 000 , 000 , 000 , 000 , 225 , 019 , 046 , 000          ' 80
Data 000 , 000 , 000 , 000 , 000 , 000 , 000 , 000          ' 88
Data 000 , 000 , 000 , 119 , 112 , 000 , 000 , 000          ' 96
Data 000 , 000 , 000 , 000 , 000 , 000 , 000 , 064          ' 104
Data 000 , 000 , 000 , 000 , 106 , 000 , 000 , 000          ' 112
Data 000 , 000 , 000 , 000 , 000 , 049 , 000 , 096          ' 120
Data 000 , 116 , 110 , 100 , 098 , 054 , 045 , 000          ' 128
Data 000 , 000 , 000 , 000 , 000 , 061 , 000 , 000          ' 136
Data 000 , 000 , 000 , 000 , 120 , 047 , 000 , 000          ' 144
Data 000 , 000 , 000 , 000 , 000 , 000 , 000 , 000          ' 152
Data 000 , 000 , 000 , 107 , 099 , 000 , 000 , 000          ' 160
Data 000 , 000 , 000 , 000 , 000 , 016 , 033 , 059          ' 168
Data 000 , 000 , 000 , 000 , 121 , 040 , 041 , 000          ' 176
Data 000 , 000 , 000 , 000 , 000 , 000 , 000 , 000          ' 184
Data 000 , 000 , 109 , 103 , 122 , 055 , 000 , 000          ' 192
Data 000 , 000 , 000 , 000 , 000 , 000 , 044 , 000          ' 200
Data 000 , 000 , 000 , 000 , 113 , 000 , 000 , 000          ' 208
Data 000 , 000 , 000 , 000 , 000 , 000 , 000 , 000          ' 216
Data 000 , 000 , 000 , 111 , 239 , 056 , 000 , 058          ' 224
Data 000 , 000 , 000 , 000 , 000 , 000 , 000 , 000          ' 232
Data 000 , 000 , 000 , 000 , 021 , 057 , 000 , 000          ' 240
Data 000 , 000 , 000 , 000 , 000 , 048 , 000 , 032          ' 248

Doppelzeichen:

Data 065 , 069 , 066 , 082 , 075 , 072 , 065 , 115          '
Data 000 , 000 , 000 , 000 , 000 , 000 , 000 , 000          '
Data 075 , 086 , 069 , 065 , 083 , 067 , 082 , 115          '
Data 000 , 000 , 000 , 000 , 000 , 000 , 000 , 000          '

' (
CWtab:
'CWtempo
Data Cwtempo0 , Cwtempo1 , Cwtempo2 , Cwtempo3 , Cwtempo4 , Cwtempo5

ATab:
'Abstand
Data Abstand0 , Abstand1 , Abstand2 , Abstand3
' )

$EEPROM
'Platz fr Tastaturpuffer von 0 ... 250
Data 001 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 ,
Data 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 255

'UBKorr, Paddle, CW-Ton, Vcw, Abstand
Data , 50 , 0 , 10 , 60 , 7


'Lektionen von 256 ... 511
' Start der Tabellen
Data &HF0                                                   'Lektionen + 1 ist Start der ersten Tabelle

'F1Tabelle: 5 Zeichen
'      E      I      S      H      5
Data &H01 , &H02 , &H03 , &H04 , &H05 , &HF0

'F2Tabelle: 5 Zeichen
'      T      M      O     [ch]    0
Data &H81 , &HC2 , &HE3 , &HF4 , &HFD , &HF0

'F3Tabelle: 5 Zeichen
'      A      U      V      N      D
Data &H42 , &H23 , &H14 , &H82 , &H83 , &HF0

'F4Tabelle: 5 Zeichen
'      B      G      W      L      F
Data &H84 , &HC3 , &H63 , &H44 , &H24 , &HF0

'F5Tabelle: 5 Zeichen
'      R      K      J      X      C
Data &H43 , &HA3 , &H74 , &H94 , &HA4 , &HF0

'F6Tabelle: 2 Zeichen
'      P      Q      Y      Z
Data &H64 , &HD4 , &HB4 , &HC4 , &HF0

'F7Tabelle: 2 Zeichen
'                        
Data &H54 , &HE4 , &H34 , &H4D , &HF0

'F8Tabelle: 5 Zeichen
'      1      2      3      4      5
Data &H7D , &H3D , &H1D , &H0D , &H05 , &HF0

'F9Tabelle: 5 Zeichen
'      6      7      8      9      0
Data &H85 , &HC5 , &HE5 , &HF5 , &HFD , &HF0

'F10Tabelle: 4 Zeichen
'      /      ?      .      =
Data &H95 , &H37 , &H56 , &H8D , &HF0

'F11Tabelle: 4 Zeichen
'       -      ,      ;      :
Data &H86 , &HCE , &HAF , &HE7 , &HF0

'F12Tabelle: 5 Zeichen
'     &=Ka   $=Ve   @=Eb   #=Ar   <=Sk
Data &HAD , &H15 , &H45 , &H55 , &H16 , &HF0


'SF1Tabelle
' HALLO
Data &H04 , &H42 , &H44 , &H44 , &HE3 , &HF0

'SF2Tabelle
' ZUSAMMEN,
Data &HC4 , &H23 , &H03 , &H42 , &HC2 , &HC2 , &H01 , &H82 , &HCE , &HF0

'SF3Tabelle
' HIERMIT
Data &H04 , &H02 , &H01 , &H43 , &HC2 , &H02 , &H81 , &HFF , &HF0

'SF4Tabelle
' LADE
Data &H44 , &H42 , &H83 , &H01 , &HF0

'SF5Tabelle
' ICH EUCH
Data &H02 , &HA4 , &H04 , &HFF , &H01 , &H23 , &HA4 , &H04 , &HF0

'SF6Tabelle
' AM 19.12.2007
Data &H42 , &HC2 , &HFF , &H7D , &HF5 , &H56 , &H7D , &H3D , &H56 , &H3D , &HFD , &HFD , &HC5 , &HFF , &HF0

'SF7Tabelle
' UM 19.00 UHR,
Data &H23 , &HC2 , &HFF , &H7D , &HF5 , &H56 , &HFD , &HFD , &HFF , &H23 , &H04 , &H43 , &HCE , &HF0

'SF8Tabelle
' IN DEN GARMISCHER HOF,
Data &H02 , &H82 , &HFF , &H83 , &H01 , &H82 , &HFF , &HC3 , &H42 , &H43 , &HC2 , &H02 , &H03 , &HA4 , &H04 , &H01 , &H43 , &HFF , &H04 , &HE3 , &H24 , &HCE , &HF0

'SF9Tabelle
' MUENCHEN,
Data &HC2 , &H23 , &H01 , &H82 , &HA4 , &H04 , &H01 , &H82 , &HCE , &HF0

'SF10Tabelle
' HINTERBAERENBADSTR.
Data &H04 , &H02 , &H82 , &H81 , &H01 , &H43 , &H84 , &H42 , &H01 , &H43 , &H01 , &H82 , &H84 , &H42 , &H83 , &H03 , &H81 , &H43 , &H56 , &HF0

'SF11Tabelle
' ZU EINER
Data &HC4 , &H23 , &HFF , &H01 , &H02 , &H82 , &H01 , &H43 , &HF0 ,

'SF12Tabelle
' VORSTANDSBESPRECHUNG EIN.
Data &H14 , &HE3 , &H43 , &H03 , &H81 , &H42 , &H82 , &H83 , &H03 , &H84 , &H01 , &H03 , &H64 , &H43 , &H01 , &HA4 , &H04 , &H23 , &H82 , &HC3 , &HFF , &H01 , &H02 , &H82 , &H56 , &HF0

'EndeTabellen:
Data &H00