'FCAntAna_Tiny.BAS:         Frequenzzhler fr Antennen-Analyzer
'                           1MHz...40MHz mit 8x2 LCD-Anzeige
'                           Vorteilung 1/32, fest eingestellt
'Hardware:                  ATtiny2313 mit 3,2768MHz-Quarz
'                           T1/PD5: Signaleingang vom Vorteiler HC4069
'                           LCD-Anzeige an PortB, Pin-Belegung siehe unten
'Entwickler:                Reinhard Hergert, DJ1MHR
'Letzte nderung:           04.02.2004  (DD.MM.YYYY)
'
'                           26.09.06: Fr ATtiny2313 mit BASCOM-AVR 11.7.7 compiliert
'                           Fusebit C: Divide Clock by 8: disabled
'                           Fusebit A987: 1111.1111 External XTAL
'                           Take care that the chip supports all fuse bytes.
'-------------------------------------------------------------------------------
'Funktion:

'Das Eingangssignal wird ber einen Vorteiler an den Timer1-Eingang des AVR
'gegeben. Der 16-Bit-Timer1 arbeitet bei geffnetem Tor als Counter.
'Die Eingangsfrequenz wird mit einem 32-Bit-Integer gezhlt. Bei jedem
'Timer1-berlauf wird das HighWord um 1 erhht. Nach Schlieen des Tores
'wird dann noch der aktuelle Inhalt von Timer1 als LowWord hinzuaddiert.
'
'Mit dem 8-Bit-Timer0 wird die Torzeit gesteuert. Die Torzeit wird durch den
'Timer0-Prescale Faktor, die Timer0-Einstellung und die Anzahl der
'Timer0-berlufe bestimmt. Mit diesen drei Gren ist der Zhler in weiten
'Grenzen konfigurierbar und kann auf fast jede Quarzfrequenz eingestellt werden.
'
'   Bei der Wahl der Quarzfrequenz sind folgende Kriterien zu beachten:

'1. Die Taktfrequenz mu mindesten so hoch sein, da die um den Faktor des
'   Vorteilers geteilte maximale Eingangsfrequenz kleiner als die halbe
'   Quarzfrequenz ist.
'   Wenn der Timer1 mit einem externen Signal getaktet wird (Zhlerbetrieb),
'   dann mu JEDE der beiden Halbwellen mindestens so lang sein wie eine
'   Periodendauer des AVR-Takts.
'   Zu Gunsten eines geringen Stromverbrauchs sollte dieser Wert nicht
'   wesentlich berschritten werden, sofern nicht der Zeitbedarf fr andere
'   rechenintensive Routinen zu gro wird.
'2. Um einen Dezimalwert als Ergebnis zu erhalten, mu die reale Torzeit
'   "dezimal lang" sein, also z.B. 1sec, 1/10sec, 1/100sec, denn eine normale
'   Divisions-Operation ist im AVR nicht implementiert und mte aufwndig
'   durch eine Software-Division gelst werden. Was aber sehr einfach geht, ist
'   die Division und Multiplikation durch/mal 2,4,8,16,32,64 (...), denn diese
'   kann durch einfaches Shiften des Werts nach rechts/links erledigt werden.
'   Damit sind also auch Torzeiten wie z.B. 1/2 oder 1/64 Sekunde mglich.
'   Die Dezimalkommastelle darf im Integer-Ergebnis verschoben sein, denn das
'   kann man im Nachhinein im Ergebnis-String korrigieren.
'   Aufgrund des Vorteilers ist die absolute Torzeit um dessen Teilerfaktor
'   grer als die reale Torzeit zu einzustellen.

'Fr den Zhler im Antennen-Analyzer, der von 1MHz bis ca 40MHz arbeiten soll,
'wurden folgende Werte ausgewhlt:
'Das Eingangssignal wird mit einen HC4060 durch 32 vorgeteilt und direkt an den
'Timer1-Eingang des AVR gegeben. Der HC4060 arbeitet von DC bis ca. 40MHz
' (laut Datenblatt ca. 25MHz) und kann 1/2^4 bis 1/2^14 teilen.
'Dadurch erhlt der AVR eine maximale Eingangsfrequenz von 1,25MHz.
'Die Quarzfrequenz mu also mindesten 2,5MHz betragen.
'Um umstndliche Umrechnungen zu vermeiden wurde eine Quarzfrequenz
'von 3,2768MHz (billige Massenware) gewhlt.
'Damit kann eine Torzeit von 1/(3,2768*1024*256*4)=320ms realisiert werden.
'Das Display wir als ca. 3 mal pro Sekunde aktualisiert.
'Die reale Torzeit ist um den Teilerfaktor des Vorteilers niedriger, also 10ms.
'Die Messung wird demzufolge auf 100Hz genau durchgefhrt ohne da das
'Meergebnis umgerechnet werden mte. Bei der Anzeige wird allerdings zu
'Gunsten einer stabileren Darstellung auf die Ausgabe der letzten Stelle
'verzichtet, soda auf 1KHz genau abgelesen werden kann.
'
'-------------------------------------------------------------------------------
'Hardware: 8x2 LCD-Anzeige mit HD4478-kompatibler Schnittstelle z.B. AV0820
'          LCD-Verbindungen:
'          LCD01 an Masse (VSS)
'          LCD02 an +5V   (VDD)
'          LCD03 an Poti  (V0)
'          LCD04 an PB6   (RS)
'          LCD05 an PB5   (R/W)  --> wird permanent auf Masse (0V) gelegt
'          LCD06 an PB4   (E)
'          LCD11 an PB3   (DB4)
'          LCD12 an PB2   (DB5)
'          LCD13 an PB1   (DB6)
'          LCD14 an PB0   (DB7)
'Der RW-Eingang der LCD-Anzeige (steuert die Datenrichtung) wird von Bascom
'nicht verwendet, er kann durch den PortB.5, oder fest auf Masse gelegt werden.
'
'-------------------------------------------------------------------------------
$regfile = "ATtiny2313.dat"
$crystal = 3276800                           'Quarz: 3,276.800MHz
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Dim Lcount As Long At &H60                   'Zhler-Variable
Dim Wcountlo As Word At &H60 Overlay         'LoWord der Zhlervariablen
Dim Wcounthi As Word At &H62 Overlay         'HiWord der Zhlervariablen
Dim Sresult As String * 16 At &H64           'Ausgabestring
Dim Result(16) As Byte At &H64 Overlay       'Ausgabestring als Byte-Array
Dim Stempcount As String * 10 At &H75        'Mu Len(Str(&HFFFFFFFF)) lang sein
Dim Tempcount(10) As Byte At &H75 Overlay    'Temp-String als Byte-Array
Dim Timer0set As Byte                        'Timer0-Einstellung, wenn < 256
Dim I As Byte                                'Zhlvariable fr Ausgabe
Dim Gatecnt As Byte                          'Anzahl Timer0-Durchlufe
'
Ddrd = &B00000000                            'PortD alles Input
Portd = &B11011111                           'Alle PullUps, auer PD5, aktiviert
                                                  'PD5/T1 auf Eingang setzen (Zhler-Eingang)
                                                  'PD3/INT1 auf Eingang setzen (Vorteiler Wahl)

                                                  'Timer0 (Torzeit) und Timer1 (Zhler) konfigurieren:
On Timer0 Ongatetime                         'Interrupt-Routine fr die Torzeit
On Timer1 Oncounteroverflow                  'Interrupt-Routine frs HiWord des Zhlerstands
Config Timer0 = Timer , Prescale = 1024      'Torzeit-Timer mit Takt/1024
'Config Timer0 = Timer , Prescale = 256            'Torzeit-Timer mit Takt/256
'Config Timer0 = Timer , Prescale = 64             'Torzeit-Timer mit Takt/64
'Config Timer0 = Timer , Prescale = 8              'Torzeit-Timer mit Takt/8

'Timer0Set = 256-XXX                               'nur bei XXX<256 erforderlich

'Torzeit=1/(Quarzfrequenz*Prescale*XXX*GateCnt)=1/(3276800*1024*256*4)=320ms

Config Timer1 = Counter , Edge = Rising      'Zhler an steigender Signalflanke

'LCD-Anzeige konfigurieren:
Config Lcd = 16 * 2                          'Wir haben ein LCD-Display mit 16 Zeichen in 2 Zeilen

Config Lcdpin = Pin , Db4 = Portb.3 , Db5 = Portb.2 , Db6 = Portb.1 , Db7 = Portb.0 , E = Portb.4 , Rs = Portb.6

Ddrb.5 = 1                                   'PB5 auf Ausgang setzen (gibt 0 Volt an LCD-Anschlu R/W aus)
Portb.5 = 0                                  'Pin PB5 auf LOW setzen (mu permanent 0 Volt fhren!)
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Cursor Off                                   'LCD-Kursor ausschalten
'Begrungstext auf der LCD ausgeben :
Home Upper
Lcd "Antennen"
Home Lower
Lcd "Analyzer"
Waitms 1500
Home Upper
For I = 1 To 8                               'Ansteigender Balken
  Lcd Chr(255)                               'Schwarzes Karo
  Waitms 30
Next I
Home Lower
For I = 1 To 8                               'Ansteigender Balken
  Lcd Chr(255)                               'Schwarzes Karo
  Waitms 30
Next I
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Enable Timer0                                'Timer0-Interrupts ein (Torzeit)
Enable Interrupts                            'Interrupts global einschalten
Start Timer0

Main:
Goto Main
'-------------------------------------------------------------------------------
Ongatetime:                                  'Timer0-Torzeit beendet
  If Gatecnt = 0 Then                        'Zhler starten
    Enable Counter1                          'Zhler-Overflow-Interrupts einschalten
    Start Counter1
    'Timer0 = Timer0Set                            'nur bei XXX<256 erforderlich
    Gatecnt = 1
  Elseif Gatecnt < 4 Then                    '4 Timer0-Umlufe warten
    Incr Gatecnt
  Else                                       'Tor zumachen, Zhler auslesen
    Stop Counter1
    Disable Counter1                         'Zhler-Overflow-Interrupts ausschalten
    Wcountlo = Counter1                      'LoWord in die LONG-Zhlervariable holen
    Counter1 = 0                             'Zhler zurcksetzen (Voreinstellen geht hier auch!)
    Gatecnt = 0
    '
    'Jetzt mu der aktuelle Zhlerstand, die Torzeit und die Vorteilung
    'zum echten dezimalen Zhlerstand umgerechnet werden:
    'Bei 0,32s Torzeit und Vorteilung 1/32 mu hier nichts gmacht werden.

    'PortD.6 =0 schaltet die Umrechnung bei abgeschaltetem Vorteiler ein:

    If Pind.6 = 0 Then
     Shift Lcount , Right , 5                'lCount=lCount/32 (ohne Vorteiler)
    End If
     '16 Zeichen langen String mit Hilfe des Overlay-Felds formatieren:
    'Bei einem 8-stelligen Display werden nur 8 Zeichen bentigt

    Sresult = Space(16)                      'Alle Stellen mit Leerzeichen vorbelegen
    Result(14) = &H7A                        '"K"
    Result(13) = &H48                        '"H"
    Result(12) = &H4B                        '"z"
    Result(11) = &H20                        'Leerzeichen

    Stempcount = Str(lcount)                 'Wert in String umwandeln

    I = Len(stempcount)                      'Aktuelle Position im Quell-String
    Decr I                                   '100Hz Position verwerfen
    If I < 1 Then Goto Donestring
    Result(7) = Tempcount(i) : Decr I        '1KHz Position auf Stelle 7
    If I < 1 Then Goto Donestring
    Result(6) = Tempcount(i) : Decr I        '10KHz Position auf Stelle 6
    If I < 1 Then Goto Donestring
    Result(5) = Tempcount(i) : Decr I        '100KHz Position auf Stelle 5
    If I < 1 Then Goto Donestring
    Result(4) = &H2E                         'ASC(&H2E)="." auf Stelle 4
    Result(3) = Tempcount(i) : Decr I        '1MHz Position auf Stelle 3
    If I < 1 Then Goto Donestring
    Result(2) = Tempcount(i) : Decr I        '10MHz Position auf Stelle 2
    If I < 1 Then Goto Donestring
    Result(1) = Tempcount(i) : Decr I        '100MHz Position auf Stelle 1
    If I < 1 Then Goto Donestring
    Donestring:
    '
    Lcount = 0                               'Zhler-Variable zurcksetzen
    Home Upper                               'In die obere LCD-Zeile gehen
    Lcd Sresult                              'Exakt 16 Zeichen lang
    Home Lower                               'In die untere LCD-Zeile gehen
    Lcd "MHz.KHz "                           'Exakt 8 Zeichen lang
    '
    'Fr die LCD-Anzeige ist inzwischen SEHR viel Zeit vergangen. Inzwischen
    'eingetroffene Timer-Interruptanforderungen sind daher lngst veraltet und
    'wrden falsche Zhlerstnde liefern. Deshalb mssen eventuell vorhandene
    'Interruptanforderungen gelscht werden:

    Tifr.tov0 = 1                            'Timer0-Overflow-Flag lschen
    Tifr.tov1 = 1                            'Timer1-Overflow-Flag lschen

  End If
Return
'-------------------------------------------------------------------------------
Oncounteroverflow:
  Incr Wcounthi                              'HiWord der Zhlervariablen erhhen (lCount=lCount+65536)
Return
'-------------------------------------------------------------------------------