'P80V2AFC_E06.BAS: Kanalspeicher und AFC fr 80 m PeilerV2 mit ATMega8
'
'
'Historie:
'
'
'01: 18.12.07  Dateibernahme von AFC80mB16R2.BAS
'              Erste Grundversion zum prinzipiellen Test, Variante A Rechtshnder (BT1)
'    14.01.08  Einfhrung der Variante B fr Linkshnder (BT2), Variante C = BT3
'              S-Metertabelle in dB Schritten ausgemessen und programmiert
'    24.02.08  Kalibrierroutine in die Hauptschleife verlegt,
'              ermglicht Frequenzregelung bei der Kalibrierung
'    13.03.08  Anzeige der Laufzeit zusammen UBatt bei max Dmpfung (Pot Linksanschlag)
'    27.03.08  S-Meteranzeige bei UP/DN aktiviert
'    04.04.08  Kleinere Fehler beseitigt und Korrekturen vorgenommen
'              SW-Stand mit Peiler 32 an DF9NX abgegeben.
'              BattChgOpt Comilerdirektive eingebaut, nicht ntig da zwei Batterien vorhanden.
'
'    07.04.08: Gnzliche Abschaltung der Regelung mit VRBufLen = 0
'              Zyklische Vernderung der Programmierwerte <0 -> max
'
'02: 16.07.08: Peiler #35 bis 40 erfat. UR-Regler in 25*9 Einheiten geteilt.
'              Verschiedene Parameter (Offset) Peilerindividuell speicherbar.
'              Verstrkung und Begrenzung aus S-MeterTabelle entfernt
'              Calibrierung in dBm Einheiten, Anzeige Attennuation in dB
'
'03: 02.08.08: Feinabgleich fr Entfernungsanzeige ber S-Meter Verschiebung
'              (-3..0..+3) in 1dB Schritten eingebaut
'              Optionale Displayabschaltung ausgebaut
'              Text-Variablen neu nummeriert, auskommentierten Code entfernt
'              Mute bei Beep aktiviert
'
'04: 28.09.08: Compiler-Switch fr Dmpfungsumschaltung ber FET-Vorstufe eingebaut
'
'05: 15.10.08: Code ergnzt fr Variante 4, alte Hardware (Peiler 17 bis 20)
'              Peiler 17 (Y2 von DC1HR) auf Variante 4 umgebaut.
'
'06: 16.11.08: Automatische Aufwrtsregelung ber VRBufLen Einstellung abschaltbar.
'              Geradzahliges VRBufLen mit Aufwrtsregelung
'              Ungeradzahliges VRBufLen ohne Aufwrtsregelung
'              VRBufLen Einstellung und SMetRP auf 0 bis 30 gendert
'              Fehler im Calibriermode bei Peiler 20 beseitigt
'              Beep im Calibriermode ganz abgeschaltet dafr
'              S-Meter Balken  aktiviert
'              Wechselnde Anzeige zwischen PE- und UR-Anzeige
'
'              Flash: P#20: 8118 dec, 99%
'-------------------------------------------------------------------------------
'Portbelegung: Variante A: Display DIPS0802 und ATMega8 in SMD, Rechtshnder
'Hardware:     Stromlauf P80V2BT1.dsn

'              PortB: LCD Daten, PWR/SB-Taste und PWM out
'
'              PortB.0 = Eingang fr SB-Taste
'              PortB.1 = LCD DB4
'              PortB.2 = LCD DB5
'              PortB.3 = Gain PWM-Out
'              PortB.4 = LCD DB6
'              PortB.5 = LCD DB7
'              PortB.6 = bei externem Quarz nicht verfbar
'              PortB.7 = bei externem Quarz nicht verfbar
'
'              PortC: Control I/O und AD-Wandler Inputs
'
'              PortC.0 = Tne, Output
'              PortC.1 = BA-Taste, Input mit Pullup
'              PortC.2 = USmet (ADC2), analog Input ohne Pullup
'              PortC.3 = Att, Output
'              PortC.4 = BAout, Output
'              PortC.5 = Fcont, Input/Output ohne Pullup wird vom Programm gesteuert
'              PortC.6 = UBatt in (ADC6), analog Input ohne Pullup
'              PortC.7 = UReg in (ADC7), analog Input ohne Pullup
'
'              PortD: Control I/O und LCD Control:
'
'              PortD.0 = LCD RS, Output
'              PortD.1 = LCD E, Output
'              PortD.2/INT0 = Mute, Output
'              PortD.3/INT1 = DN, Input mit Pullup
'              PortD.4 = UP, Input mit Pullup
'              PortD.5/T1 = Fin, Input ohne Pullup
'              PortD.6 = Kanal 2, Input mit Pullup
'              PortD.7 = Kanal 1, Input mit Pullup
'
'              Sonstige:
'              Aref: AVCC
'
'Portbelegung: Variante B: Display DIPS0802 und ATMega8 in SMD, Linkshnder
'Hardware:     Stromlauf P80V2BT2.dsn
'
'              PortB: LCD Daten, PWR/SB-Taste und PWM out
'
'              PortB.0 = Eingang fr SB-Taste
'              PortB.1 = LCD RS, Output
'              PortB.2 = Tne, Output
'              PortB.3 = Gain PWM-Out
'              PortB.4 = LCD E, Output
'              PortB.5 = BA-Taste, Input mit Pullup
'              PortB.6 = bei externem Quarz nicht verfbar
'              PortB.7 = bei externem Quarz nicht verfbar
'
'              PortC: Control I/O und AD-Wandler Inputs
'
'              PortC.0 = USmet (ADC2), analog Input ohne Pullup
'              PortC.1 = Att, Output
'              PortC.2 = DN, Input mit Pullup
'              PortC.3 = UP, Input mit Pullup
'              PortC.4 = BAout, Output
'              PortC.5 = Fcont, Input/Output ohne Pullup wird vom Programm gesteuert
'              PortC.6 = UBatt in (ADC6), analog Input ohne Pullup
'              PortC.7 = UReg in (ADC7), analog Input ohne Pullup
'
'              PortD: Control I/O und LCD Control:
'
'              PortD.0 = LCD DB4
'              PortD.1 = LCD DB5
'              PortD.2 = LCD DB6
'              PortD.3 = LCD DB7
'              PortD.4 = Mute, Output
'              PortD.5/T1 = Fin, Input ohne Pullup
'              PortD.6 = Kanal 2, Input mit Pullup
'              PortD.7 = Kanal 1, Input mit Pullup
'
'              Sonstige:
'              Aref: AVCC
'
'Portbelegung: Variante C: Display aMC0802C und ATMega8 im DIP Gehuse
'Hardware:     Stromlauf P80V2BT3.dsn, nach DF1FO
'
'              PortB: Control I/O und PWM out
'
'              PortB.0 = Rotary UP, Input mit Pullup
'              PortB.1 = Rotary DN, Input mit Pullup
'              PortB.2 = Fcont, Input/Output ohne Pullup wird vom Programm gesteuert
'              PortB.3 = Tne oder Gain PWM-Out, Output
'              PortB.4 = Rotary Butt, Input mit Pullup
'              PortB.5 = Att, Output
'              PortB.6 = bei externem Quarz nicht verfbar
'              PortB.7 = bei externem Quarz nicht verfbar
'
'              PortC: Control I/O und AD-Wandler Inputs
'
'              PortC.0 = USmet in (ADC0), analog Input ohne Pullup
'              PortC.1 = UReg in (ADC1), analog Input ohne Pullup
'              PortC.2 = UBatt in (ADC2), analog Input ohne Pullup
'              PortC.3 = Spare
'              PortC.4 = Mute, Output
'              PortC.5 = LCD E, Output
'              PortC.6 = n. v.
'              PortC.7 = n. v.
'
'              PortD: Control I/O und LCD
'
'              PortD.0 = LCD DB4, Output
'              PortD.1 = LCD DB5, Output
'              PortD.2/INT0 = LCD DB6, Output
'              PortD.3/INT1 = LCD DB7, Output
'              PortD.4 = LCD RS, Output
'              PortD.5/T1 = Fin, Input ohne Pullup
'              PortD.6 = alternativ Tne bei PWM
'              PortD.7 = Menue, Output
'
'              Sonstige:
'              Aref: AVCC
'
'Portbelegung: Variante D: Display DIPS0802 und ATMega8 in SMD, Rechtshnder
'Alte Hardware:Stromlauf ???.dsn

'              PortB: LCD Daten, PWR und PWM out

'              PortB.0 = LCD Power, LCD Ein bei PortB.0 = PortB.1 = 1
'              PortB.1 = Db5
'              PortB.2 = Db4
'              PortB.3 = Gain PWM-Out
'              PortB.4 = Db6
'              PortB.5 = Db7
'              PortB.6 = bei externem Quarz nicht verfbar
'              PortB.7 = bei externem Quarz nicht verfbar
'
'              PortC Control I/O und AD-Wandler Inputs
'
'              PortC.0 = Kanal 1,  Input mit Pullup
'              PortC.1 = Kanal 2,  Input mit Pullup
'              PortC.2 = UReg in (ADC2), analog Input ohne Pullup
'              PortC.3 = DN, Input mit Pullup
'              PortC.4 = UP, Input mit Pullup
'              PortC.5 = BAout, Output
'              PortC.6 = UBatt-Eingang (ADC5), Input ohne Pullup
'              PortC.7 = USmet (ADC7), analog Input ohne Pullup
'
'
'              PortD Control I/O:
'
'              PortD.0 = Fcont, Input/Output ohne Pullup wird vom Programm gesteuert
'              PortD.1 = n.nutzbar, da mit PD5 verbunden
'              PortD.2/INT0 = BA-Taste, Input mit Pullup
'              PortD.3/INT1 = LT-Test
'              PortD.4 = Beep und Gain-Control, Output
'              PortD.5/T1 = Fin,   Input ohne Pullup
'              PortD.6 = E, Output
'              PortD.7 = Rs, Output
'
'              Sonstige:
'              Aref: AVCC
'
'-------------------------------------------------------------------------------
'bersicht der Portbelegungs fr die verschiedenen Varianten
'
'  A: Display DIPS0802 und ATMega8 im SMD Gehuse Rechtshnder
'  B: Display DIPS0802 und ATMega8 im SMD Gehuse Linkshnder
'  C: Display aMC0802C und ATMega8 im DIP Gehuse
'  D: Display DIPS0802 und ATMega8 im SMD Gehuse Alte Hardware
'
'  Port  |    A     |    B     |    C     |    D     |    E     |    F     |
' -------------------------------------------------------------------------|
'  PB0   | SB in    | SB in    | RotaryUP | LCD Power|          |          |
'  PB1   | LCD DB4  | LCD RS   | RotaryDN | LCD DB5  |          |          |
'  PB2   | LCD DB5  | Ton out  | Fcont    | LCD DB4  |          |          |
'  PB3   | PWM-Out  | PWM-Out  | Ton/PWM  | PWM-Out  |          |          |
'  PB4   | LCD DB6  | LCD E    | Rot.Butt | LCD DB6  |          |          |
'  PB5   | LCD DB7  | BA-Taste | Att.     | LCD DB7  |          |          |
'  PB6   |  n. v.   |  n. v.   |  n. v.   |  n. v.   |  n. v.   |  n. v.   |
'  PB7   |  n. v.   |  n. v.   |  n. v.   |  n. v.   |  n. v.   |  n. v.   |
' -------------------------------------------------------------------------|
'  PC0   | Ton out  | USmet in | USmet in | K1-Taste |          |          |
'  PC1   | BA-Taste | Att out  | UReg in  | K2-Taste |          |          |
'  PC2   | USmet in | Down in  | UBatt in | UReg in  |          |          |
'  PC3   | Att out  | Up in    | Spare    | Down     |          |          |
'  PC4   | BA out   | BA out   | Mute out | Up       |          |          |
'  PC5   | Fcont out| Fcont out| LCD E    | BAout    |          |          |
'  PC6   | UBatt in | UBatt in |  n. v.   | UBat in  |          |          |
'  PC7   | UReg in  | UReg in  |  n. v.   | USmet in |          |          |
' -------------------------------------------------------------------------|
'  PD0   | LCD RS   | LCD DB4  | LCD DB4  | Fcont    |          |          |
'  PD1   | LCD E    | LCD DB5  | LCD DB5  | n.nutzbar|          |          |
'  PD2   | Mute out | LCD DB6  | LCD DB6  | BA-Taste |          |          |
'  PD3   | Down in  | LCD DB7  | LCD DB7  | LZ-Test  |          |          |
'  PD4   | Up in    | Mute out | LCD RS   | Beep/GC  |          |          |
'  PD5   | T1 = Fin | T1 = Fin | T1 = Fin | T1 = Fin |          |          |
'  PD6   | K2-Taste | K2-Taste | alt.Ton  | LCD E    |          |          |
'  PD7   | K1-Taste | K1-Taste | Menue    | LCD Rs   |          |          |
' --------------------------------------------------------------------------
'
'-------------------------------------------------------------------------------
'Funktionsbeschreibung AFC mit ATMega8:
'
'Referenzfrequenz wird abgeleitet vom Prozessorquarz
'mit TIMER0 als Referenzteiler (Prescaler 256)
'6,553600 MHz / 256*256 = 100 Hz, kleinstes Frequenzraster
'
'TIMER1 ist der Hauptteiler
'Eingang vom VCO (Fin) PD5/T1
'
'===============================================================================
' Compiler Direktiven fr Peilernummern, Hardwareunterschiede werden automatisch eingestellt
'
  Const Peiler = 40
  Const VStr = "E06"
'
'===============================================================================
' Compiler Direktiven fr die folgenden 3 Hardware Varianten
'
' CONST Variante = 1    A: Display DIPS0802 und ATMega8 im SMD Gehuse, Rechtshnder
' CONST Variante = 2    B: Display DIPS0802 und ATMega8 im SMD Gehuse, Linkshnder
' CONST Variante = 3    C: Display aMC0802C und ATMega8 im DIP Gehuse
' CONST Variante = 4    D: Wie Variante A aber alte Hardware fr Peiler 16 bis 20
'
'===============================================================================
#if Peiler = 40                              '***
  Const PStr = "P#40:"                       'Peiler Nummer
  Const CallStr = " DJ1MHR "                 'Call 8-stellig
  Const Variante = 1                         'Rechtshnder
  Const BFOFreq = 4513                       'BFO Frequenz
  Const FNFmax = 800                         'FNFmax = 800 Hz
  Const RXTyp = 2                            'RX mit TCA440
  Const FETVST = 0                           'Keine FET-Vorstufe vorhanden
  Const URegAnz = 4                          'URAnz 0=Aus, 1=dB, 2...17=30W...1uW
  Const UBatKor = 156                        'Korrekturwert fr UB-Anzeige 128 > 0
#endif

  Const PVStr = PStr + VStr
  Const Offset = BFOFreq + FNFmax / 100      'ZF Offset fr fNFmax
  Const OffsetHi = Int(Offset / 256)
  Const OffsetLo = Offset - OffsetHi * 256
  Const URdiv = 10
  Const URdiv1 = URdiv - 1

#if Peiler > 20
  Const FRPol = 0                            'FRPol 0, fr Diode gg.  0V
#else
  Const FrPol = 1                            'FRPol 1, fr Diode gg. +5V
#endif

  '===============================================================================
' Compiler Direktiven fr die folgenden Software Optionen
'
' Const URAnzeige = 0                        'Keine UR-Anzeige
' Const URAnzeige = 1                         'Dmpfungsanzeige anhand UR
  Const URAnzeige = 2                        'Entfernungsabschtzung anhand UR
'
' Const AlertPer = 0                         'Fuchslaufzeit fest auf 60 Sekunden
' Const AlertPer = 1                         'Einstellen der Fuchslaufzeit Sekunden
  Const AlertPer = 2                         'Einstellen der Fuchslaufzeit 100stel Sekunden

' CONST FoxMem = 0                           'Kein Zwischenzeitspeicher
  CONST FoxMem = 1                           'Mit Zwischenzeitspeicher

  CONST BattChgOpt = 0                       'Keine Rckspeicherung der Laufzeit bei Batteriewechsel
' CONST BattChgOpt = 1                       'Rckspeicherung der Laufzeit bei Batteriewechsel

  Const UbBer = 1                            'Batterieanzeigebereich 1: bis 10,23V
' Const UbBer = 2                             'Batterieanzeigebereich 2: bis 20,46V

' CONST UPDNButt = 0                         'Up/Down Buttons deaktiviert
  CONST UPDNButt = 1                         'Up/Down Buttons aktiv

' Const TxPAdj = 0                           'Keine TX-Power Feineinstellung
  Const TxPAdj = 1                           'Mit TX-Power Feineinstellung
'
  Const DspBlink = 0                         'Kein blinkendes Display
' Const DSPBlink = 1                          'Blinkendes Display bei UReg ca. 400mV
'
  CONST LowGain = 90                         'Umschaltung auf Low Gain bei LowGain db
  Const LowGainPTR = 130 + LowGain

'===============================================================================
' Compiler Direktiven fr Debug Hilfe
'
  Const DebugMode = 0                        'Keine Debug Hilfe
' Const DebugMode = 1                            'Nur Ausgabe der Tastenwerte
' Const DebugMode = 2                             'Debug Hilfen durch 2 LCD Ausgaben von TmpVar
'
  Const MinSW = 0
' Const MinSW = 1                            'Minimal Software ohne div Features
'
'===============================================================================
  Const Option1 = 0
  Const Anordnung = 0
  Const BAInv = 0
  Const GainContr = 1

  Const HWConf = Variante * 64 + Option1 * 16 + Anordnung * 8 + BAInv * 4 + FRPol * 2 + GainContr
  Const SWConf = URAnzeige * 64 + AlertPer * 16 + FoxMem * 8 + BattChgOpt * 4 + UbBer * 2 + UPDNButt
'===============================================================================
'Bedeutung der Werte der Mode-Kennung MODUS:
'  0 = Einstellmode
'  1 = Wettkampfmode
'  3 = Kanaltestmode im Einstellmode (temporr)
'  4 = ProgMode: Fuchstimer synchronisieren
'  6 = ProgMode: URAnzeige bzw. Einstellung der TX-Leistung  mit URAnzeige > 0 aktiviert
'  8 = ProgMode: Tx-Power Korrektur in 1dB Schritten
' 10 = ProgMode: Zeitpunkt des Warntones
' 12 = ProgMode: Fuchslaufzeit Sec mit CompSwitch AlertPer > 1 aktiviert
' 14 = ProgMode: Fuchslaufzeit 1/100 Sec mit CompSwitch AlertPer = 2 aktiviert
' 16 = ProgMode: Anzahl Fchse
' 18 = ProgMode: Calibrierung der Batteriespannungsanzeige
' 20 = ProgMode: VR-Pufferlnge einstellen 0 = Regelung Aus
' 22 = ProgMode: Offset
' 24 = Wechsel nach Mode 1
' 32 = Auswertemode
' 64 = Abschaltemode
' 66 = Betriebsminuten Anzeige
'===============================================================================
'Fuses
'$PROG &HFF , &HEF , &HD9 , &H00
'Code: 8110 Byte, 98%, compiliert mit Bascom V  7.8
'===============================================================================
$regfile = "m8def.dat"                       'ATMega8
$crystal = 6553600                           '6,55360 MHz-Quarz

'EEPROM Tabellen Zeiger:
Const FoxTab = 32                            'Start der Fuchszeitentabelle
Const KanTab = 92                            'Start der Kanaltabelle - 2
Const SMtTab = 106                           'Start der S-Meter-Tabelle
Const TxPTab = 122                           'Start der Tx-Power Tabelle
'Const DstTab = 131                           'Start der Entfernungs-Tabelle

'Overlay Variablen fr FrequenzAusgabe

Dim Count As Long At &H60                    'Zhler-Variable
Dim CountLo As Word At &H60 Overlay          'LoWord der Zhlervariablen
Dim CountHi As Word At &H62 Overlay          'HiWord der Zhlervariablen
Dim Ausgabe As String * 8 At &H64            'Ausgabestring
Dim AusgH As String * 6 At &H66 Overlay      'Gesamtstring Frequenz fr Ausgabe
Dim Komma As Byte At &H67 Overlay            'Komma bei FrequenzAusgabe
Dim AusgL As String * 4 At &H68 Overlay      'KHz Teil der Frequenz fr Ausgabe
Dim Fill1(3) As Byte                         'freihalten der Ramzellen bis 6F
Dim CntStr As String * 8 At &H70             'Mu mindestens Len(Str(&HFFFF)) lang sein
Dim FreqH As String * 1 At &H70 Overlay      'Frequenzteil MHz
Dim FreqL As String * 4 At &H71 Overlay      'Frequenzteil KHz
Dim UBTxt As String * 6 AT &H79              'UBatt String fr UB-Ausgabe
Dim UBTxt3 As String * 2 AT &H7A Overlay     'UBatt-Right$ bei 3 Stellen
Dim UBTxt4 As String * 2 AT &H7B Overlay     'UBatt-Right$ bei 4 Stellen
Dim EoStr3 As Byte At &H7A Overlay           'Ende Left$, bei 3 Stellen
Dim EoStr4 As Byte At &H7B Overlay           'Ende Left$, bei 4 Stellen

'EEPROM Variablen

Dim Spare(12) As Byte At &H80                'unbenutzt ehemals Kanal Daten
Dim ZFOffset As Word At &H8C                 'ZF Offset
Dim VRBufLen As Byte At &H8E                 'S-Meter Pufferlnge
Dim URAnz As Byte At &H8F                    'Flag fr Regelspannungsanzeige
Dim UBKor As Byte At &H90                    'Korrekturwert fr UB-Anzeige
Dim FoxPerSec As Byte At &H91                'Fuchslaufzeit Sekunden
Dim FoxPer100 As Byte At &H92                'Fuchslaufzeit/100 Sekunden
Dim AlertTime As Byte At &H93                'Default Sekunden-Wert fr Warnzeitpunkt
Dim NoFoxes As Byte At &H94                  'Anzahl Fchse fr Fuchstimer
Dim Bmin As Word At &H95                     'Betriebsminuten
Dim SpW1 As Word At &H97                     'SpareWord1
Dim SpW2 As Word At &H99                     'SpareWord2
Dim ManUhrSt As Byte At &H9B                 'Manueller Uhr Start
Dim TxPKor As Byte At &H9C                   'Tx-Power Korrektur -3..+3
Dim SpB3 As Byte At &H9D                     'SpareByte3
Dim SpB2 As Byte At &H9E                     'SpareByte2
Dim SpB1 As Byte At &H9F                     'SpareByte1
Dim EprDat(31) As Byte At &H81 Overlay       'EEPROM Daten als Byte-Array

'Rambereich fr Stringdaten zwischen &H100 und &H1FF, 256 Byte EEPROM Daten

Dim Vers As String * 8 At &H100              'Version: Data "P#xx:Exx"
Dim Logo As String * 8 At &H109              'Logo:    Data "ARDF 80m"
Dim RufZ As String * 8 At &H112              'Rufz.:   Data " DJ1MHR "
Dim Txt01 As String * 8 At &H11B             'Txt01:   Data "KeinSMet"
Dim Txt02 As String * 6 At &H124             'Txt02:   Data "N-Fox:"
Dim Txt02a As String * 5 At &H125 Overlay    'Txt02a: Data "-Fox:"
Dim Txt03 As String * 8 At &H12B             'Txt03:   Data "Cal-SMet"
Dim Txt04 As String * 5 At &H134             'Txt04:   Data "CalUB"
Dim Txt04a As String * 2 At &H137 Overlay    'Txt04a: Data "UB"
Dim Txt05 As String * 2 At &H13A             'Txt05:   Data "V "
Dim Txt06 As String * 8 At &H13D             'Txt06:   Data "  UHR   "
Dim Txt07 As String * 8 At &H146             'Txt07:   Data "STP  RES"
Dim Txt08 As String * 8 At &H14F             'Txt08:   Data " - SP + "
Dim Txt09 As String * 8 At &H158             'Txt09:   Data "Betrieb:"
Dim Txt10 As String * 8 At &H161             'Txt10:   Data "LowBatt!"
Dim Txt11 As String * 6 At &H16A             'Txt11:   Data "SetFox"
Dim Txt11a As String * 3 At &H16D Overlay    'Txt11a: Data "Fox"
Dim Txt12 As String * 2 At &H171             'Txt12:   Data ",>"
Dim Txt13 As String * 8 At &H174             'Txt13:   Data "manuell!"
Dim Txt14 As String * 11 At &H17D            'Txt14:   Data "set    ^   "
Dim Txt14a As String * 4 At &H181 Overlay    'Txt14a:      "   ^"
Dim Txt14b As String * 4 At &H182 Overlay    'Txt14b:      "  ^ "
Dim Txt14c As String * 4 At &H183 Overlay    'Txt14c:      " ^  "
Dim Txt14d As String * 4 At &H184 Overlay    'Txt14d:       "^   "
Dim Txt15 As String * 4 At &H189             'Txt15:   Data "Off "
Dim Txt16 As String * 4 At &H18E             'Txt16:   Data "set "
Dim Txt17 As String * 3 At &H193             'Txt17:   Data "PE-"
Dim Txt18 As String * 6 At &H197             'Txt18:   Data "VRBuf:"
Dim Txt18a As String * 2 At &H19B Overlay    'Txt18a: Data "f:"
Dim Txt19 As String * 8 At &H19E             'Txt19:   Data "automat!"
Dim Txt20 As String * 6 At &H1A7             'Txt20:   Data "W-Ton:"
Dim Txt21 As String * 6 At &H1AE             'Txt21:   Data "URAnz:"
Dim Txt22 As String * 6 At &H1B5             'Txt22:   Data " min  "
Dim Txt23 As String * 2 At &H1BC             'Txt23:   Data "T "
Dim Txt24 As String * 4 At &H1BF             'Txt24:   Data (dB)"Att"
Dim Txt25 As String * 2 At &H1C4             'Txt25:   Data "<,"
Dim Txt26 As String * 2 At &H1C7             'Txt26:   Data "K "
Dim Txt27 As String * 5 At &H1CA             'Txt27:   Data "TxPwr"
Dim Txt28 As String * 2 At &H1D0             'Txt28:   Data "UR"
Dim Txt29 As String * 2 At &H1D3             'Txt29:   Data (dB)"m"
Dim Txt30 As String * 7 At &H1D6             'Txt30:   Data "fffffff"
Dim Txt31 As String * 7 At &H1DE             'Txt31:   Data "fffffff"
Dim Blnk8 As String * 8 At &H1E6             'Blnk8:   Data "        "
Dim Blnk6 As String * 6 At &H1E8 Overlay     'Blnk6:
Dim Blnk4 As String * 4 At &H1EA Overlay     'Blnk4:
Dim Blnk3 As String * 3 At &H1EB Overlay     'Blnk3:
Dim Blnk2 As String * 2 At &H1EC Overlay     'Blnk2:
Dim Blnk1 As String * 1 At &H1ED Overlay     'Blnk1:
Dim Empty As Byte At &H1EF                   '255 = leere EEPROM Zelle

'Rambereich fr automatisch initialisierte Variablen

Dim AktKanal As Byte At &H1F0                'Aktueller Kanal 1, 2, 3 bis 6
Dim OldKanal As Byte At &H1F1                'OldKanal
Dim FoxNr As Byte At &H1F2                   'Fuchsnummer
Dim OldMod As Byte At &H1F3                  'Vorgngerwert von MODUS
Dim Lg As Byte At &H1F4                      'Formatlnge fr String
Dim OldUreg As Byte At &H1F5                 'Vorgngerwert von UReg
Dim URegPtr As Byte At &H1F6                 'Regelspannungszeiger fr aut. Regelung
Dim Stp(3) As Byte At &H1F7                  'Schrittweite bei Sollfrequenznderung
Dim TXPZ(6) As Byte At &H1FA                 'TxPower Zahlenwerte

Dim EprTxt(255) As Byte At &H100 Overlay     'EEPROM Text-Daten als Byte-Array

'Rambereich fr brige Variablen

Dim AkASCI As Byte                           'ASCII Wert von FBM
Dim Alert As Byte                            'Flag fr Warnton und UB-Messung
Dim AlertSync As Byte                        'Flag fr Warnton Synchronisation
Dim FoxTimeSec As Byte                       'FuchsRestlaufzeit in Sekunden
Dim FoxTime100 As Byte                       'FuchsRestlaufzeit in 1/100 Sekunden
Dim BAFlag As Byte                           'BA-Tasten Flag
Dim ButtTime As Byte                         'Tastendruck-Zeit K1, K2, BA
Dim Bsec As Byte                             'Betriebssekunden
Dim CalMode As Byte                          'Calibriermode
Dim CntDis As Byte                           'Zhlerabschaltung
Dim CButt As Byte                            'Buttons am PortC 00000XYZ
Dim ChgVal As Byte                           'Programmier-Mode nderungswert
Dim Digit As Byte                            'Stelle in der Frequenz Anzeige 1=100Hz
Dim DButt As Byte                            'Buttons am PortD 0000VW00
Dim DButtDelay As Byte                       'DButton Verzgerung
Dim DButtFlag As Byte                        'DButton Flag, Resert mit DspDly=0
Dim DebVar As Word                           'Hilfsvariable fr Debug Ausgabe
Dim DspBlk As Byte                           'Flag Display Blinken
Dim DspDly As Byte                           'Display Delay
Dim DspUSM As Byte                           'Display Delay
Dim EPA As Byte                              'Alg. EEprom Adresse, Byte
Dim EPA256 As Word                           'Alg. EEprom Adresse, Word
Dim EPAdr As Byte                            'EEprom Adresse fr Kanalspeicher
Dim FBM As Byte                              'Frequenz Buttons  Max, bei zwei Tasten
Dim Fmin As Word                             'untere Frequenzgrenze
Dim Fmax As Word                             'obere Frequenzgrenze
Dim FoxCnt As Byte                           'Anzahl gespeicherter Fuchs-Zeiten
Dim FreeAlert As Byte                        'Flag zur Abkopplung des Warntones
Dim FreqAbw As Word                          'Frequenz Abweichung
Dim GateCnt As Byte                          'Anzahl Timer0-Durchlufe
Dim I As Byte                                'Zhlvariable fr LCD-Ausgabe
'Dim Kanal(6) As Word                         'Kanal Daten als Word Array
Dim KanTxt As String * 1                     'Kanal Text (1,2 oder 3)
Dim LcdUpd As Byte                           '1=LCD Aktualisierung, 2=Zeitausgabe
Dim Minuten As Byte                          'Minuten max: 255
Dim MinAusgabe As Byte                       'Minuten fr Ausgabe
Dim Modus As Byte                            'Mode-Kennung, Werte siehe unten
Dim NoSpc As Byte                            'Anzahl Blanks bei Textausgabe
Dim NxtZwZ As Byte                           'Freie EEprom Adresse fr Zwischenzeit
Dim RptFlg As Byte                           'Repeat Flag
Dim PEAnz As Byte                            'PE Anzeige im Calibriermode
Dim S As Byte                                'S-Meterwert
Dim Salt As Byte                             'alter S-Meterwert
Dim Srg As Byte                              'S-Meterwert fr Regelung Maxwert ber mehrere Messungen
Dim Sek100stel As Byte                       '100stel Sekunden
Dim Sekunden As Byte                         'Sekunden
Dim SekAusgabe As Byte                       'Sekunden fr Ausgabe
Dim SollFreq As Word                         'Soll-Frequenz
Dim Tmp As Byte                              'Hilfsvariable
Dim TmpVar As Byte                           'Hilfsvariable
Dim TmpVar2 As Byte                          'Hilfsvariable
Dim Temp As Word                             'Temporrer Wordspeicher
Dim TmpTxt As String * 8                     'Hilfsstring
Dim TmpLen As Byte                           'Lnge von TmpTxt
Dim TxpOffset As Byte                        'Offset im EEPROM fr Entfernungsanzeige
Dim UBatt As Word                            'Gemessene Batteriespannung
Dim URAakt As Byte                           'aktuelle UR-Anzeige
Dim URegIn As Word                           'Regelspannung Input, Word belegt 32 Byte
Dim USMet As Word                            'S-Meterspannung
Dim USM As Byte                              'S-Meterspannung, begrenzt auf 255
Dim Uhr As Byte                              'Flag Display Aus
Dim VfoFreq As Word                          'VFO-Frequenz
Dim VfoUp As Byte                            'VFO Nachstimmrichtung
Dim WrFlag As Byte                           'Write Flag 1=EEPROM Schreiben
Dim ZwZAdr As Byte                           'Aktuelle EEprom Adresse fr Zwischenzeit
Dim SMetRP(30) As Byte                       'S-Meter Ringpuffer
Dim SMwrPtr As Byte                          'SMeter Write Pointer
Dim SMrdPtr As Byte                          'SMeter Read Pointer
Dim URReg As Byte                            'UR-Regelung: 0= Aus, 255=Ein
Dim DURegIn As Byte                          'Delta URegIn
Dim TXPA As Byte                             'Anzeigewert fr TxPKor
Dim USMDelay As Byte                         'Verzgerung der USM-Messung bei Beep


#IF Variante = 1                             'AtMega8 SMD mit DIPS0802, Rechtshnder

#if FETVST = 0

 DdrC = &B00010001                           'PC0, PC4 Output, Rest Input
PortC = &B00000010                           'Pullup nur an PC1

 ATTPort ALIAS DdrC.3

#else

 DdrC = &B00011001                           'PC0, PC3 u. PC4 Output, Rest Input
PortC = &B00001010                           'Pullup nur an PC1

 ATTPort ALIAS PortC.3

#endif

 DdrB = &B11111110                           'PB0=Input SB-Taste, PB3 DA-Output
PortB = &B00001000                           'Input ohne Pullup, LCD-Out 0, PWM 1

 DdrD = &B00000011                           'PD0 u. PD1 Output, Rest Input,
PortD = &B11011011                           'Pullups an PD3, PD4, PD6 u. PD7

Mute Alias DdrD.2                            'PD2 Input, bei Mute Output low
SBTaste Alias PinB.0                         'PD0 Input, High bei gedrckter SB-Taste
BeepPort ALIAS PortC.0                       'Beep Port

#ENDIF

#IF Variante = 2                             'AtMega8 SMD mit DIPS0802, Linkshnder

#if FETVST = 0

 DdrC = &B00010000                           'PC4 Output, Rest Input
PortC = &B00001100                           'Pullup nur an PC3 und PC4

 ATTPort ALIAS DdrC.1                        'Port zur Gain-Umschaltung

#else

 DdrC = &B00010010                           'PC1 u. PC4 Output, Rest Input
PortC = &B00001110                           'Pullup nur an PC3 und PC4

 ATTPort ALIAS PortC.1                       'Port zur Gain-Umschaltung

#endif

 DdrB = &B11011110                           'PB0=Input SB-Taste
PortB = &B00111010                           'Inputs mit Pullup, LCD-Out 0, PWM 1, BA-Inp

 DdrD = &B00001111                           'PD0 u. PD1 Output, Rest Input,
PortD = &B11001111                           'Pullups an PD6 u. PD7

Mute Alias DdrD.4                            'PD4 Input, bei Mute Output low
SBTaste Alias PinB.0                         'PD0 Input, High bei gedrckter SB-Taste
BeepPort ALIAS PortB.2                       'Beep Port

#ENDIF

#IF Variante = 3                             'AtMega8 DIP mit aMC0802C

 DdrB = &B11101000                           'PB3, PB5 Output, PB0,PB1 u. PB4 Input
PortB = &B00010011                           'Pullups an PB0,PB1,PB4; Outputs auf Null
                                             'PB2 Tri-State I/O

 DdrC = &B00100000                           'PC5 E-Output; PC0...PC3 A-Input; PC4 Mute
PortC = &B00100000                           'Keine Pullups; PC5=1

 DdrD = &B00011111                           'PD0...PD4 LCD-Outputs, PD5...PD7 Input
PortD = &B10000000                           'Pullup an PD7

#ENDIF

#IF Variante = 4                             'AtMega8 SMD mit DIPS0802, alte Hardware

 DdrB = &B11111111                           'PB0 = LCD-Power Ein=1, PB1=LCD.DB5, PB3=PWM
'PortB = &B00100011                           'PB5=1 fr PWM, Rest LCD-Outputs auf Null
PortB = &B00001011                           'PB3=1 fr PWM, Rest LCD-Outputs auf Null

 DdrC = &B00100000                           'PortC.5 Output, Rest Input
PortC = &B00011011                           'Pullups an Inputs, auer PC2, PC6 u. PC7

 DdrD = &B11011000                           'PD3, PD4, PD6 u. PD7 Output, Rest Input,
PortD = &B00000100                           'Pullup an PD2, Outputs Null

ATTPort ALIAS PortD.4                        'Ruhephase des Beep-Ausgang schaltet Gain
LZPuls ALIAS PortD.3                         'Test-Puls zur Laufzeitmessung
BeepPort ALIAS PortD.4                       'Beep Port

#endif

'-------------------------------------------------------------------------------

 Config Timer0 = Timer , Prescale = 256      '6553600/(256*256)=100Hz
 On Timer0 T0int                             'Interrupt Routine alle 10ms

 Config Timer1 = Counter , Edge = Rising     'Zhler 16 Bit

 'Config Timer2 = Pwm , Compare Pwm = Clear Up , Compare Pwm = Clear Down

 OCR2 = 255                                  'Startwert fr OCR2

 TccR2 = &B01100001                          'phasecorrect PWM,
                                             'Clear on CM up, Set on CM down,
                                             'no Prescaling

 Config Adc = Single , Prescaler = Auto      ', Reference = INTERNAL

 Enable Timer0                               'Timer0-Interrupts ein (Torzeit)
 Enable Interrupts                           'Interrupts global einschalten
 Start Timer0
'-------------------------------------------------------------------------------

'Konfiguration LCD-Anzeige:

 Config Lcd = 16 * 2                         'Compiler untersttzt derzeit kein 8 Zeichen Display

#if Variante = 1                             'AtMega8 SMD mit DIPS0802, Rechtshnder
 Config LcdPin = Pin , DB4 = PortB.1 , DB5 = PortB.2 , DB6 = PortB.4 , DB7 = PortB.5 , E = PortD.1 , RS = PortD.0
#endif

#if Variante = 2                             'AtMega8 SMD mit DIPS0802, Linkshnder
 Config LcdPin = Pin , DB4 = PortD.0 , DB5 = PortD.1 , DB6 = PortD.2 , DB7 = PortD.3 , E = PortB.4 , RS = PortB.1
#endif

#if Variante = 3                             'AtMega8 DIP mit aMC0802C
 Config LcdPin = Pin , DB4 = PortD.0 , DB5 = PortD.1 , DB6 = PortD.2 , DB7 = PortD.3 , E = PortC.5 , RS = PortD.4
#endif

#IF Variante = 4                             'AtMega8 SMD mit DIPS0802, alte Hardware
 Config Lcdpin = Pin , DB4 = PortB.2 , DB5 = PortB.1 , DB6 = PortB.4 , DB7 = PortB.5 , E = PortD.6 , RS = PortD.7
#endif

'-------------------------------------------------------------------------------

 #if URAnzeige > 0
  DefLcdChar 4 , 6 , 5 , 5 , 14 , 21 , 21 , 14 , 32       ' Chr(4) = dB
  DefLcdChar 0 , 32 , 32 , 32 , 32 , 32 , 32 , 32 , 32       ' Chr(0) Blank

  #if Variante = 1 OR Variante = 4           'AtMega8 SMD mit DIPS0802, Rechtshnder
   DefLcdChar 1 , 3 , 3 , 3 , 3 , 3 , 3 , 3 , 3       '         Chr(1) rechter Balken
  #endif

  #if Variante = 2                           'AtMega8 SMD mit DIPS0802, Linkshnder
   DefLcdChar 1 , 24 , 24 , 24 , 24 , 24 , 24 , 24 , 24       ' Chr(1) linker Balken
  #endif

  DefLcdChar 2 , 27 , 27 , 27 , 27 , 27 , 27 , 27 , 27       ' Chr(2) linker und rechter Balken
 #endif
 Cls                                         'Display lschen
 Cursor Off                                  'LCD-Kursor ausschalten

'-------------------------------------------------------------------------------

 Gosub ReadEprDaten                          'Permante Variablen aus EEPROM lesen

 'Ausgabetexte und automatisch initialisierte Variablen aus EEPROM lesen

 EPA = 0
 Do
   Gosub IncrEPA
   EPA256 = EPA + 255
   ReadEEprom EprTxt(EPA) , EPA256           'Lesen des aktuellen Bytes ins Ram
 Loop Until EPA = 255

 Uhr = ManUhrSt                              'Manueller Uhrstart wenn ManUhrSt = 1

 Gosub Beep
'-------------------------------------------------------------------------------
'Testausgabe der Tastenwerte

#if DebugMode = 1                            'AtMega8 SMD mit DIPS0802

 TestLoop:

 Gosub ReadCButt
#if UPDNButt = 1
 Gosub ReadDButt
#endif                                       'UPDNButt=1
 'CLS
 HOME Upper

 LCD "CBUT "
 LCD CButt

 HOME Lower

 LCD "DBUT "

 IF DButt < 10 Then LCD 0

 LCD DButt

 Waitms 300

 GOTO TestLoop

#endif
'-------------------------------------------------------------------------------
'Versionsanzeige
#if MinSW = 0

 GOSUB ReadCButt

 If CButt = 4 Then                           'Versionsanzeige

   Home Upper
   LCD Vers                                  'Versionseintrag
   Home Lower
   Lcd Chr(72) ; HWConf ; Chr(83) ; SWConf   'Anzeige der HW/SW Configuration
   Uhr = 1                                   'Stopp der Uhr bei Einschalten mit BA

 Else
'-------------------------------------------------------------------------------
  #if URAnzeige > 0

   Gosub GetURAakt

   IF CButt = 3 Then
     DspUSM = 1                              'Anzeige der USM Werte
   Else

    'Calibrierung der URAnzeige

     If CButt > 0 Then                       'Test auf Calibriermode

       CalMode = CButt
       VRBufLen = 5
       URegPtr = 131                         'erster UE-Wert 0 dBuV

       Home Upper
       LCD Txt03                             '"Cal-SMet"

       Home Lower
       IF CalMode = 1 Then
         LCD Txt13                           '"manuell!"
       Else
         LCD Txt19                           '"automat!"
       End If

     End If

     End If

  #endif

 End If

#endif                                       'MinSW=0

 WHILE CButt > 0                             'Warte bis Start-Tasten losgelassen
   GOSUB ReadCButt
 WEND

'-------------------------------------------------------------------------------
'Starteinstellungen:

#if AlertPer > 0
 If FoxPerSec > 99 Then                      'Sicherheitsprfung auf 120 Sekunden
   FoxPerSec = 60                            'kann ggf. entfallen ***
 End If
 #if AlertPer = 2
 If FoxPer100 > 99 Then                      'Sicherheitsprfung auf 120 Sekunden
   FoxPerSec = 0                             'kann ggf. entfallen ***
 End If
 #endif
#else
   FoxPerSec = 60                            'wenn nicht einstellbar, fest 60 Sekunden
#endif

 Gosub ReadAlert                             'Uhr rcksetzen und Alert Daten aufbereiten

'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  Home Upper                                 'Logo Ausgabe
  Lcd Logo                                   '"ARDF 80m"
  Home Lower
  Lcd Rufz                                   'mit Rufzeichen oder Name

  Wait 1

  '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

' Automatisch ber EEPROM initialisierte Variablen

' Empty = 255
' FoxNr = 1
' AktKanal = 1
' Oldkanal = 1
' OldMod = 1
' OldUReg = 128
' URegPtr = 251
' Stp(1,2,3)

 #if FoxMem = 1
  Gosub GetNxtZwZ                            'nchster freier Zwischenzeitspeicher
 #endif

  Gosub SetModus1                            'Start mit Modus 1

 '-------------------------------------------------------------------------------
 Main:                                       'Hauptschleife

 If GateCnt = 0 Then                         'Alle 40 ms, wenn Zhlphase beendet

   'LZPuls = 1                               'Laufzeit Start

   While FreqAbw > 0                         'variabler Korrkturpuls
     Decr FreqAbw                            'zur Nachfhrung der Frequenz
   Wend

 #if Variante = 1                            'AtMega8 SMD mit DIPS0802, Rechtshnder

    DdrC.5 = 0                               'zuerst Port auf Input
   PortC.5 = 0                               'dann ggf. Pullup abschalten, hochohmig

   PortC.4 = Modus.0                         'Betriebsart nach extern einstellen

 #endif

 #if Variante = 2                            'AtMega8 SMD mit DIPS0802, Linkshnder

    DdrC.5 = 0                               'zuerst Port auf Input
   PortC.5 = 0                               'dann ggf. Pullup abschalten, hochohmig

   PortC.4 = Modus.0                         'Betriebsart nach extern einstellen

 #endif

 #if Variante = 3                            'AtMega8 DIP mit aMC0802C

    DdrB.2 = 0                               'zuerst Port auf Input
   PortB.2 = 0                               'dann ggf. Pullup abschalten, hochohmig

   'PortC.5 = Modus.0                         'Betriebsart nach extern einstellen

 #endif

#IF Variante = 4                             'AtMega8 SMD mit DIPS0802, alte Hardware

    DdrD.0 = 0                               'zuerst PortD.0 auf Input
   PortD.0 = 0                               'dann ggf. Pullup abschalten, hochohmig

   PortC.5 = Modus.0                         'Betriebsart nach extern einstellen

 #endif

 '== Stndige Aktionen, wenn keine Tasten gedrckt ==============================

   IF CalMode > 0 Then                       'S-Meter Kalibrierung

     Gosub ReadCButt                         'mit K1, K2 oder BA-Taste weiter

     If CButt > 0 Then
       Gosub Beep
       Do
         FBM = CButt
         Gosub ReadCButt                     'Steuertasten abfragen
       Loop Until CButt = 0                  'warten bis Taste losgelassen

       PEAnz = 32
       If FBM = 2 Then
         WriteEEprom OCR2 , URegPtr          'UR speichern mit K2
         PEAnz = 0
       End If

       Gosub IncrURegPtr                     'nchster UE-Wert + 5dB

       Gosub RdUREntry                       'lese vorhandenes UR

     End If

     Lg = 3                                  'Ausgabe auf drei Stellen
     Home Upper
     IF PEAnz.5 = 0 Then                     'abwechseld PE oder UR-Ausgabe
       Lcd Txt17                             '"PE-"
       'TmpVar = 7 - URegPtr                  '=255+8-URegPtr
       TmpVar = 2 - URegPtr                  '=255+8-5-URegPtr
       'TmpVar = 253 - URegPtr                '=255+8-10-URegPtr
       Gosub LcdbxVar                        'TmpVar = Dmpfungswert 6.u.7. Zeichen
       Lcd Txt29                             '"(db)m"
     Else
       Temp = TmpVar2
       Gosub LcdbxWord                       'alten UR-Wert mit 3 Stellen anzeigen
       Lcd Txt28                             '"UR" 4. und 5. Zeichen Text
       Temp = OCR2
       Gosub LcdbxWord                       'neuen UR-Wert mit 3 Stellen anzeigen
     End If

     Incr PEAnz

     Gosub USMausgabe                        'S-Meter Wert berechnen und Balkenausgabe

     IF CalMode = 1 Then                     'manuelle Calibrierung

       Gosub URegMess

      #if RXTyp = 3
       URegIn = 255 - URegIn                 'Drehsinn des Potis umkehren
      #endif

       OCR2 = URegIn

     Else                                    'automatische Calibrierung

       IF SMwrPtr = 1 Then
         IF Srg > 8 Then                     'bei zu hohem Pegel
        #if RXTyp = 3
           IF OCR2 > 1 Then
             OCR2 = OCR2 - 1                 'Spannung an FETs reduzieren
           End If
        #else
           IF OCR2 < 255 Then
             OCR2 = OCR2 + 1                 'Regelspannung an TCA440 anheben
           End If
        #endif
         End If
         IF Srg < 8 Then                     'bei zu kleinem Pegel
        #if RXTyp = 3
           IF OCR2 < 255 Then
             OCR2 = OCR2 + 1                 'Spannung an FETs erhhen
           End If
        #else
           IF OCR2 > 1 Then
             OCR2 = OCR2 - 1                 'Regelspannung an TCA440 absenken
           End If
        #endif
         End If
       End If

     End If

   Else

     If Modus = 0 Then                       'im Einstellmode

     AktKanal = 40                           'Kanalnummer ungltig machen (= X)

     If LcdUpd = 1 Then
       Gosub FrequenzAusgabe                 'Frequenzausgabe nach nderung
     End If

    #if URAnzeige = 2
     Gosub USMausgabe                        'S-Meter Balken ausgeben
     Srg = 8                                 'Unterdrckung der HF-Regelung
     Gosub URegProc                          'Ausgabe der UR-Einstellung nach OCR2

    #endif

   End If

   If Modus = 1 Then                         'Im Mode 1

    #if MinSW = 0
     If Alert > 0 Then                       'Ausgabe des Warntones u. ggf. UBatt
       Gosub BattTest
       If UBatt < 700 Then                   'Zustzlich akustische Warnung
         Home Upper
         LCD Txt10                           '"LowBatt!" in Zeile 1
         Gosub UBAusgabe2                    'Ausgabe UBatt-Wert in Zeile 2
         DspDly = 250                        'DspDly = 2,5 Sec
         'Gosub SetDspDly                     'DspDly = 1 Sec

         Gosub Beep                          '2 zustzliche Beeps bei UBatt < 7V
         Gosub Waitms200
         Gosub Beep
         Gosub Waitms200
         Gosub Beep
       Else
         If Alert = 1 Then
           Gosub Beep                        'Warnton zur Alert Sekunde
         End If
       End If

     End If
    #endif                                   'MinSW=0

    #if UPDNButt = 1
     Gosub ReadDButt
    #endif                                   'UPDNButt=1

    #if DspBlink = 1
     If URAakt > 0 Then                      'Bei Regelspannungsanzeige
       If DspBlk = 1 Then                    'wenn DSP-Blank-Phase aktiv
         If URegIn > 80 Then                 'und URegIn > 80*5=400mV
           DspBlk = 0                        'DSPBLK deaktivieren
           Home Lower
           Lcd Blnk8                         '2.Zeile lschen
         End If
       End If                                'd.h. blinken der 2. Zeile
     End If
    #endif

     If LcdUpd > 0 Then                      'wenn Frequenz- oder ZeitAusgabe aktiviert

         Gosub LcdUpdate

     End If

    #if URAnzeige = 2
    #if Peiler > 20
     IF DspDly = 0 Then
       IF URAakt > 0 Then Gosub USMausgabe   'S-Meter Balken ausgeben
     End If
    #else
     IF USMDelay > 0 Then
       Decr USMDelay
       Salt = 0
     Else
       IF DspDly = 0 Then
         IF URAakt > 0 Then Gosub USMausgabe 'S-Meter Balken ausgeben bei Peiler 20
       End If
     End If
    #endif

    #if UPDNButt = 1
     IF DButtFlag > 0 Then Gosub USMausgabe  'S-Meter Balken ausgeben
    #endif                                   'UPDNButt=1

     Gosub URegProc                          'Aufschaltung der HF-Regelspannung
    #endif

   End If

   If Modus = 3 Then

    #if UPDNButt = 1
     Gosub ReadDButt
    #endif                                   'UPDNButt=1

     If DspDly = 0 Then                      'automatisches Beenden von Modus 3
       Gosub SetModus0
     End If

   End If

  'LZPuls = 0                                 'Laufzeit: 405 us ohne ZeitAusgabe

  #if DebugMode = 1
   'DebVar = Modus
   'DebVar = ZFOffset
   'DebVar = FoxTimeSec
   'DebVar = FoxPerSec
   'DebVar = Alert
   'GOSUB DSPVar1                        'Debug Ausgabe von Modus
  #endif
'
'== Button Abfrage in allen Modis ==============================================

   Gosub ReadCButt                           'C-Buttons abfragen

'== C-Buttons gedrckt =========================================================

   If CButt > 0 Then                         'C-Tasten (Kanalwahl und BA) abfragen
'
     Do                                      'C-Tasten gedrckt AND ButtTime < 241

       Gosub ReadCButt                       'Steuertasten abfragen

'-- Nur BA-Taste gedrckt ------------------------------------------------------

         If CButt = 4 Then                   'Nur BA-Taste gedrckt
           If BAFlag = 0 Then                'und BAFlag nicht gesetzt

             If Modus = 22 Then              'im Offset Programmiermode
               BAFlag = 1                    'Flag, da BA-Taste gedrckt war setzen
               ButtTime = 252                'Repeat-Tastung abschalten
             End If

             If ButtTime = 1 Then            'Wettkampfmode von 1 bis 99
               If Modus = 4 Then             'Synchronisieren des Fuchstimers
                 FoxNr = ChgVal              'Fuchsnummer bernehmen
                 FoxTimeSec = FoxPerSec      'max Fuchslaufzeit setzen
               End If
               Gosub SetModus1
             End If

             If ButtTime = 100 Then          'Einstellmode von 100 bis 149
               Gosub SetModus0
             End If

             If ButtTime = 150 Then          'Programmiermode von 150 bis 199
               Modus = 4                     'beginne mit Mode 4, Fuchstimer verschieben
               ChgVal = FoxNr                'Vorgabe der akt. Fuchsnummer fr Mode 4
               Gosub AnzPMode                'unmittelbare Anzeige
             End If

            #if MinSW = 0
            #if FoxMem = 1
             If ButtTime = 200 Then          'Auswertemode von 200 bis 239
               Modus = 32
               Gosub FoxAusgabe              'unmittelbare Anzeige
             End If

             If ButtTime = 250 Then          'Abschaltemode ber 249
               Modus = 64
               Gosub UhrMenu                 'unmittelbare Anzeige
             End If
             Goto Done1                      'andere Aktionen berspringen
            #else
             If ButtTime = 200 Then          'Abschaltemode ber 200
               Modus = 64
               Gosub UhrMenu                 'unmittelbare Anzeige
             End If
             Goto Done1                      'andere Aktionen berspringen
            #endif                           'FoxMem = 1
            #endif                           'MinSW=0
           End If
         End If

'-- Nur BA-Taste Ende ----------------------------------------------------------

'-- K1, K2-Tasten gedrckt oder BA Flag gesetzt --------------------------------

         If CButt > 0 Then                   'wenn noch C-Tasten gedrckt
           If CButt <> 4 Then                'aber nicht BA-Taste alleine
             If ButtTime = 252 Then          'und vorher BA-Flag gesetzt
               ButtTime = 80                 'kurze Wiederholrate einstellen
               FBM = 0                       'MaxSpeicher lschen
             End If
           End If
         End If

         If CButt > FBM Then                 'Maxwert FBM aus K1 u. K2 ermitteln
         FBM = CButt                         'Tastenwert 1..3
           If Modus < 4 Then                 'Im Einstell-, Wettkampf- oder Testmode
             AktKanal = FBM                  'Aktueller Kanal = Tastenwert
             If AktKanal > 4 Then
               AktKanal = AktKanal - 1       'Kanal 4,5,6
             End If
             Gosub KanalDat                  'Kanaldaten aus AktKanal berechnen
           End If
         End If

        #if DebugMode = 1
         'DebVar = FBM
         'GOSUB DSPVar1                  'Debug Ausgabe von CButt
        #endif

         If ButtTime = 100 Then
           ButtTime = 251                    'Stoppen der weiteren Beeps
'
             If Modus > 3 Then               'in den verschiedenen Programmiermodes
               If Modus < 32 Then            'Einstellungen ausfhren und anzeigen
                 ButtTime = 252              'Repeat-Tastung einschalten
                 RptFlg = 1                  'Repeat Flag setzen
                 Gosub ProgMode              'Einstellung periodisch ausfhren
               End If
             End If

         End If

Done1:                                       'Ende der "Oder Bedingung"

'-- K1, K2-Tasten Ende ---------------------------------------------------------

       If ButtTime < 251 Then Incr ButtTime  'Tastendruckdauer abzhlen

     Loop Until CButt = 0
'
'-- Alle C-Tasten losgelassen, Auswertung der gespeicherten Werte --------------
'
     If FBM > 0 Then                         'Wenn eine Frequenzwahltaste gedrckt war
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'
       If Modus < 4 Then                     'Im Einstell- Test- oder Wettkampfmode

         If ButtTime => 100 Then             'Dauer 2 x Beep
           WriteEEprom SollFreq , EPAdr      'aktuelle Sollfrequenz speichern
         End If

         Gosub SetDspDly                     'DspDly = 1 Sec

         If ButtTime < 100 Then              'Dauer 1 x Beep

           IF VRBufLen > 0 Then
             IF AktKanal = OldKanal Then
               Incr URReg
              #if Peiler > 20
               IF URReg > 2 Then URReg = 0
              #else
               IF URReg > 1 Then URReg = 0
              #endif
               OldUReg = 0                   'zwinge UReg auf Potstellung
             End If
             OldKanal = AktKanal
          Else
            URReg = 0
          End If

           If Modus = 0 Then
             Modus = 3                       'Modus 3 einschalten
             Ausgabe = Txt23                 '"T "  fr Test Betrieb einstellen
           End If
         End If

         Gosub ReadKanal                     'Kanaldaten berechnen und Kanal laden
         URAakt = 0
         Gosub LcdUpdate                     'Frequenzausgabe und ZeitAusgabe

       End If
'- - - - - - - - - - - - - - - - - - - - - - Frequenzwahltaste war gedrckt! - -

       If Modus > 3 Then                     'im Programmiermodus
         If Modus < 32 Then                  'Einstellungen ausfhren und anzeigen
           If RptFlg = 0 Then                'nur das erste Mal im Repeat Fall
             Gosub ProgMode                  'beim Loslassen der K1-/K2-Tasten
           End If
         End If
       End If

'- - - - - - - - - - - - - - - - - - - - - - Frequenzwahltaste war gedrckt! - -
      #if FoxMem = 1
       If Modus = 32 Then                    'Auswertemode Befehle ausfhren und anzeigen

         If FBM = 3 Then                     'und K1+K2 gedrckt
           If ButtTime => 100 Then           'und Dauer 2 x Beep
             Gosub TimeErase                 'Lschen der Zwischenzeiten
           End If
         End If

         Gosub FoxAusgabe                    'Zwischenzeiten Anzeigen

       End If
      #endif
'- - - - - - - - - - - - - - - - - - - - - - Frequenzwahltaste war gedrckt! - -
      #if MinSW = 0
       If Modus = 66 Then                    'im Betriebsminutenmode

         If FBM = 1 Then                     'mit K1
           Bmin = 0                          'Betriebsdauerzhler lschen
         End If

         If FBM = 2 Then                     'mit K1
           Gosub ReadEprDaten                'Betriebsdauerzhler laden
         End If

         Gosub BminAnzeige                   'Bertiebsdauer anzeigen

         If FBM = 3 Then                     'mit K1 und K2 gleichzeitig
           Gosub WriteEprDaten               'Betriesdauerzhler speichern
           Display Off                       'Display abschalten
           Powerdown                         'Prozessor in Powerdown
         End If

       End If

'- - - - - - - - - - - - - - - - - - - - - - Frequenzwahltaste war gedrckt! - -

       If Modus = 64 Then                    'im Uhr Menu

         If FBM = 1 Then                     'mit K1
           Uhr = 1                           'Stoppuhr anhalten
           ManUhrSt = 0                      'Manuellen Uhr-Start deaktivieren
          Gosub SetModus1
         End If
         If FBM = 2 Then                     'mit K2
           Uhr = 1                           'Stoppuhr anhalten
           ManUhrSt = 1                      'Manuellen Uhr-Start aktivieren
           Minuten = 0
           Sekunden = 0
           Gosub SetModus1
         End If
         If FBM = 3 Then                     'mit K1 und K2 gleichzeitig
           Gosub NxtModus
           Gosub BminAnzeige
         End If
         Gosub WriteEprDaten                 'EEPROM schreiben

       End If
      #endif                                 'MinSW=0
'- - - - - - - - - - - - - - - - - - - - Frequenzwahltaste war gedrckt! - - - -
'
     Else                                    'Wenn nur BA-Taste gedrckt war
'
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      #if MinSW = 0
       If OldMod = 1 Then                    'Mode war bereits Wettkampfmode
         If ButtTime < 100 Then              'und Drckdauer 1 x Beep

           If Uhr = 1 Then
             Uhr = 0                         'Uhr einschalten
             'Freealert = 1                   'Warnton von der Zeit abkoppeln
           End If

           #if FoxMem = 1

           If Minuten < 3 Then               'und weniger als 3 Minuten seit EIN
            #if BattChgOpt = 1
             If NxtZwZ = 32 Then             'und noch keine Zwischenzeit gespeichert
            #endif
               'If FreeAlert = 0 Then         'und Warnton nicht abgekoppelt
                 Minuten = 0                 'Minuten rcksetzen
                 FoxNr = 1
                 'Sekunden = 0                'Sekunden rcksetzen
                 Gosub ReadAlert             'Warnton-Zeitpunkt einstellen
               'End If
            #if BattChgOpt = 1
             Else                            'Bereits Zwischenzeit gespeichert
               Gosub NxtM2toZwZ              'aktuelle Adresse um 2 reduziern
               Gosub ZwZ2Nxt                 'und als aktuelle und nchste verwenden
               Gosub DoubleRead              'lesen der beiden Eintrge
               Minuten = MinAusgabe          'Uhr auf diesen Eintrag stellen
               Sekunden = SekAusgabe
               AlertSync = 1                 'Flag "Warnton unsynchron" setzen
             End If
            #endif
           Else                              'mehr als 3 Minuten sind vergangen

             If AlertSync = 1 Then           'wenn Warnton unsynchron (nach Batt-Wechsel)

               Gosub ReadAlert               'Lage 55. Sekunde (60-5) einstellen
                                              'durch setzen von Sekunde = 0
               AlertSync = 0                 'dann AlertSyncFlag lschen
               Incr Minuten                  'Minuten auf nchste Minute vorstellen
             Else                            'im Normalfall Zwischenzeit speichern
               WriteEEprom Minuten , NxtZwZ  'aktuelle Minuten speichern
               Gosub IncrNxtZwZ              '            Addresse incr.
               WriteEEprom Sekunden , NxtZwZ 'aktuelle Sekunden speichern
               Gosub IncrNxtZwZ              '            Addresse incr.
             End If

           End If
           #endif                            'FoxMem=1
           Gosub WriteEprDaten               'Betriesdauerzhler speichern
         End If
       End If
      #endif                                 'MinSW=0
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
     End If
'- - - - - - - - - - - - - - - - - - - - wenn BA oder K-Taste gedrckt war - - -

    #if MinSW = 0
     If Modus = 64 Then                      'Uhr ein/aus
       Gosub UhrMenu                         'Anzeige Uhr Menu
     End If
    #endif                                   'MinSW=0

     OldMod = Modus                          'OLDMOD aktualisieren

   End If                                    'Ende C-Tasten gedrckt

'== Keine C-Buttons (mehr) gedrckt ============================================

   End If

   ButtTime = 0                              'bei CButt=0 alle Tastenflags lschen
   BAFlag = 0
   RptFlg = 0
   FBM = 0



   CntDis = 0                                'Zhler wieder freigeben

   'LZPuls = 0                               'Laufzeit: ohne Buttons 400 bis 560 us o. Ausg.

 End If                                      'Keine Aktionen solange Torzeit aktiv


 Idle                                        'Idle Mode einschalten,
                                              'wegen geringerem Stromverbrauch

 Goto Main
'-------------------------------------------------------------------------------
T0int:                                       'Timer0-Interrupt, Zhler-Funktion:

 'LZPuls = 1                                  'Laufzeit Start

 If CntDis = 0 Then                          'Zhlvorgang unterdrcken bei anderen Akitvitten
   If GateCnt = 0 Then                       'Zhler starten, wenn er steht
     Start Counter1
     GateCnt = 1
   Elseif GateCnt < 2 Then                   '2 Timer0-Umlufe: 20ms Torzeit
     Incr GateCnt
   Else
     Stop Counter1                           'Zhler stoppen, wenn er luft
     VfoFreq = Counter1                      'Zhler auslesen
     Counter1 = 0                            'Zhler zurcksetzen
     GateCnt = 0                             'Zhler gestoppt anzeigen
     CntDis = 1                              'Sperren des Zhlers nach einem Durchlauf

    'Fr Frequenzregelung Frequenzabweichung und Abweichungsrichtung berechnen

     VfoUp = 0                               '0=keine Abweichung, keine Nachregelung

     If Modus < 4 Then                       'in den Modi 1 bis 3, Empfangsmodi

      #if FrPol = 0                          'Abstimmdiode gegen Masse
       If VfoFreq < SollFreq Then            'Frequenz zu nieder
         FreqAbw = SollFreq - VfoFreq        'Betrag der Abweichung
         VfoUp = 255                         'VFO-Spannung erhhen, erhht Frequenz
       End If
       If VfoFreq > SollFreq Then            'Frequenz zu hoch
         FreqAbw = VfoFreq - SollFreq
         VfoUp = 1                           'VFO-Spannung senken, senkt Frequenz
       End If
      #endif
      #if FrPol = 1                          'Abstimmdiode gegen +5V, Mnchner Kindl
       If VfoFreq < SollFreq Then            'Frequenz zu nieder
         FreqAbw = SollFreq - VfoFreq        'Betrag der Abweichung
         VfoUp = 1                           'VFO-Spannung senken, erhht Frequenz
       End If
       If VfoFreq > SollFreq Then            'Frequenz zu hoch
         FreqAbw = VfoFreq - SollFreq
         VfoUp = 255                         'VFO-Spannung erhhen, senkt Frequenz
       End If
      #endif

       If Modus = 0 Then                     'Im VFO Betrieb Display-Update

         If FreqAbw > 1 Then                 'nur bei Abweichungen > 1
           LcdUpd = 1                        'der letzten Stelle, LSB ist unterdrckt
           SollFreq = VfoFreq                'gemessene Frequenz anzeigen
         End If

       Else                                  'Steuerport fr Integralregler aktivieren

        #if Variante = 1                     'AtMega8 SMD mit DIPS0802, Rechtshnder
         If VfoUp = 1 Then                   'VFO-Spannung senken, (Inversion am Integrator)
           PortC.5 = 1                       '"1" senkt VFO-Spannung, zuerst Pullup akt., = Output=1
            DdrC.5 = 1                       'Port auf  Output, d.h. Ausgang niederohmig high
         End If
         If VfoUp = 255 Then                 'VFO-Spannung erhhen     ***
           PortC.5 = 0                       '"0" erhht VFO-Spannung, zuerst Pullup absch., = Output=0
            DdrC.5 = 1                       'Port auf Output, d.h. Ausgang niederohmig low
         End If
        #endif

        #if Variante = 2                     'AtMega8 SMD mit DIPS0802, Linkshnder
         If VfoUp = 1 Then                   'VFO-Spannung senken, (Inversion am Integrator)
           PortC.5 = 1                       '"1" senkt VFO-Spannung, zuerst Pullup akt., = Output=1
            DdrC.5 = 1                       'Port auf  Output, d.h. Ausgang niederohmig high
         End If
         If VfoUp = 255 Then                 'VFO-Spannung erhhen     ***
           PortC.5 = 0                       '"0" erhht VFO-Spannung, zuerst Pullup absch., = Output=0
            DdrC.5 = 1                       'Port auf Output, d.h. Ausgang niederohmig low
         End If
        #endif

        #if Variante = 3                     'AtMega8 DIP mit aMC0802C
         If VfoUp = 1 Then                   'VFO-Spannung senken, (Inversion am Integrator)
           PortB.2 = 1                       '"1" senkt VFO-Spannung, zuerst Pullup akt., = Output=1
            DdrB.2 = 1                       'Port auf  Output, d.h. Ausgang niederohmig high
         End If
         If VfoUp = 255 Then                 'VFO-Spannung erhhen     ***
           PortB.2 = 0                       '"0" erhht VFO-Spannung, zuerst Pullup absch., = Output=0
            DdrB.2 = 1                       'Port auf Output, d.h. Ausgang niederohmig low
         End If
        #endif

        #IF Variante = 4                     'AtMega8 SMD mit DIPS0802, alte Hardware
         If VfoUp = 1 Then                   'VFO-Spannung senken, (Inversion am Integrator)
           PortD.0 = 1                       '"1" senkt VFO-Spannung, zuerst Pullup akt., = Output=1
            DdrD.0 = 1                       'PortD.0 auf  Output, d.h. Ausgang niederohmig high
         End If
         If VfoUp = 255 Then                 'VFO-Spannung erhhen     ***
           PortD.0 = 0                       '"0" erhht VFO-Spannung, zuerst Pullup absch., = Output=0
            DdrD.0 = 1                       'PortD.0 auf Output, d.h. Ausgang niederohmig low
         End If
        #endif

         If FreqAbw > 4 Then                 'Verstrkung der Abweichung
           Shift , FreqAbw , Left , 3        'um den Faktor 8
         End If                              'bei Abweichungen > 4

       End If
     End If
   End If
 End If

'Wettkampfzeit Uhr fhren

#if MinSW = 0
 Incr Sek100stel                             'Timer0 Interrupt alle 0,01 Sekunden
#if DspBlink = 1
 If Sek100stel = 50 Then DspBlk = 1          'Blinken der URAnzeige vorbereiten
#endif

 If Sek100stel > 99 Then                     'jede Sekunde
   Sek100stel = 0                            'Variable Null setzen

   If Uhr = 0 Then                           'wenn UHR aktiviert

     If Sekunden < 59 Then                   'wenn Sekunden < 59
       Incr Sekunden                         'Sekunden incrementieren
     Else
       Gosub ClrSek                          'Sekunden Modulo 60
       Incr Minuten                          'Minuten incrementieren, max = 254
     End If

   End If

   If Bsec < 59 Then                         'wenn Bsec < 59
     Incr Bsec                               'Betriebssekunden incr.
   Else
     Bsec = 0                                'Bsec Modulo 60
     Incr Bmin                               'Betriebsminuten incr.
   End If

  #if AlertPer < 2
   If FoxTimeSec > 1 Then                    'Fuchs-Restlaufzeit in Sekunden
     Decr FoxTimeSec                         'decrementiern
     IF FoxTimeSec = AlertTime Then Alert = 1       'Warnton aktivieren
   Else                                      'bei Eins
     FoxTimeSec = FoxPerSec                  'wieder auf MaxZeit setzen
     IF AlertTime = 0 Then Alert = 2         'Flag fr UB-Messung setzen
     If FoxNr < NoFoxes Then
       Incr FoxNr
     Else
       FoxNr = 1
     End If
   End If
  #endif

   If DspDly = 0 Then                        'Bei Display Delay = 0
       LcdUpd = 2                            'LCDupd Flag setzen
    #if URAnzeige > 0
     Gosub GetURAakt                         'aktuelle UR-Anzeigeeinstellung holen
    #endif
   End If

 End If
#endif                                       'MinSW

#if AlertPer = 2
 If FoxTime100 = 0 Then FoxTime100 = 100
 Decr FoxTime100                             'decrementiern
 If FoxTime100 = 0 Then                      'Fuchs-Restlaufzeit in Sekunden
   If FoxTimeSec > 1 Then                    'Fuchs-Restlaufzeit in Sekunden
     Decr FoxTimeSec                         'decrementiern
     IF FoxTimeSec = AlertTime Then Alert = 1       'Warnton aktivieren
   Else                                      'bei Eins
     FoxTimeSec = FoxPerSec                  'wieder auf MaxZeit setzen
     FoxTime100 = FoxPer100
     If FoxTime100 > 0 Then Incr FoxTimeSec
     IF AlertTime = 0 Then Alert = 2         'Flag fr UB-Messung setzen
     If FoxNr < NoFoxes Then
       Incr FoxNr
     Else
       FoxNr = 1
     End If
   End If
 End If
#endif

#if UPDNButt = 1
 If DspDly > 0 Then                          'Display Delay Variable
   Decr DspDly                               'im 100stel Sekundentakt bis 0 decr
   IF DspDly = 0 Then
     IF DButtFlag = 0 Then
       LcdUpd = 2                            'Soforige Aktualisierung des Displays
     End If
   End If
 Else
   DButtFlag = 0                             'Rcksetzen des DButtFlag
 End If
#else
 If DspDly > 0 Then                          'Display Delay Variable
   Decr DspDly                               'im 100stel Sekundentakt bis 0 decr
   IF DspDly = 0 Then
     LcdUpd = 2                              'Soforige Aktualisierung des Displays
   End If
 End If
#endif

 'LZPuls = 0                                  'Laufzeit: 6 us oder 20 us

Return
'-------------------------------------------------------------------------------
SetModus0:
 Modus = 0                                   'Modus 0 (VFO-Betrieb) einstellen
 Ausgabe = Txt05                             '"V "  fr variabler (VFO) Betrieb ###
 Gosub FrequenzAusgabe                       'Frequenzausgabe sofort aktualisieren
Return
'-------------------------------------------------------------------------------
SetModus1:
 Modus = 1                                   'Modus 1 (AFC-Betrieb) einstellen

 Fmin = 34900 + ZFOffset                     'Frequenzbereich 3,4900 MHz
 Fmax = 38100 + ZFOffset                     'bis 3,8100

 ReadKanal:

 Gosub KanalDat

 If AktKanal < 10 Then
   ReadEEprom SollFreq , EPAdr               'Sollfrequenz aus EEprom laden ***
 End If

  Salt = 0                                   'erzwinge S-Meterausgabe
  Gosub RdUREntry
 Return
'-------------------------------------------------------------------------------
KanalDat:

 Ausgabe = Txt26                             'K
 AkASCI = AktKanal + 48                      'Kanal-Ziffer berechnen
 KanTxt = Chr(AkASCI)                        'Kanal-String berechnen
 EPAdr = AktKanal                            'EEPROM Adresse berechnen
 Shift , EPAdr , Left , 1
 EPAdr = EPAdr + KanTab                      'Kanal 1 auf Adresse 94

Return
'-------------------------------------------------------------------------------
ReadAlert:

 If AlertTime > 20 Then                      'bei Bereichsberschreitung
   AlertTime = 5                             'Einstellung auf 5
 End If

 FoxTimeSec = FoxPerSec

#if AlertPer = 2
 FoxTime100 = FoxPer100
#endif

 Sek100stel = 0                              'Alert synchronisieren
 Gosub ClrSek
 LcdUpd = 2
 Return
'-------------------------------------------------------------------------------
LcdUpdate:                                   'Peiler 20:22,5 ms

'LZPuls = 1                                 'Laufzeittestsignal

 MinAusgabe = Minuten                        'Minuteneintrag und
 SekAusgabe = Sekunden                       'Sekundeneintrag fr ZeitAusgabe

#if URAnzeige > 0
 Home Upper                                  'obere LCD-Zeile fr USMet-Ausgabe whlen
 If URAakt > 0 Then                          '
   'Gosub URegMess                           'Regelspannungsmessung und
   Gosub URAusgabe                           'Ausgabe grundstzlich in der 2. Zeile
 Else                                        'sonst
   Gosub FrequenzAusgabe                     'Freuenzausgabe durchfhren
  #if UPDNButt = 1
   If DButtFlag = 0 Then
  #endif
     Home Lower                              'untere LCD-Zeile whlen
     Lcd KanTxt                              '1. Zeichen Kanalnummer
     Gosub ZeitAusgabe
  #if UPDNButt = 1
   End If
  #endif
 End If
#else
 Home Upper
 Gosub FrequenzAusgabe                       'Freuenzausgabe durchfhren
#if MinSW = 0
 Home Lower                                  'untere LCD-Zeile whlen
 Lcd KanTxt                                  '1. Zeichen Kanalnummer
 Gosub ZeitAusgabe                           'Zeitausgabe in jeder Sekunde
#endif
#endif

'LZPuls = 0                                 'Laufzeittestsignal

Return
'-------------------------------------------------------------------------------
FrequenzAusgabe:

 'LZPuls = 1                                'Laufzeit Start

 CountLo = SollFreq - ZFOffset               'SollFreq - ZF Offset in die Anzeigevariable holen

 CntStr = Str(CountLo)                       'Wert in String umwandeln

 AusgH = CntStr                              '3...<=1...Rest wird wieder berschrieben
 Komma = &H2E                                '4="."
 AusgL = FreqL                               '5..8=2...5

 Home Upper                                  'obere LCD-Zeile
 Lcd Ausgabe                                 'String ausgeben

 'LZPuls = 0                                'Laufzeit: 15,7 ms

 Goto ResetLCDupd                            'LCDupdFlag lschen und Return

'-------------------------------------------------------------------------------
#if FoxMem = 1
FoxAusgabe:

 If FBM = 1 Then                             'K1 gedr.
   Gosub DecrZwZAdr                          'Adresse um 2 decrementieren
 End If
 If FBM = 2 Then                             'K2 gedr. Adresse um 2 incrementieren
   Gosub IncrZwZAdr
   Gosub IncrZwZAdr
 End If
   If ZwZAdr => NxtZwZ Then
   ZwZAdr = 32                               'zyklischer Durchlauf nach oben
 End If
 If ZwZAdr < 32 Then
   Gosub NxtM2toZwZ                          'zyklischer Durchlauf nach unten
 End If

 FoxCnt = ZwZAdr - 30                        'Fox Nummer aus Adresse berechnen

 Gosub FoxNummer                             'Ein- und Ausgabe ber TmpVar

 If ZwZAdr = NxtZwZ Then
   If ZwZAdr = 32 Then FoxCnt = 0            '0 wenn noch keine Zeiten gespeichert
 End If

 Home Upper
 Lcd Txt11a                                  '"Fox" Ausgabestring beginnt mit "Fox"
 TmpVar = FoxCnt
 Gosub LcdbxVar2                             'Ausgabe mit 2 Stellen, fhrendes Blank
 Lcd Chr(47)                                 '"/"
 FoxCnt = NxtZwZ - 32                        'MaxFox Nummer aus NxtZwZ berechnen
 Gosub FoxNummer                             'Ein- und Ausgabe ber TmpVar
 TmpVar = FoxCnt
 Gosub Lcd0xVar                              'Ausgabe mit 2 Stellen, fhrendes Blank

 Gosub DoubleRead                            'Lesen der Zwischenzeit Werte aus EEPROM
 Gosub DecrZwZAdr                            'Adresse um 2 decrementieren

 If SekAusgabe > 59 Then SekAusgabe = 0      'Wegen leeren EEPROM Daten
 If MinAusgabe = 255 Then MinAusgabe = 0     'Wegen leeren EEPROM Daten

 Home Lower                                  'untere LCD-Zeile whlen   ###
 Gosub Lcd_Blank                             'Blank an der 1. Stelle und
#endif                                       'FoxMem=1
'-------------------------------------------------------------------------------
#if MinSW = 0
ZeitAusgabe:

 Lg = 4                                      'Stringlnge 4
ZeitAusg:
 TmpVar = MinAusgabe                         'Vorgabe der Variablen (Text1..3 stellig)
 Gosub Lcdbxvar                              'TmpTxt hier 4-stellig
SekAusg:
 TmpVar = SekAusgabe
 Gosub LcdSecTxt                             'Sekundenausgabe mit ":" voran

 Goto ResetLCDupd                            'LCDupdFlag lschen und Return
#endif                                       'MinSW=0
'-------------------------------------------------------------------------------
#if FoxMem = 1
FoxNummer:
 Shift FoxCnt , Right , 1                    'Dividiert durch 2
Return
'-------------------------------------------------------------------------------
DoubleRead:
 ReadEEprom MinAusgabe , ZwZAdr              'Lese Minutenwert aus EEPROM
 Gosub IncrZwZAdr
 ReadEEprom SekAusgabe , ZwZAdr              'Lese Sekundenwert aus EEPROM
'-------------------------------------------------------------------------------
IncrZwZAdr:
 Incr ZwZAdr                                 'aktuelle Zwischezeit Adresse incr.
Return
'-------------------------------------------------------------------------------
DecrZwZAdr:
 ZwZAdr = ZwZAdr - 2                         'aktuelle Zwischezeit Adresse um 2 decr.
Return
'-------------------------------------------------------------------------------
IncrNxtZwZ:
 Incr NxtZwZ                                 'Wert nchste freie Adresse incr.
 IF NxtZwZ > 93 Then NxtZwZ = 92             'Begrenzung auf 92
Return
'-------------------------------------------------------------------------------
GetNxtZwZ:                                   'Ermittlung des nchsten freien
 ZwZAdr = 32                                 '30 Zwischenzeiten ab Adresse 32
 While ZwZAdr < 93
   Gosub DoubleRead                          'lesen der beiden Eintrge
   If SekAusgabe = 255 Then Goto Found       'wenn Wert 255, Ende gefunden
 Wend
Found:
 Gosub DecrZwZAdr                            'Adresse wieder zurckstellen
ZwZ2Nxt:
 NxtZwZ = ZwZAdr                             'und NxtZwZ zuweisen
Return
'-------------------------------------------------------------------------------
NxtM2toZwZ:
 ZwZAdr = NxtZwZ - 2                         'aktuelle ZwzAdr auf NxtZwZ-2 stellen
Return
'-------------------------------------------------------------------------------
TimeErase:                                   'Lschen der Zwischenzeiten
 ZwZAdr = 32                                 'Adresse auf Bereichsanfang stellen
 While ZwZAdr < NxtZwZ
   WriteEEprom Empty , ZwZAdr                'Lschen aller Eintrge
   Gosub IncrZwZAdr
 Wend
 Gosub GetNxtZwZ                             'Zwischenzeitspeicheradresse rcksetzen
Return
#endif                                       'FoxMem = 1
'-------------------------------------------------------------------------------
OffsetOut:
 Home Upper
 Lcd Txt15                                   '"Off " erste 4 Zeichen
 Gosub LcdbxWord4                            'mit fhrenden Blanks
Return
'-------------------------------------------------------------------------------
ProgMode:                                    'Aufruf nach loslassen der Tasten

 If FBM = 1 Then Decr ChgVal                 'K1-Taste Vorgabewert reduzieren
 If FBM = 2 Then Incr ChgVal                 'K2-Taste Vorgabewert erhhen

#if MinSW = 0
 If Modus = 22 Then                          'Offsetprogrammierung

   If FBM = 5 Then                           'wenn BA + K1 gedrckt
     If Digit < 3 Then Incr Digit            'zu ndernde Stelle nach links schieben
   End If
   If FBM = 6 Then                           'wenn BA + K2 gedrckt
     If Digit > 1 Then Decr Digit            'zu ndernde Stelle nach links schieben
   End If

   Home Lower                                'untere LCD-Zeile
   Lcd Txt16                                 '"set " Textbeginn fr zweite LCD Zeile

'(
   NoSpc = 4 - Digit
   TmpTxt = "^       "
   Gosub PrintSpc
')

   If Digit = 1 Then
     Lcd Txt14a                              '"   ^" Textende fr zweite LCD Zeile
   End If
   If Digit = 2 Then
     Lcd Txt14b                              '"  ^ " Textende fr zweite LCD Zeile
   End If
   If Digit = 3 Then
     Lcd Txt14c                              '" ^  " Textende fr zweite LCD Zeile
   End If

   If FBM = 2 Then                           'Up-Button
     Gosub UpStep                            '+ Schritt ausfhren
   End If

   If FBM = 1 Then                           'Down-Button
     Gosub DnStep                            '- Schritt ausfhren
   End If

 End If
#endif                                       'MinSW=0

'-- Speichern der neuen Werte, Vorgabe fr nchsten Mode und Mode wechseln-----

 If FBM = 3 Then                             'K1- und K2-Taste waren gedrckt

   If Modus = 4 Then                         'bernehmen der aktuellen Fuchsnummer

    #if URAnzeige = 0
     ChgVal = TxPKor                         'Vorgabe TxPKor fr Modus 8
    #else
     ChgVal = URAnz                          'Vorgabe URAnz fr Modus 6
    #endif

   End If

  #if URAnzeige > 0
   If Modus = 6 Then                         'URAnzeige
     URAnz = ChgVal                          'bernahme der URAnz Einstellung
    #if TxPAdj = 0
     ChgVal = AlertTime                      'Vorgabe AlertTime fr Modus 10
    #else
     ChgVal = TxPKor                         'Vorgabe TxPKor fr Modus 8
    #endif
   End If
  #endif

  #if TxPAdj > 0
   If Modus = 8 Then                         'Tx-Power Korrektur
     TxPKor = ChgVal                         'bernahme des Tx-Power Korrekturwertes
     ChgVal = AlertTime                      'Vorgabe AlertTime fr Modus 10
   End If
  #endif

   If Modus = 10 Then                        'Warnton Zeitpunkt
     AlertTime = ChgVal                      'bernahme der AlertTime Einstellung

    #if AlertPer > 0
     ChgVal = FoxPerSec                      'Vorgabe Fuchslaufzeit fr Modus 12
     'Gosub ClrChgVal                         'Nullvorgabe Modus 12 Fuchslaufzeitnderung
    #else
     ChgVal = NoFoxes                        'Vorgabe Anzahl Fchse fr Modus 16
    #endif

   End If

  #if AlertPer > 0

   If Modus = 12 Then                        'Im Mode 12 Fuchslaufzeit Sekunden
     FoxPerSec = ChgVal                      'bernahme der Fuchslaufzeit Sekunden
     'Gosub ReadAlert                         'Warnton synchronisieren
     ChgVal = FoxPer100                      'Vorgabe Fuchslaufzeit/100 fr Modus 14
   End If

  #endif

  #if AlertPer = 2

   If Modus = 14 Then                        'Im Mode 14 Fuchslaufzeit Sec/100
     FoxPer100 = ChgVal                      'bernahme der Fuchslaufzeit/100 Sekunden
     'Gosub ReadAlert                         'Warnton synchronisieren
     ChgVal = NoFoxes                        'Vorgabe Anzahl Fchse fr Modus 16
   End If

  #endif

   If Modus = 16 Then                        'Anzahl Fchse
     NoFoxes = ChgVal                        'bernahme der NoFoxes Einstellung
     ChgVal = UBKor                          'Vorgabe UBKor fr Modus 18
   End If

   If Modus = 18 Then                        'UB-Calibrierung
     ChgVal = VRBufLen                       'Vorgabe VRBufLen fr Modus 20
   End If

  #if URAnzeige > 0
   If Modus = 20 Then                        'S-Meter Pufferlnge einstellen
     VRBufLen = ChgVal                       'bernahme der VRBufLen Einstellung
    #if MinSW = 0
     SollFreq = ZFOffset                     'Vorgaben fr Offseteinstellung Modus 20
     Digit = 1                               'beginne mit Digit 1
     Home Lower                              'untere LCD-Zeile
     Lcd Txt14                               '"set    ^   " Text fr zweite LCD Zeile
    #endif
   End If
  #endif

  #if MinSW = 0
   If Modus = 22 Then                        'Offset Einstellung
     ZFOffset = SollFreq                     'eingestellten Sollwert als ZFOffset bernehmen
   End If
  #endif

   Gosub WriteEprDaten                       'Vernderte Daten in EEPROM schreiben
   Gosub NxtModus                            'in nchsten MODUS wechseln

 End If

AnzPMode:

'-- Aufbereitung und Anzeige der voreingestellten Daten (vor bernahme) --------

 Home Upper

 If Modus = 4 Then                           'Synchronisieren des Fuchstimers

   Tmp = NoFoxes
   Gosub LimitChgVal                         'Begrenzung oben auf 0...NoFoxes
   Lcd Txt11                                 '"SetFox" Beginn 1. Zeile
   Gosub DsplChgVal                          'Fuchsnummer und 2. Zeile anzeigen

 End If

#if URAnzeige > 0
 If Modus = 6 Then

   Tmp = 17
   Gosub LimitChgVal                         'Begrenzung auf 0...17

   IF ChgVal > 1 Then
     LCD Chr(80)                             '"P"
     LCD Txt02a                              '"-Fox:"
     Gosub LcdChgVal
     Home Lower

     EPA = ChgVal
     Gosub Ito0
     While EPA > 5
       EPA = EPA - 6
       Gosub IncrI
     Wend

     'Epa = EPA + TxPTab                     'TxPTab Start
     EPA256 = EPA + 506                      'TxPTab Start
     Temp = 300
     IF EPA > 0 Then
       ReadEEprom Tmp , EPA256               'Lesen des TxPowerwertes
       Temp = Tmp
     End If

     Gosub LcdbxWord4

     Select Case I
       Case 1 : LCD Chr(109)                 '"m"
       Case 2 : LCD Chr(117)                 '"u"
     End Select

     LCD Chr(87)                             '"W"
     LCD Blnk4

   Else

     Lcd Txt21                               '"URAnz:"
     Gosub LcdChgVal
     Home Lower

     IF ChgVal = 0 Then
       LCD Txt01                             '"KeinSMet"
     Else
       LCD Txt24                             ' (db)"Att"
       LCD Blnk4
     End If

   End If

 End If
#endif

 If Modus = 8 Then

   Tmp = 6
   Gosub LimitChgVal                         'Begrenzung auf 0...6
   Lcd Txt27                                 '"TxPKor"

   TXPA = ChgVal - 3
   IF TXPA = 0 Then
     LCD " 0"
   Else
     IF TXPA < 10 Then
       LCD "+" ; TXPA
     Else
       TXPA = 256 - TXPA
       LCD "-" ; TXPA
     End If
   End If
   LCD CHR(4)

   Gosub DsplLower                           '2. Zeile anzeigen

 End If

 If Modus = 10 Then                          'AlertTime Einstellung

   Tmp = 20
   Gosub LimitChgVal                         'Begrenzung oben auf 0...20

   Lcd Txt20                                 '"PIP: " Text fr Beginn der 1. Zeile

   Gosub DsplChgVal                          'AlertTime und 2. Zeile anzeigen

 End If

 'Einstellung der Periodenlnge fr den Warnton

#if AlertPer = 1

 If Modus = 12 Then                          'Fuchslaufzeit

   Tmp = 99
   Gosub LimitChgVal                         'Begrenzung oben auf 99 sec

   LCD Chr(84)                               '"T"
   Lcd Txt02a                                '"-Fox:" 1. Zeile

   Gosub DsplChgVal                          'Anzahl Fchse und 2. Zeile anzeigen
   LCD Blnk2

 End If

#endif

#if AlertPer = 2

 If Modus = 12 Then                          'Fuchslaufzeit

   Gosub FoxPerHdr

   LCD Chr(62)                               '1. Zeichen ">"
   'TmpVar = ChgVal
   Gosub Lcd0ChgVal                          'Anzeige Fuchslaufzeit Sekunden
   LCD Txt25                                 '4. u. 5. Zeichen "<,"
   TmpVar = FoxPer100
   Gosub Lcd0xVar                            'Anzeige Fuchslaufzeit/100 Sekunden
   Gosub Lcd_Blank                           '8. Zeichen " "

 End If

 If Modus = 14 Then                          'Fuchslaufzeit

   Gosub FoxPerHdr

   Gosub Lcd_Blank                           '1. Zeichen " "
   TmpVar = FoxPerSec
   Gosub Lcd0xVar                            'Anzeige Fuchslaufzeit Sekunden
   LCD Txt12                                 '4. u. 5. Zeichen ",>"
   'TmpVar = ChgVal
   Gosub Lcd0ChgVal                          'Anzeige Fuchslaufzeit/100 Sekunden
   LCD Chr(60)                               '8. Zeichen "<"

 End If

#endif

 If Modus = 16 Then                          'Anzahl Fchse Anzeige

   Tmp = 10
   Gosub LimitChgVal                         'Begrenzung oben auf 0...10

   Lcd Txt02                                 '"N-Fox"

   Gosub DsplChgVal                          'Anzahl Fchse und 2. Zeile anzeigen

 End If

#if MinSW = 0
 If Modus = 18 Then

   Lcd Txt04                                 '"CalUB:"
   UBKor = ChgVal
   LCD UBKor
   Gosub UBAusgabe

 End If
#endif

#if URAnzeige > 0
 If Modus = 20 Then

   Tmp = 30
   Gosub LimitChgVal                         'Begrenzung auf 0...30

   Lcd Txt18                                 '"VRBuf:"

   Gosub DsplChgVal                          'Anzahl Fchse und 2. Zeile anzeigen

 End If
#endif

#if MinSW = 0
 If Modus = 22 Then

   Fmin = 4000                               'unterer Grenzwert fr Offset = 400,0 KHz
   Fmax = 5000                               'oberer Grenzwert fr Offset = 500,0 KHz
   'Fmin = 0                                  'unterer Grenzwert fr Offset = 0
   'Fmax = 9999                               'oberer Grenzwert fr Offset = 999.9 KHz

   Temp = SollFreq
   Gosub OffsetOut                           'Offset Ausgabe

 End If
#endif

 If Modus = 24 Then

   Gosub ReadEprDaten
   Gosub SetModus1                           'in MODUS 1 wechseln

 End If

Return
'-------------------------------------------------------------------------------
#if AlertPer = 2
FoxPerHdr:

 Tmp = 99
 Gosub LimitChgVal                           'Begrenzung oben auf 99 sec

 LCD Chr(84)                                 '"T"
 Lcd Txt02a                                  '"-Fox:" 1. Zeile
 LCD Blnk2
 Home Lower

Return
#endif
'-------------------------------------------------------------------------------
DsplChgVal:

 Gosub LcdChgVal                             'nderungswert 2 stellig

DsplLower:

 Home Lower
 Lcd Txt08                                   '"K1-  K2+"

Return
'-------------------------------------------------------------------------------
LimitChgVal:                                 'ChgVal begrenzen 0...Tmp
 IF ChgVal > 200 Then ChgVal = Tmp           '< 0   -> Max
 If ChgVal > Tmp Then ChgVal = 0             '> Tmp -> 0
Return
'-------------------------------------------------------------------------------
Lcd_Blank:
 Lcd Chr(32)                                 '" "
Return
'-------------------------------------------------------------------------------
NxtModus:

 Modus = Modus + 2                           'in nchsten MODUS wechseln

#if URAnzeige = 0
 If Modus = 6 Then Goto NxtModus             'berspringe URAnz u. P-Fox Einstellung
#endif

#if TxPAdj = 0
 If Modus = 8 Then Goto NxtModus             'berspringe TX-Power Korektur
#endif

#if AlertPer = 0
 If Modus = 12 Then Modus = Modus + 4        'berspringe FoxPer Einstellung
#endif

#if AlertPer = 1
 If Modus = 14 Then Goto NxtModus            'berspringe FoxPer 100stel Sec Einstellung
#endif

#if MinSW = 1
 If Modus = 18 Then Goto NxtModus            'berspringe UB Cal
 If Modus = 22 Then Goto NxtModus            'berspringe Offset Prog
#endif

Return
'-------------------------------------------------------------------------------
IncrI:
 Incr I                                      'Zhl-Variable I incr.
Return
'-------------------------------------------------------------------------------
#if MinSW = 0
UhrMenu:

 Home Upper                                  'obere LCD-Zeile
 Lcd Txt06                                   '"  UHR   "
 Home Lower
 Lcd Txt07                                   '"STP  RES" 2.Zeile

Return
'-------------------------------------------------------------------------------
BminAnzeige:

 Home Upper                                  'obere LCD-Zeile
 Lcd Txt09                                   '"BETRIEB:"
 Home Lower
 Gosub Lcd_Blank                             '2.Zeile
 Lcd Bmin
 Lcd Txt22                                   '" min  "

Return
#endif                                       'MinSW=0
'-------------------------------------------------------------------------------
'LcdChgVal:                                   'Formatiere Byte-Variable in Text
' TmpVar = ChgVal
Lcdxbvar:                                    'Formatiere Variable in Text
 Gosub TmpVar2TmpTxt
FmtxbTxt:                                    'Formatiere Text auf 2 Stellen mit Blank am Ende
 Gosub LcdTmpTxt
 If TmpLen < 2 Then Gosub Lcd_Blank
Return
'-------------------------------------------------------------------------------
Lcd0ChgVal:                                  'Formatiere Byte-Variable in Text
 TmpVar = ChgVal
 Goto Lcd0xVar
LcdSecTxt:                                   'Formatiere Text fr ZeitAusgabe mit :
 Lcd Chr(58)                                 '":"
Lcd0xVar:                                    'Formatiere Variable in Text
 Gosub TmpVar2TmpTxt
 If TmpLen < 2 Then Lcd Chr(48)              '"0"
 Gosub LcdTmpTxt
Return
 '-------------------------------------------------------------------------------
'Tmp2TmpTxt:
' TmpVar = Tmp
TmpVar2TmpTxt:
 TmpTxt = Str(TmpVar)                        'TmpVar in Text umwandeln
GetTmpLen:
 TmpLen = Len(TmpTxt)                        'Lnge des Strings in TmpLen
Return
'-------------------------------------------------------------------------------
'Lcdbxtmp:
' TmpVar = Tmp
LcdChgVal:                                   'Ausgabe ChgVal auf 2 Stellen
 TmpVar = ChgVal
LcdbxVar2:                                   'Ausgabe TmpVar auf 2 Stellen
  Lg = 2
Lcdbxvar:                                    'Formatiere Byte-Variable in Text
 Gosub TmpVar2TmpTxt
'FmtbxTxt:
'NoSpc = Lg - TmpLen
Goto LcdSpTmpTxt                             'Ausgabe mit fhrenden Blanks
 '-------------------------------------------------------------------------------
LcdbxWord4:                                  'Formatiere Word-Variable in Text
 Lg = 4                                      'auf 4 Stellen mit fhrendem Blank
LcdbxWord:                                   'Formatiere Word-Variable in Text
 'GOSUB Temp2TmpTxt
 TmpTxt = Str(Temp)                          'auf Lg Stellen mit fhrendem Blank
 Gosub GetTmpLen
LcdSpTmpTxt:                                 'Ausgabe mit fhrenden Blanks
 NoSpc = Lg - TmpLen
Printspc:
 Decr NoSpc
'Lcd Space(NoSpc)
 While NoSpc < 128
   Gosub Lcd_Blank
   Decr NoSpc
 Wend
 LcdTmpTxt:
 Lcd TmpTxt
Return
'-------------------------------------------------------------------------------
#if MinSW = 0
UBAusgabe:

 Gosub BattTest                              'Messung der Batteriespannung

UBAusgabe2:

 UBTxt = Str(UBatt)                          'Spannungswert in String umwandeln

 Home Lower

 Lcd Txt04a                                  '"UB" Text fr Beginn der Zeile
 If UBatt < 1000 Then                        'Formatierung des Wertes vor dem Komma
   Lcd Chr(61)                               '"=" Text fr Beginn der Zeile
   TmpTxt = UBTxt3                           'rette Nachkommastellen
   EoStr3 = 0                                'setze End of String fr 1 Vorkommastelle
   'Lcd Left(TmpTxt , 1)                      'einstellig
 Else
   TmpTxt = UBTxt4                           'rette Nachkommastellen
   EoStr4 = 0                                'setze End of String fr 2 Vorkommastellen
   'Lcd Left(TmpTxt , 2)                      'zweistellig
 End If
 LCD UBTxt                                   '1 oder 2 Vorkommastellen
 Lcd Chr(44)                                 '"," Komma anfgen
 LCD TmpTxt                                  '2 Nachkommastellen
 'Lcd Right(TmpTxt , 2)                       'Formatierung des Wertes nach dem Komma
 Lcd Chr(86)                                 '"V" anfgen
#endif                                       'MinSW=0

ResetLCDupd:
 LcdUpd = 0                                  'Flag: LCDausgabe durchgefhrt
 Return
'-------------------------------------------------------------------------------
#if URAnzeige > 0

GetURAakt:
 URAakt = URAnz
Return
'-------------------------------------------------------------------------------
URegMess:                                    'Regelspannungsmessung

 Start Adc                                   'Starte ADC

#if Variante = 1                             'AtMega8 SMD mit DIPS0802, Rechtshnder
 URegIn = Getadc(7)                          'Regelspannung
#endif

#if Variante = 2                             'AtMega8 SMD mit DIPS0802, Linkshnder
 URegIn = Getadc(7)                          'Regelspannung
#endif

#if Variante = 3                             'AtMega8 DIP mit aMC0802C
 URegIn = Getadc(1)                          'Regelspannung
#endif

#IF Variante = 4                             'AtMega8 SMD mit DIPS0802, alte Hardware
 URegIn = Getadc(2)                          'Regelspannung
#endif

 Stop Adc                                    'Stopp ADC

 IF URegIn > 255 Then URegIn = 255           'Begrenzung

Return                                       'Regelspannungswertes
'-------------------------------------------------------------------------------
URAusgabe:

 Home Upper                                  'in der 1. Zeile

 If FoxNr < 9 Then                           'Fuchsnummern 1...9
   LCD FoxNr                                 'normal ausgeben
 Else                                        'Fuchsnummer 10
   LCD Chr(48)                               'als "0" ausgeben
 End If

 SekAusgabe = FoxTimeSec
 Gosub SekAusg                               '2. bis 4. Zeichen: 1:23

 IF URReg = 0 Then                           '5. Zeichen
   Gosub Lcd_Blank
 End If
 IF URReg = 1 Then                           '5. Zeichen
   LCD Chr(42)                               '"*"
 End If
 IF URReg = 2 Then                           '5. Zeichen
   LCD Chr(35)                               '"#"
 End If

#if URAnzeige = 1                            'Dmpfungsanzeige in dB
 Lg = 2
 TmpVar = URegPtr - DstTbl
 Gosub LcdbxVar                              'TmpVar = Dmpfungswert 6.u.7. Zeichen
 Lcd Chr(4)                                  '8. Zeichen "dB"
#endif

#if URAnzeige = 2                            'Entfernungsanzeige

 TmpTxt = ""
 If URAakt > 1 Then

   Txpoffset = URAakt - 2
  #if Peiler > 20
   IF SBTaste = 1 Then Decr Txpoffset        'Korrektur bei gerdrckter SB-Taste
  #endif
   Txpoffset = Txpoffset * 5
   EPA = URegPtr + 1                         'Epa auf Textbeginn
   EPA = EPA + Txpoffset                     'ggf. verschieben

   If EPA < 128 Then EPA = 252               '>256 = <128, Ausgabe letzter String
   'If EPA > 128 Then                         '>256 = <128, Ende letzter String

     Do
       Gosub ReadEpr                         'EEPROM lesen
       TmpTxt = TmpTxt + Chr(Tmp)
       Gosub IncrEpa
     Loop Until Tmp = 0

   'End If

 End If

 Gosub GetTmpLen

 If TmpLen = 3 Then                          'wenn Entfernungstext 3-stellig
   Gosub LcdTmpTxt                           'Entfernungsanzeige 6. bis 8. Zeichen
 Else                                        'sonst, wegen "x"
   Lg = 2                                    'Dmpfungsanzeige
   'TmpVar = URegPtr - DstTab
   TmpVar = URegPtr - 131
   Gosub LcdbxVar                            'TmpVar = Dmpfungswert 6.u.7. Zeichen
   LCD Chr(4)                                ' (dbm)
 End If

#endif

GOTO ResetLCDupd
'-------------------------------------------------------------------------------
IncrURegPtr:

   IF URegPtr < 247 Then
     URegPtr = URegPtr + 5
   Else
     CalMode = 0                             'Beenden des Calibriermode
   End If

Return
'-------------------------------------------------------------------------------
URegProc:

 Gosub URegMess

 IF URegIn > 250 Then                        'max. Att.
   MinAusgabe = Minuten                      'Minuteneintrag und
   SekAusgabe = Sekunden                     'Sekundeneintrag fr ZeitAusgabe
   Home Upper
   LCD FoxNr
   Gosub ZeitAusgabe                         'Zeitausgabe und
   Gosub UBAusgabe                           'Batterieanzeige
   Return
 End If

 DURegIn = OldUReg - URegIn                  'Flattern der Anzeige verhindern
 IF DURegIn > 128 Then DURegIn = 255 - DURegIn

 IF DURegIn < 2 Then

   IF URReg = 0 Then
     Return
   Else
     IF URReg = 2 Then
      #if Peiler > 20
       IF SBTaste = 0 Then Return            'SB-Tastenabfrage
      #else
       Return
      #endif
     End If
   End If

   IF SMwrPtr <> 1 Then Return

   IF Srg > 11 Then                          'Einsatzgrenze der Regelung oben
     Gosub IncrURegPtr
   End If
   IF VRBufLen.0 = 1 Then
     IF Srg < 5 Then                         'Einsatzgrenze der Regelung unten
       IF URegPtr > 135 Then URegPtr = URegPtr - 5
     End If
   End If

 Else

   LcdUpd = 2                                'Entf. Angabe aktualisieren
   OldUreg = URegIn

  'URegPtr = DstTbl
   URegPtr = 131
   'IF URegIn > 5 Then URegIn = URegIn - 5
   While URegIn > URdiv1
     URegIn = URegIn - URdiv
     Gosub IncrURegPtr
   Wend
   Salt = 0                                  'erzwinge S-Meterausgabe

 End If

RdUREntry:

 ReadEEprom OCR2 , URegPtr                   'Hole zugerigen UReg Eintrag
 TmpVar2 = OCR2                              'speichern fr CalMode Ausgabe

SetGain:

#if RXTyp = 2
#if FETVST = 0
#if Peiler > 20
 IF URegPtr > LowGainPTR Then
   IF ATTPort = 0 Then
     Srg = 8
   End If
   ATTPort = 1                               'Output: NE612-Low-Gain
 Else
   IF ATTPort = 1 Then
     Srg = 8
   End If
   ATTPort = 0                               'Input: NE612-High-Gain
 End If
#else
 IF URegPtr > LowGainPTR Then
   'IF PinD.4 = 1 Then
   IF ATTPort = 1 Then
     Gosub SetUSMdly
     Srg = 8
   End If
   ATTPort = 0                               'LM386-Gain=20
 Else
   'IF PinD.4 = 0 Then
   IF ATTPort = 0 Then
     Gosub SetUSMdly
     Srg = 8
   End If
   ATTPort = 1                               'LM386-Gain=200
 End If
#endif
#endif

#if FETVST = 1
 IF URegPtr > LowGainPTR Then
   IF ATTPort = 1 Then
     Srg = 8
   End If
   ATTPort = 0                               'Port Low: Low-Gain
 Else
   IF ATTPort = 0 Then
     Srg = 8
   End If
   ATTPort = 1                               'Port High: High-Gain
 End If
#endif
#endif

Return
'-------------------------------------------------------------------------------
USMausgabe:                                  'Messung der gleichgerichteten NF-Spannung

 'LZPuls = 1                                 'Laufzeittest Start

 Start Adc                                   'Starte ADC

#if Variante = 1                             'AtMega8 SMD mit DIPS0802, Rechtshnder
 USMet = Getadc(2)                           'Messe S-Meterspannung an PC2
#endif

#if Variante = 2                             'AtMega8 SMD mit DIPS0802, Linkshnder
 USMet = Getadc(0)                           'Messe S-Meterspannung an PC0
#endif

#if Variante = 3                             'AtMega8 DIP mit aMC0802C
 USMet = Getadc(0)                           'Messe S-Meterspannung an PC0
#endif

#IF Variante = 4                             'AtMega8 SMD mit DIPS0802, alte Hardware
 USMet = Getadc(7)                           'Messe S-Meterspannung
#endif

 Stop Adc                                    'Stopp ADC

 'LZPuls = 0                                 'Laufzeit: 253 us

 IF USMet > 255 Then USMet = 255             'Begrenzung
 USM = USMet
 EPA = SMtTab + TxPKor                       'Tabellenstart bei 106 + TxPKor
 GetSMW:                                     'Ende durch Eintrag 255
 Gosub ReadEpr                               'EEPROM lesen bei Adresse EPA
 Gosub IncrEpa
 If USM > Tmp Then Goto GetSMW               'S-Wert bestimmen
 S = EPA - SMtTab                            'S = 1 bis 16
 S = S - TxPKor
 'S = S - 1

 IF SMwrPtr < VRBufLen Then                  'S-Meter RingPuffer Lnge P fllen
   Incr SMwrPtr
 Else
  SMwrPtr = 1
 End If
 SMetRP(SMwrPtr) = S

 SMrdPtr = 1                                 'Maximalwert aus Ringpuffer bestimmen
' (
 Srg = 0
 While SMrdPtr <= VRBufLen                   'P+1
   Tmp = SMetRP(SMrdPtr)
   IF Tmp > Srg Then
     Srg = Tmp
   End If
   Incr SMrdPtr
 Wend

  'LZPuls = 0                                 'Laufzeit: 363 bis 526 us

 IF DspUSM > 0 Then                          'Anzeige der USM-Werte
   Home Lower                                'in der 2. Zeile
   'Temp = USMet
   Temp = USM
   'Temp = S
   Gosub LCDbxWord4
   LCD Blnk4
   Return
 End If

 If S <> Salt Then
   Salt = S

 Home Lower                                  'in der 2. Zeile

 'LZPuls = 1                                 'Laufzeittest Start

#if Variante = 1 OR Variante = 4             'AtMega8 SMD mit DIPS0802, Rechtshnder

 I = 25                                      'Feldstrkebalken von rechts nach links
 S = S + 10
 While I > 10                                'Ausgabe von 8 Zeichen: 15,2 ms
   IF S = I Then
     Lcd Chr(1)                              'ein Balken
   Else
     IF S < I Then
       Gosub Lcd_Blank
     Else
       Lcd Chr(2)                            'zwei Balken
     End If
   End If
   I = I - 2                                 'I = I + 1
 Wend

#endif

#if Variante = 2                             'AtMega8 SMD mit DIPS0802, Linkshnder

 Gosub Ito0                                  'Feldstrkebalken von links nach rechts
 Gosub IncrI                                 'I = I + 1
 While I < 16                                'Ausgabe von 8 Zeichen: 15,2 ms
   IF S = I Then
     Lcd Chr(1)                              'ein Balken
   Else
     IF I < S Then
       Lcd Chr(2)                            'zwei Balken
     Else
       Lcd Chr(32)                           'Blanks
     End If
   End If
   Gosub IncrI                               'I = I + 1
   Gosub IncrI                               'I = I + 1
 Wend

#endif

 'LZPuls = 0                                 'Laufzeit: 15,2 ms

 End If

 Return
#endif                                       'URAnzeige > 0
'-------------------------------------------------------------------------------
ReadCButt:

#if Variante = 1                             'AtMega8 SMD mit DIPS0802, Rechtshnder
 CButt = 255
 CButt.2 = PinC.1                            'BA-Button, PC1
 CButt.0 = PinD.7                            'K1-Button, PD7
 CButt.1 = PinD.6                            'K2-Button, PD6
 CButt = Not CButt                           'invertiere zu aktiv high
#endif

#if Variante = 2                             'AtMega8 SMD mit DIPS0802, Linkshnder
 CButt = 255
 CButt.2 = PinB.5                            'BA-Button, PB5
 CButt.0 = PinD.7                            'K1-Button, PD7
 CButt.1 = PinD.6                            'K2-Button, PD6
 CButt = Not CButt                           'invertiere zu aktiv high
#endif

#if Variante = 3                             'AtMega8 DIP mit aMC0802C
 'Cbutt = Pinc Or &B11111000                  'BA-, K2- und K1-Buttons
 'Cbutt = Not CButt                           'invertiere zu aktiv high
#endif

#IF Variante = 4                             'AtMega8 SMD mit DIPS0802, alte Hardware
 CButt = PinD Or &B11111011                  'BA-Button
 CButt.0 = PinC.0                            'K1-Button
 CButt.1 = PinC.1                            'K2-Button
 CButt = Not CButt                           'invertiere zu aktiv high
#endif

 IF CButt > 0 Then Waitms 10                 'Repeatloop-Wartezeit wenn Taste gedrckt

 Select Case ButtTime                        'Beeps in Folge ausgeben
   Case 1 : Gosub Beep                       '
   Case 100 : Gosub Beep                     '
   Case 150 : Gosub Beep                     '
   Case 200 : Gosub Beep                     '
  #if FoxMem = 1
   Case 250 : Gosub Beep                     '
  #endif
 End Select

Return
'-------------------------------------------------------------------------------
#if UPDNButt = 1
ReadDButt:

 If DButtDelay = 0 Then

  #if Variante = 1                           'AtMega8 SMD mit DIPS0802, Rechtshnder
   DButt = PinD Or &B11100111                'DN-PD3, UP-PD4, Buttons
   DButt = Not DButt                         'invertiere zu aktiv high
  #endif

  #if Variante = 2                           'AtMega8 SMD mit DIPS0802, Linkshnder
   DButt = PinC Or &B11110011                'DN-PC2, UP-PC3, Buttons
   DButt = Not DButt                         'invertiere zu aktiv high
  #endif

  #if Variante = 3                           'AtMega8 DIP mit aMC0802C
   'Dbutt = PinD Or &B11110011                'DN-, UP-Buttons
   'Dbutt = Not DButt                         'invertiere zu aktiv high
  #endif

  #IF Variante = 4                           'AtMega8 SMD mit DIPS0802, alte Hardware
   DButt = PinC Or &B11100111                'UP-, DN-Buttons
   DButt = Not DButt                         'invertiere zu aktiv high
  #endif

   If DButt > 0 Then                         'D-Taste gedrckt

     Gosub SetDspDly                         'DspDly = 1 Sec
     Digit = 1
     DButtDelay = 5                          'nderungsgeschwindigkeit
     DButtFlag = 1
     Ausgabe = Txt18a
     URAakt = 0

    #if Variante = 1                         'AtMega8 SMD mit DIPS0802, Rechtshnder
     If DButt = 16 Then                      'Up-Button nur 100 Hz
       Gosub UpStep                          '1. Stelle    +1
     End If
     If DButt = 8 Then                       'Down-Button  nur 100 Hz
       Gosub DnStep                          '1. Stelle    -1
     End If
    #endif

    #if Variante = 2                         'AtMega8 SMD mit DIPS0802, Linkshnder
     If DButt = 8 Then                       'Up-Button nur 100 Hz
       Gosub UpStep                          '1. Stelle    +1
     End If
     If DButt = 4 Then                       'Down-Button  nur 100 Hz
       Gosub DnStep                          '1. Stelle    -1
     End If
    #endif

    #if Variante = 3                         'AtMega8 DIP mit aMC0802C
     If DButt = 8 Then                       'Up-Button nur 100 Hz
       Gosub UpStep                          '1. Stelle    +1
     End If
     If DButt = 16 Then                      'Down-Button  nur 100 Hz
       Gosub DnStep                          '1. Stelle    -1
     End If
    #endif

    #IF Variante = 4                         'AtMega8 SMD mit DIPS0802, alte Hardware
     If DButt = 8 Then                       'Up-Button nur 100 Hz
       Gosub UpStep                          '1. Stelle    +1
     End If
     If DButt = 16 Then                      'Down-Button  nur 100 Hz
       Gosub DnStep                          '1. Stelle    -1
     End If
    #endif

     KanTxt = Chr(88)                        '"X" Kanalnummer ungltig machen
     LcdUpd = 2

   End If

 Else
   Decr DButtDelay
 End If

Return
'-------------------------------------------------------------------------------
UpStep:

 SollFreq = SollFreq + Stp(Digit)            'addiere Schrittweite
 If SollFreq > Fmax Then
   SollFreq = Fmax                           'Begrenzung auf Fmax
 End If

 Goto StpDisplay                             'nderung anzeigen

DnStep:

 SollFreq = SollFreq - Stp(Digit)            'addiere Schrittweite
 If SollFreq < Fmin Then                     'Begrenzung auf Fmin
   SollFreq = Fmin                           'bei der Offset Einstellung
 End If

StpDisplay:

 If Modus = 20 Then                          'im Offset Mode
   Goto OffsetOut                            'Anzeige im Offset Format
 End If
 Gosub FrequenzAusgabe                       'sonst Frequenz Format

Return
#endif                                       'UPDNButt=1
'-------------------------------------------------------------------------------
#if MinSW = 0
BattTest:                                    'Batterietest

 'LZPuls = 1                                 'Laufzeit: 253 us

 Start Adc                                   'Starte ADC

#if Variante = 1                             'AtMega8 SMD mit DIPS0802, Rechtshnder
 UBatt = Getadc(6)                           'Batteriespannung
#endif

#if Variante = 2                             'AtMega8 SMD mit DIPS0802, Linkshnder
 UBatt = Getadc(6)                           'Batteriespannung
#endif

#if Variante = 3                             'AtMega8 DIP mit aMC0802C
 UBatt = Getadc(2)                           'Batteriespannung
#endif

#IF Variante = 4                             'AtMega8 SMD mit DIPS0802, alte Hardware
 UBatt = Getadc(6)                           'Batteriespannung
#endif

 Stop Adc                                    'Stopp ADC

 'LZPuls = 0                                 'Laufzeittestsignal

 UBatt = UBatt - 128                         'Korrekturwert addieren
 UBatt = UBatt + UBKor                       'Korrekturwert addieren

#if UbBer = 2
 Shift , UBatt , Left , 1                    'x 2 fr Spannungen bis 20,46 V
#endif

Return
#endif                                       'MinSW=0
'-------------------------------------------------------------------------------
Beep:

#if Peiler > 20
 Mute = 1                                    'Mute ein
#else
 Gosub SetUSMdly                             'Keine USM-Messung nach Beep
#endif

 Gosub Ito0

 Do
   Gosub BeepCycle
   BeepPort = 1
   Gosub BeepCycle
   BeepPort = 0
   Gosub IncrI
 Loop Until I = 100

 Alert = 0

#if Peiler > 20
 Mute = 0                                    'Mute aus
#else
 GOSUB SetGain                               'Richtigstellen der LM386-Gain
#endif

Return
'-------------------------------------------------------------------------------
BeepCycle:
 Waitus 250                                  'Tonhhe 2 KHz
Return
'-------------------------------------------------------------------------------
Waitms200:
 Waitms 200
Return
'-------------------------------------------------------------------------------
#if Peiler < 21
SetUSMdly:
 USMDelay = 30
Return
#endif
'-------------------------------------------------------------------------------
Ito0:
 I = 0                                       'Zhlvariable I auf 0 setzen
Return
'-------------------------------------------------------------------------------
SetDspDly:
 DspDly = 100                                'Displaydelay auf 100/100 Sekunden setzen
Return
'-------------------------------------------------------------------------------
ClrSek:
 Sekunden = 0                                'Reset Sekunden
Return
'-------------------------------------------------------------------------------
WriteEprDaten:                               'EEPROM Daten schreiben
 WrFlag = 1                                  'Write-Flag setzen
'-------------------------------------------------------------------------------
ReadEprDaten:                                'EEPROM Daten lesen
 EPA = 1                                     'ab Adresse 1
 Do
   Gosub ReadEpr
   If WrFlag = 1 Then                        'wenn geschrieben werden soll und
     If EprDat(EPA) <> Tmp Then              'Daten gegenber dem EEPROM gendert wurden
       Disable Interrupts
       WriteEEprom EprDat(EPA) , EPA         'Daten schreiben
       Enable Interrupts
     End If
   Else
     EprDat(EPA) = Tmp                       'Gelesene Daten ins RAM schreiben
   End If
   Gosub IncrEpa
 Loop Until EPA = 32
 WrFlag = 0                                  'Write Flag lschen
Return
'-------------------------------------------------------------------------------
ReadEpr:                                     'EEPROM lesen
 ReadEEprom Tmp , EPA                        'Lesen des Eprominhaltes
Return
'-------------------------------------------------------------------------------
IncrEpa:
 Incr EPA                                    'Epromadresse incr.
Return
'-------------------------------------------------------------------------------
#if DebugMode = 1
DspVar1:                                     'Debug Ausgabe von DebVar
 Locate 1 , 1                                'auf Zeile 1, Stelle 1
 Goto Disp
'-------------------------------------------------------------------------------
DspVar2:                                     'Debug Ausgabe von DebVar
 Locate 2 , 1                                'auf Zeile 2, Stelle 1
Disp:
 Lcd DebVar
 Lcd Blnk6                                   '"      "
Return
#endif
'-------------------------------------------------------------------------------
'$EEPLEAVE

$eeprom
'Speicher fr 32 permanente Variablen im EEPROM
Data &HFF , &HFF , &HFF , &HFF               'frei
Data &HFF , &HFF , &HFF , &HFF               'frei
Data &HFF , &HFF , &HFF , &HFF               'frei
Data OffsetLo , OffsetHi                     'ZF Offset
Data &H19                                    'Pufferlnge fr Verstrkungsregelung
Data URegAnz                                 'URAnz 0=Aus, 1=dB, 2...17=30W...1uW
Data UBatKor                                 'Korrekturwert fr UB-Anzeige 128 > 0
Data &H3C                                    'FoxPerSec 60
Data &H00                                    'FoxPer100 0
Data &H05                                    'AlertTime 5
Data &H05                                    'Anzahl Fchse
Data &H00 , &H00                             'Betriebsminuten
Data &HFF , &HFF                             'SpareWord1
Data &HFF , &HFF                             'SpareWord1
Data &H00                                    '00 Uhr startet sofort, 01 manueller Uhr Start
Data &H03                                    'TxpKor 0...3...6 -> -3...0...+3
Data &HFF                                    'SpareByte3
Data &HFF                                    'SpareByte2
Data &HFF                                    'SpareByte1

'Fuchszeitenspeicher fr 30 Zwischenzeiten
Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF       ' 32 bis  39
Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF       ' 40 bis  47
Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF       ' 48 bis  55
Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF       ' 56 bis  63
Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF       ' 64 bis  71
Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF       ' 72 bis  79
Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF       ' 80 bis  87
Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF ,       ' 88 bis  93

'Kanalspeicher fr 6 Kanle
Const K1 = 35795 + Offset                    'Frequenz/100 [Hz] + Offset
Const K1Hi = Int(K1 / 256)
Const K1Lo = K1 - K1Hi * 256
Const K2 = 36000 + Offset
Const K2Hi = Int(K2 / 256)
Const K2Lo = K2 - K2Hi * 256
Const K3 = 35600 + Offset
Const K3Hi = Int(K3 / 256)
Const K3Lo = K3 - K3Hi * 256
Const K4 = 35000 + Offset
Const K4Hi = Int(K4 / 256)
Const K4Lo = K4 - K4Hi * 256
Const K5 = 37000 + Offset
Const K5Hi = Int(K5 / 256)
Const K5Lo = K5 - K5Hi * 256
Const K6 = 35500 + Offset
Const K6Hi = Int(K6 / 256)
Const K6Lo = K6 - K6Hi * 256

Data K1Lo , K1Hi
Data K2Lo , K2Hi
Data K3Lo , K3Hi
Data K4Lo , K4Hi
Data K5Lo , K5Hi
Data K6Lo , K6Hi

'Data &H85 , &H9D                             'Kanal 1: (35795+4530)=40325
'Data &H52 , &H9E                             'Kanal 2: (36000+4530)=40530
'Data &H46 , &HA0                             'Kanal 3: (36500+4530)=41030
'Data &H85 , &H9D                             'Kanal 4: (35795+4530)=40325
'Data &H52 , &H9E                             'Kanal 5: (36000+4530)=40530
'Data &H46 , &HA0                             'Kanal 6: (36500+4530)=41030


#if Peiler = 40
'Tabelle fr S-Meter Kennlinie, fr Peiler #40
'Data Werte entsprechen der Eingangsgleichspannung
Data 3                                       'S=1-3,  106
Data 4                                       'S=1-2,  107
Data 5                                       'S=1-1,  108
Data 7                                       'S=1,    109
Data 8                                       'S=2,    110
Data 10                                      'S=3,    111
Data 12                                      'S=4,    112
Data 15                                      'S=5,    113
Data 18                                      'S=6,    114
Data 21                                      'S=7,    115
Data 25                                      'S=8,    116
Data 29                                      'S=9,    117
Data 35                                      'S=10,   118
Data 40                                      'S=11,   119
Data 47                                      'S=12,   120
Data 55                                      'S=13,   121
Data 63                                      'S=14,   122
Data 73                                      'S=15,   123
Data 83                                      'S=16,   124
Data 95                                      'S=16+1, 125
Data 108                                     'S=16+2, 126
Data 124                                     'S=16+3, 127
Data 140                                     'S=16+4, 128
Data 158                                     'S=16+5, 129
Data 255                                     'TabEnde,130

'Default Calibrierwerte fr Peiler #40
'BT1: R15=100K, R16=20K
'RX2: TCA440:SIEMENS, R17=3K3, R31=240K, R32=12K, UR=143...480mV
'Filter: CFW 455, SB normal
'
'    UR    Dist                                Att,   25*8=125 Adressen von 131 bis 255
Data 25 , "x" , "x"                          '  0 db, 131 , x-Eintrge fr dB-Anzeige
Data 30 , "x" , "x"                          '  5 db, 136
Data 40 , "x" , "x"                          ' 10 db, 141
Data 51 , "x" , "x"                          ' 15 db, 146
Data 62 , "7km"                              ' 20 db, 151
Data 73 , "5km"                              ' 25 db, 156
Data 84 , "3km"                              ' 30 db, 161
Data 93 , "2km"                              ' 35 db, 166
Data 101 , "1k5"                             ' 40 db, 171
Data 108 , "1km"                             ' 45 db, 176
Data 114 , "700"                             ' 50 db, 181
Data 120 , "500"                             ' 55 db, 186
Data 125 , "300"                             ' 60 db, 191
Data 132 , "200"                             ' 65 db, 196, Einspeisung:-62dBm=180uV, 100m bei PFox=3W
Data 144 , "150"                             ' 70 db, 201
Data 168 , "100"                             ' 75 db, 206
Data 193 , "70m"                             ' 80 db, 211
Data 199 , "50m"                             ' 85 db, 216, bis hier High Gain
Data 132 , "30m"                             ' 90 db, 221, ab hier Low Gain
Data 146 , "20m"                             ' 95 db, 226
Data 168 , "10m"                             '100 db, 231
Data 192 , " 5m"                             '105 db, 236
Data 199 , " 2m"                             '110 db, 241
Data 205 , " 1m"                             '115 db, 246
Data 212 , "<1m"                             '120 db, 251 bis 255
#endif



Data PVStr                                   'Versionstext, 256
Data "ARDF 80m"                              'Logo
Data CallStr                                 'Call

Data "KeinSMet"                              'Txt01
Data "N-Fox:"                                'Txt02
Data "Cal-SMet"                              'Txt03
Data "CalUB"                                 'Txt04
Data "V "                                    'Txt05
Data "  UHR   "                              'Txt06
Data "STP  RES"                              'Txt07
Data "K1-  +K2"                              'Txt08
Data "Betrieb:"                              'Txt09
Data "LowBatt!"                              'Txt10
Data "SetFox"                                'Txt11
Data ",>"                                    'Txt12
Data "manuell!"                              'Txt13
Data "set    ^   "                           'Txt14
Data "Off "                                  'Txt15
Data "set "                                  'Txt16
Data "PE-"                                   'Txt17
Data "VRBuf:"                                'Txt18
Data "automat!"                              'Txt19
Data "W-Ton:"                                'Txt20
Data "URAnz:"                                'Txt21
Data " min  "                                'Txt22
Data "T "                                    'Txt23
Data 4 , "Att"                               'Txt24  (dB)"Att"
Data "<,"                                    'Txt25
Data "K "                                    'Txt26
Data "TxPwr"                                 'Txt27
Data "UR"                                    'Txt28
Data 4 , "m"                                 'Txt29
Data "fffffff"                               'Txt30, 8 Byte frei
Data "fffffff"                               'Txt31, 8 Byte frei
Data "        "                              'Blnk8
Data 255                                     'Empty,               495

Data 1                                       'Aktkanal,            496
Data 1                                       'OldKanal,            497
Data 1                                       'Fuchsnummer,         498
Data 1                                       'Oldmod,              499
Data 3                                       'Lg,                  500
Data 128                                     'OldUreg,             501
Data 251                                     'URegPtr,             502
Data 1                                       'Stp(1)=1             503
Data 10                                      'Stp(2)=10            504
Data 100                                     'Stp(3)=100           505
Data 255 , 100 , 30 , 10 , 3 , 1             'TxPower Zahlenwerte, 506...511


'EEPROM Belegung:

' 0:         frei, nicht nutzbar
' 1 - 11:    frei
'12 - 13:    ZF-Offset &HB211
'11:         VRegRPL, Verst.-Reg Ringpufferlnge
'15:         URAnz
'16:         Korrekturwert fr UB-Anzeige
'17:         FoxPerSec
'18:         FoxPer100stel
'19:         AlertTime, Default Warnzeitpunkt
'20:         Anzahl Fchse
'21 - 22:    Betriebsminuten
'23 - 24:    SpareWord1
'25 - 26     SpareWord2
'27:         Manueller Uhr Start
'28:         TxPKor
'29:         SpareByte3
'30:         SpareByte2
'31:         SpareByte1

'32 - 93:    30 Zwischezeit Speicherpltze

'94 - 95:    Kanal 1 Daten
'96 - 97:    Kanal 2 Daten
'98 - 99:    Kanal 3 Daten
'100-101:    Kanal 4 Daten
'102-103:    Kanal 5 Daten
'104-105:    Kanal 6 Daten

'106-130:    Calibrierwerte fr S-Meter
'131-255:    Calibrierwerte fr UR-Anzeige und Texte fr Entfernungsangabe
'256-505:    Textstrings und automatisch initialisierte Variablen
'506-511:    Mantissen-Werte fr Fuchs Sendeleistung, 256=300,100,30,10,3,1

'-------------------------------------------------------------------------------